/* <inttypes.h> provides the uint32_t style type names */
#include <inttypes.h>
#include <stdio.h>

/* This code is borrowed with small modifications from Chris
 * Metcalfe's libutil package.
 */

#ifndef BITSPERBYTE
#define BITSPERBYTE 8
#endif

int
main(int argc, char* argv[])
{
  uint32_t built = 0;
  uint32_t test = 0x12345678;
  uint8_t* p = (uint8_t*)&test;
  uint32_t i;

  for (i = 0; i < sizeof(uint32_t); ++i) {
    built = (built << BITSPERBYTE) + p[i];
  }
  switch (built) {
  case 0x12345678:
    printf("USSTDL_BIG_ENDIAN\n");     /* low byte contains MS bits */
    break;
  case 0x78563412:
    printf("USSTDL_LITTLE_ENDIAN\n");  /* high byte contains MS bits */
    break;
  default:
    printf("**COUDLN'T CALCULATE ENDIANNESS**\n");
    break;
  }
  return 0;
}
