#ifndef ELF32_H
#define ELF32_H

#include "elf_common.h"

/*
 * ELF header.
 */

typedef struct {
  unsigned char   e_ident[EI_NIDENT];     /* File identification. */
  Elf32_Half      e_type;         /* File type. */
  Elf32_Half      e_machine;      /* Machine architecture. */
  Elf32_Word      e_version;      /* ELF format version. */
  Elf32_Addr      e_entry;        /* Entry point. */
  Elf32_Off       e_phoff;        /* Program header file offset. */
  Elf32_Off       e_shoff;        /* Section header file offset. */
  Elf32_Word      e_flags;        /* Architecture-specific flags. */
  Elf32_Half      e_ehsize;       /* Size of ELF header in bytes. */
  Elf32_Half      e_phentsize;    /* Size of program header entry. */
  Elf32_Half      e_phnum;        /* Number of program header entries. */
  Elf32_Half      e_shentsize;    /* Size of section header entry. */
  Elf32_Half      e_shnum;        /* Number of section header entries. */
  Elf32_Half      e_shstrndx;     /* Section name strings section. */
} Elf32_Ehdr;

/*
 * Section header.
 */

typedef struct {
  Elf32_Word      sh_name;        /* Section name (index into the
				     section header string table). */
  Elf32_Word      sh_type;        /* Section type. */
  Elf32_Word      sh_flags;       /* Section flags. */
  Elf32_Addr      sh_addr;        /* Address in memory image. */
  Elf32_Off       sh_offset;      /* Offset in file. */
  Elf32_Word      sh_size;        /* Size in bytes. */
  Elf32_Word      sh_link;        /* Index of a related section. */
  Elf32_Word      sh_info;        /* Depends on section type. */
  Elf32_Word      sh_addralign;   /* Alignment in bytes. */
  Elf32_Word      sh_entsize;     /* Size of each entry in section. */
} Elf32_Shdr;

/*
 * Program header.
 */

typedef struct {
  Elf32_Word      p_type;         /* Entry type. */
  Elf32_Off       p_offset;       /* File offset of contents. */
  Elf32_Addr      p_vaddr;        /* Virtual address in memory image. */
  Elf32_Addr      p_paddr;        /* Physical address (not used). */
  Elf32_Word      p_filesz;       /* Size of contents in file. */
  Elf32_Word      p_memsz;        /* Size of contents in memory. */
  Elf32_Word      p_flags;        /* Access permission flags. */
  Elf32_Word      p_align;        /* Alignment in memory and file. */
} Elf32_Phdr;

typedef struct {
  Elf32_Word      st_name;        /* Symbol name (index into string table). */
  Elf32_Addr      st_value;       /* Virtual addr symbol maps to. */
  Elf32_Size      st_size;        /* Symbol's size (0 if unknown) */
  unsigned char   st_info;        /* Type and binding info. */
  unsigned char   st_other;       /* Unused. */
  Elf32_Half      st_shndx;       /* Section header index corresponding to this symbol */
} Elf32_Sym;

/* Macros for accessing the fields of st_info. */
#define ELF32_ST_BIND(info)             ((info) >> 4)
#define ELF32_ST_TYPE(info)             ((info) & 0xf)

/* Macro for constructing st_info from field values. */
#define ELF32_ST_INFO(bind, type)       (((bind) << 4) + ((type) & 0xf))

#endif
