#ifndef DECODE_CIRCUIT_H
#define DECODE_CIRCUIT_H

#include "circuit.h"
#include "decode.h"
#include "packets.h"

using namespace std;

extern uint32_t debug_mask;
extern uint32_t superpipeline_factor;

class decoder_circuit : circuit
{

  void recalc() {
    if(debug_mask & 0x00000002) {
      instr_out()->print("DECODE>");
      printf("\n");
    }

    if (!branch_mispredict().mispredicted_branch()) {
      if (!(scoreboard_stall() || rename_stall() || rob_stall())) {
        if (instr_in() != 0) {
          decoder::instr_h the_instr = decoder::run(instr_in());
	  the_instr->instr_num = instr_num;
          the_instr->bus_latency *= superpipeline_factor;
          the_instr->program_counter = program_counter_in();
          the_instr->predicted_pc = predicted_pc_in();
	  the_instr->local_prediction = local_prediction_in();
	  the_instr->global_prediction = global_prediction_in();
          the_instr->global_history = global_history_in();
          the_instr->ra_stack_ptr = ra_stack_ptr_in();
          the_instr->ra_stack_head = ra_stack_head_in();
          instr_out = the_instr;
        }
        else {
          instr_out = decoder::noop;
        }
      }
      // else stall: don't change output registers until scoreboard is ready
    }
    else {
      // branch misprediction: put a noop in the pipeline
      instr_out = decoder::noop;
    }

    instr_num++;
  }

public:

  // inits
  decoder_circuit() :
    circuit(), 

    instr_in(),
    program_counter_in(),
    predicted_pc_in(),

    branch_mispredict(),
    scoreboard_stall(),
    rename_stall(),
    rob_stall(),

    instr_out(decoder::noop),

    instr_num(0)
    {
    }

  // inputs from ifetch:
  inport<uint32_t> instr_in;
  inport<uint32_t> program_counter_in;
  inport<uint32_t> predicted_pc_in;
  inport<bool> local_prediction_in;
  inport<bool> global_prediction_in;
  inport<uint32_t> global_history_in;
  inport<uint32_t> ra_stack_ptr_in;
  inport<uint32_t> ra_stack_head_in;

  inport<branch_packet> branch_mispredict; // indicates whether rob retired a mispredict
  inport<bool> scoreboard_stall;  // indicates scoreboard needs to stall fetch, decode and rename
  inport<bool> rename_stall; // Stall when there are no remaining rename regs on free list
  inport<bool> rob_stall;
	
  // outputs
  statereg<decoder::instr_h> instr_out;

  // internal state
  uint64_t instr_num;
};

#endif /* DECODE_CIRCUIT_H */
