#include "decode.h"

using namespace std;

decoder::instr_h decoder::noop = instr_h(new instr_rep(0, sll, true));

decoder::instr_h
decoder::decode_arith_map(uint32_t instr) {
  switch (get_field::op2(instr))
  {
  case 0x01: {
    instr_h the_instr(new instr_rep(instr, addu));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x03: {
    instr_h the_instr(new instr_rep(instr, subu));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x04: {
    instr_h the_instr(new instr_rep(instr, uand));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x05: {
    instr_h the_instr(new instr_rep(instr, uor));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x06: {
    instr_h the_instr(new instr_rep(instr, uxor));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x07: {
    instr_h the_instr(new instr_rep(instr, nor));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x08: {
    instr_h the_instr(new instr_rep(instr, jr));
    set_regs::one_operand(the_instr, instr);
    the_instr->is_jump = true;
    the_instr->is_indirect_jump = true;
    return the_instr;
    break;
  }
  case 0x09: {
    instr_h the_instr(new instr_rep(instr, jalr));
    set_regs::move_to_special(the_instr, REG_LINK, instr);
    the_instr->is_link = true;
    the_instr->is_jump = true;
    the_instr->is_indirect_jump = true;
    return the_instr;
    break;
  }
  case 0x0a: {
    instr_h the_instr(new instr_rep(instr, slt));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x0b: {
    instr_h the_instr(new instr_rep(instr, sltu));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x11: {
    instr_h the_instr(new instr_rep(instr, daddu));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x13: {
    instr_h the_instr(new instr_rep(instr, dsubu));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }

  case 0x1c: {
    instr_h the_instr(new instr_rep(instr, syscall_strtof));
    set_regs::one_operand(the_instr, instr);
    the_instr->is_syscall = true;
    return the_instr;
    break;
  }
  case 0x1d: {
    instr_h the_instr(new instr_rep(instr, syscall_ftostr));
    set_regs::rrr(the_instr, instr);
    the_instr->is_syscall = true;
    return the_instr;
    break;
  }

  case 0x1e: {
    instr_h the_instr(new instr_rep(instr, syscall_unix));
    the_instr->arch_s_reg = decoder::get_field::rs(instr);
    the_instr->is_syscall = true;
    return the_instr;
    break;
  }
  case 0x1f: {
    instr_h the_instr(new instr_rep(instr, syscall_halt));
    // no operands
    the_instr->is_syscall = true;
    return the_instr;
    break;
  }
  default: {
    // this is a decode error: usually this means that we
    // speculatively miss-fetched off the end of the text segment.
    // Thus, the fact that we fetched and decoded the instruction is
    // not an error (just a branch misprediction).  If it turns out
    // that the true branch path ever does reach this instruction then
    // the processor should take a trap.
    instr_h the_instr(new instr_rep(instr, signaling_noop));
    return the_instr;
    break;
  }
  }
}
decoder::instr_h
decoder::decode_mul_map(uint32_t instr) {
  switch (get_field::op2(instr))
  {
  case 0x00: {
    instr_h the_instr(new instr_rep(instr, sll));
    set_regs::shift_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x02: {
    instr_h the_instr(new instr_rep(instr, srl));
    set_regs::shift_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x03: {
    instr_h the_instr(new instr_rep(instr, sra));
    set_regs::shift_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x04: {
    instr_h the_instr(new instr_rep(instr, sllv));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x06: {
    instr_h the_instr(new instr_rep(instr, srlv));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x07: {
    instr_h the_instr(new instr_rep(instr, srav));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x08: {
    instr_h the_instr(new instr_rep(instr, mull));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  case 0x0a: {
    instr_h the_instr(new instr_rep(instr, div));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 9;
    return the_instr;
    break;
  }
  case 0x0b: {
    instr_h the_instr(new instr_rep(instr, divu));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 9;
    return the_instr;
    break;
  }
  case 0x0c: {
    instr_h the_instr(new instr_rep(instr, mulh));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  case 0x0d: {
    instr_h the_instr(new instr_rep(instr, mulhu));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  case 0x10: {
    instr_h the_instr(new instr_rep(instr, dsll));
    set_regs::shift_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x12: {
    instr_h the_instr(new instr_rep(instr, dsrl));
    set_regs::shift_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x13: {
    instr_h the_instr(new instr_rep(instr, dsra));
    set_regs::shift_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x14: {
    instr_h the_instr(new instr_rep(instr, dsllv));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x16: {
    instr_h the_instr(new instr_rep(instr, dsrlv));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x17: {
    instr_h the_instr(new instr_rep(instr, dsrav));
    set_regs::rrr(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x18: {
    instr_h the_instr(new instr_rep(instr, dmull));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  case 0x1a: {
    instr_h the_instr(new instr_rep(instr, ddiv));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 9;
    return the_instr;
    break;
  }
  case 0x1b: {
    instr_h the_instr(new instr_rep(instr, ddivu));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 9;
    return the_instr;
    break;
  }
  case 0x1c: {
    instr_h the_instr(new instr_rep(instr, dmulh));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  case 0x1d: {
    instr_h the_instr(new instr_rep(instr, dmulhu));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  default: {
    // this is a decode error: usually this means that we
    // speculatively miss-fetched off the end of the text segment.
    // Thus, the fact that we fetched and decoded the instruction is
    // not an error (just a branch misprediction).  If it turns out
    // that the true branch path ever does reach this instruction then
    // the processor should take a trap.
    instr_h the_instr(new instr_rep(instr, signaling_noop));
    return the_instr;
    break;
  }
  }
}

decoder::instr_h
decoder::decode_fpu_map(uint32_t instr) {
  switch (get_field::op2(instr))
  {
  case 0x00: {
    instr_h the_instr(new instr_rep(instr, add_s));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x01: {
    instr_h the_instr(new instr_rep(instr, sub_s));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x02: {
    instr_h the_instr(new instr_rep(instr, mul_s));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x03: {
    instr_h the_instr(new instr_rep(instr, div_s));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 9;
    return the_instr;
    break;
  }
  case 0x04: {
    instr_h the_instr(new instr_rep(instr, c_eq_s));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x05: {
    instr_h the_instr(new instr_rep(instr, abs_s));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 1;
    return the_instr;
    break;
  }
  case 0x06: {
    instr_h the_instr(new instr_rep(instr, trunc_l_s));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x07: {
    instr_h the_instr(new instr_rep(instr, neg_s));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 1;
    return the_instr;
    break;
  }
  case 0x09: {
    instr_h the_instr(new instr_rep(instr, cvt_s_l));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x0a: {
    instr_h the_instr(new instr_rep(instr, cvt_s_d));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x0b: {
    instr_h the_instr(new instr_rep(instr, cvt_l_s));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x0e: {
    instr_h the_instr(new instr_rep(instr, c_lt_s));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x0f: {
    instr_h the_instr(new instr_rep(instr, c_le_s));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x10: {
    instr_h the_instr(new instr_rep(instr, add_d));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x11: {
    instr_h the_instr(new instr_rep(instr, sub_d));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x12: {
    instr_h the_instr(new instr_rep(instr, mul_d));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x13: {
    instr_h the_instr(new instr_rep(instr, div_d));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 9;
    return the_instr;
    break;
  }
  case 0x14: {
    instr_h the_instr(new instr_rep(instr, c_eq_d));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x15: {
    instr_h the_instr(new instr_rep(instr, abs_d));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 1;
    return the_instr;
    break;
  }
  case 0x16: {
    instr_h the_instr(new instr_rep(instr, trunc_l_d));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x17: {
    instr_h the_instr(new instr_rep(instr, neg_d));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 1;
    return the_instr;
    break;
  }
  case 0x19: {
    instr_h the_instr(new instr_rep(instr, cvt_d_l));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x1a: {
    instr_h the_instr(new instr_rep(instr, cvt_d_s));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x1b: {
    instr_h the_instr(new instr_rep(instr, cvt_l_d));
    set_regs::one_operand(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x1e: {
    instr_h the_instr(new instr_rep(instr, c_lt_d));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  case 0x1f: {
    instr_h the_instr(new instr_rep(instr, c_le_d));
    set_regs::rrr(the_instr, instr);
    the_instr->bus_latency = 4;
    return the_instr;
    break;
  }
  default: {
    // this is a decode error: usually this means that we
    // speculatively miss-fetched off the end of the text segment.
    // Thus, the fact that we fetched and decoded the instruction is
    // not an error (just a branch misprediction).  If it turns out
    // that the true branch path ever does reach this instruction then
    // the processor should take a trap.
    instr_h the_instr(new instr_rep(instr, signaling_noop));
    return the_instr;
    break;
  }
  }
}

decoder::instr_h
decoder::run(uint32_t instr) {
  switch (get_field::opcode(instr))
  {
  case 0x00: {
    return decode_mul_map(instr);
    break;
  }
  case 0x04: {
    instr_h the_instr(new instr_rep(instr, beq));
    set_regs::branch_store(the_instr, instr);
    the_instr->is_branch = true;
    return the_instr;
    break;
  }
  case 0x05: {
    instr_h the_instr(new instr_rep(instr, bne));
    set_regs::branch_store(the_instr, instr);
    the_instr->is_branch = true;
    return the_instr;
    break;
  }
  case 0x06: {
    instr_h the_instr(new instr_rep(instr, j));
    // no operands
    the_instr->is_jump = true;
    return the_instr;
    break;
  }
  case 0x07: {
    instr_h the_instr(new instr_rep(instr, jal));
    the_instr->arch_dest_reg = REG_LINK;
    the_instr->is_jump = true;
    the_instr->is_link = true;
    return the_instr;
    break;
  }
  case 0x08: {
    return decode_arith_map(instr);
    break;
  }
  case 0x0c: {
    instr_h the_instr(new instr_rep(instr, bltz));
    set_regs::branch(the_instr, instr);
    the_instr->is_branch = true;
    return the_instr;
    break;
  }
  case 0x0d: {
    instr_h the_instr(new instr_rep(instr, blez));
    set_regs::branch(the_instr, instr);
    the_instr->is_branch = true;
    return the_instr;
    break;
  }
  case 0x0e: {
    instr_h the_instr(new instr_rep(instr, bgez));
    set_regs::branch(the_instr, instr);
    the_instr->is_branch = true;
    return the_instr;
    break;
  }
  case 0x0f: {
    instr_h the_instr(new instr_rep(instr, bgtz));
    set_regs::branch(the_instr, instr);
    the_instr->is_branch = true;
    return the_instr;
    break;
  }

  case 0x10: {
    return decode_fpu_map(instr);
    break;
  }

  case 0x28: {
    instr_h the_instr(new instr_rep(instr, daddiu));
    set_regs::reg_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x29: {
    instr_h the_instr(new instr_rep(instr, addiu));
    set_regs::reg_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x2a: {
    instr_h the_instr(new instr_rep(instr, slti));
    set_regs::reg_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x2b: {
    instr_h the_instr(new instr_rep(instr, sltiu));
    set_regs::reg_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x2c: {
    instr_h the_instr(new instr_rep(instr, andi));
    set_regs::reg_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x2d: {
    instr_h the_instr(new instr_rep(instr, ori));
    set_regs::reg_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x2e: {
    instr_h the_instr(new instr_rep(instr, xori));
    set_regs::reg_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x2f: {
    instr_h the_instr(new instr_rep(instr, aui));
    set_regs::reg_imm(the_instr, instr);
    return the_instr;
    break;
  }
  case 0x30: {
    instr_h the_instr(new instr_rep(instr, lb));
    set_regs::reg_imm(the_instr, instr);
    the_instr->is_load = true;
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  case 0x31: {
    instr_h the_instr(new instr_rep(instr, lh));
    set_regs::reg_imm(the_instr, instr);
    the_instr->is_load = true;
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  case 0x32: {
    instr_h the_instr(new instr_rep(instr, lw));
    set_regs::reg_imm(the_instr, instr);
    the_instr->is_load = true;
    the_instr->bus_latency = 2;
    return the_instr;
    break;
  }
  case 0x33: {
    instr_h the_instr(new instr_rep(instr, ld));
    set_regs::reg_imm(the_instr, instr);
    the_instr->is_load = true;
    the_instr->bus_latency = 2;
    return the_instr;
    break;
  }
  case 0x34: {
    instr_h the_instr(new instr_rep(instr, lbu));
    set_regs::reg_imm(the_instr, instr);
    the_instr->is_load = true;
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  case 0x35: {
    instr_h the_instr(new instr_rep(instr, lhu));
    set_regs::reg_imm(the_instr, instr);
    the_instr->is_load = true;
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  case 0x36: {
    instr_h the_instr(new instr_rep(instr, lwu));
    set_regs::reg_imm(the_instr, instr);
    the_instr->is_load = true;
    the_instr->bus_latency = 3;
    return the_instr;
    break;
  }
  case 0x38: {
    instr_h the_instr(new instr_rep(instr, sb));
    set_regs::branch_store(the_instr, instr);
    the_instr->is_store = true;
    return the_instr;
    break;
  }
  case 0x39: {
    instr_h the_instr(new instr_rep(instr, sh));
    set_regs::branch_store(the_instr, instr);
    the_instr->is_store = true;
    return the_instr;
    break;
  }
  case 0x3a: {
    instr_h the_instr(new instr_rep(instr, sw));
    set_regs::branch_store(the_instr, instr);
    the_instr->is_store = true;
    return the_instr;
    break;
  }
  case 0x3b: {
    instr_h the_instr(new instr_rep(instr, sd));
    set_regs::branch_store(the_instr, instr);
    the_instr->is_store = true;
    return the_instr;
    break;
  }
  default: {
    // this is a decode error: usually this means that we
    // speculatively miss-fetched off the end of the text segment.
    // Thus, the fact that we fetched and decoded the instruction is
    // not an error (just a branch misprediction).  If it turns out
    // that the true branch path ever does reach this instruction then
    // the processor should take a trap.
    instr_h the_instr(new instr_rep(instr, signaling_noop));
    return the_instr;
    break;
  }
  }
}
