#ifndef CIRCUIT_H
#define CIRCUIT_H

#include <stdio.h>
#include <assert.h>
#include <set>

using namespace std;

class clocked_net
{
private:
  typedef set<clocked_net*> net_list_t;
  static net_list_t* net_list;
public:
  clocked_net();
  virtual void do_pulse() = 0;
  static void pulse();
  virtual ~clocked_net();
};

template <class T>
class port
{
public:
  virtual T& operator()() const = 0;
};

class circuit
{
private:
  typedef set<circuit*> circuit_list_t;
  static circuit_list_t* circuit_list;
public:
  circuit();
  virtual void recalc() = 0;
  static void level();
  virtual ~circuit();
};

template <class T>
class statereg : clocked_net, public port<const T>
{
  T next_state;
  T current_state;

  void do_pulse() { current_state = next_state; }
  void operator=(const statereg& v) { }
public:
  statereg() : clocked_net() { }
  statereg(const T& val) : clocked_net(), next_state(val), current_state(val) { }
  statereg(const statereg& v) : clocked_net(), next_state(v.next_state), current_state(v.current_state) { }

  void operator=(const T& v) { next_state = v; }
  const T& operator()() const { return current_state; }
  void reset(const T& val) { next_state = val; current_state = val; }
};

template<class T>
class inport : public port<const T>
{
  const port<const T>* the_net;
public:
  inport() : the_net(0) { }
  void attach(const port<const T>*const n) {
    assert(the_net == 0);
    the_net = n;
  }
  const T& operator()() const {
    assert(the_net != 0);
    return the_net->operator()();
  }
};

template <class T>
class memo_func : clocked_net, public port<const T>
{
  bool valid;
  T current_state;
  void do_pulse() { valid = 0; }
  virtual T do_access() const = 0;
public:
  memo_func() : clocked_net() { valid = 0; }
  const T& operator()() const {
    if (!valid) {
      memo_func* th = const_cast<memo_func*>(this);
      th->current_state = th->do_access();
      th->valid = 1;
    }
    return current_state; 
  }
};

template <class S, class T>
class member_outport : public memo_func<T>
{
  S* the_object;
  typedef T (S::* member_func_t)();
  member_func_t the_member_func;
  T do_access() const { return (the_object->*the_member_func)(); }
public:
  member_outport(S* obj, member_func_t mf) :
    memo_func<T>(),
    the_object(obj),
    the_member_func(mf)
    { }
};

#define outport inport

#endif /* CIRCUIT_H */
