#ifndef BTB_H
#define BTB_H

#include <inttypes.h>

using namespace std;

typedef vector<uint32_t> btbline_t;

class btb
{
	vector<btbline_t> btb_data;
	vector<btbline_t> btb_tags;
	vector<btbline_t> btb_lru;
	uint32_t entries;
	uint32_t assoc;

	// Changes lru values based on a btb entry-way reference
	void lru_ref(uint32_t addr, uint32_t way) { 
		// address should be btb_address not PC

		uint32_t old_way_lru_val = btb_lru[addr][way];
		for(uint32_t i = 0; i < assoc; i++) {
			if(i == way)
				btb_lru[addr][i] = 0;
			else if(btb_lru[addr][i] < old_way_lru_val)
				btb_lru[addr][i]++;
		}
	}

	int32_t lru_evict(uint32_t addr) {
		// This will be brute force with having to 2 * assoc look at the lru
		// Could use some work. :-(

		uint32_t least_rec_used_way = 0;
		uint32_t least_rec_used_val = assoc - 1;
		for(uint32_t i = 0; i < assoc; i++) {
			if(btb_lru[addr][i] == least_rec_used_val) {
				least_rec_used_way = i;
				btb_lru[addr][i] = 0;
				continue;
			}
		}

		for(uint32_t i = 0; i < assoc; i++) {
			if(i != least_rec_used_way)
				btb_lru[addr][i]++;
		}

		return least_rec_used_way;
	}
		
public:
	btb(uint32_t num_entries, uint32_t assoc_num) :
		btb_data(num_entries, btbline_t(assoc_num, 0)),
		btb_tags(num_entries, btbline_t(assoc_num, 0)),
		btb_lru(num_entries, btbline_t(assoc_num,0)),
		entries(num_entries),
		assoc(assoc_num)
		{ 
			// Initialize the LRU entries
			for(uint32_t i = 0; i < entries; i++) {
				for(uint32_t n = 0; n < assoc; n++) {
					btb_lru[i][n] = n;
				}
			}
		}

	int32_t check(uint32_t addr) {
          uint32_t btb_addr = (addr >> 2) & (entries - 1);
		for(uint32_t i = 0; i < assoc; i++) {
			if(addr == btb_tags[btb_addr][i])
				return i;
		}
		return -1;
	}

	uint32_t get_value(uint32_t addr, uint32_t way) {
          uint32_t btb_addr = (addr >> 2) & (entries - 1);
		lru_ref(btb_addr, way);
		return btb_data[btb_addr][way];
	}

	void update_value(uint32_t addr, uint32_t value) {
          uint32_t btb_addr = (addr >> 2) & (entries - 1);
		int32_t way = check(addr);
		if(way >= 0) 
			lru_ref(btb_addr, way);
		else
			way = lru_evict(btb_addr);
			
		btb_tags[btb_addr][way] = addr;
		btb_data[btb_addr][way] = value;
	}
};

#endif
