/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include "PLACEHOLDERS.h"
#include "menu_types.h"
#include "stdlib.h"
#include "FS.h"
#include "buttons.h"
#include "bmptoflash.h"
#include "string.h"
#include "display.h"
#include "comm.h"
#include "cdisp.h"
struct MusicEntry  {
    char filename[8];
    char name[48];
    int32_t next;
    int32_t reserved;
} __attribute__((packed));


/* Kept, so that we can access them later without getting back into the file */
struct MusicEntry music_list[3];
int16_t list_length;

int16_t
get_music_menu(struct Item* ret_items, uint16_t index)
{
    /* TODO: Panic if fail */
    
    FS_FILE *pFile = FS_FOpen("index.txt", "rb");
    if(pFile == NULL) {
        draw_text("failed to open the index", 0, 0);
    }
    int rv;
    rv = FS_FSeek(pFile, index * sizeof(struct MusicEntry), FS_SEEK_SET);
    if (rv != 0) {
        draw_text("failed to seek", 0, 1);
    }
    
    uint32_t nread = FS_FRead(music_list, sizeof(struct MusicEntry), 3, pFile);
    FS_FSeek(pFile, 0, FS_SEEK_END);
    list_length = FS_FTell(pFile)/sizeof(struct MusicEntry);
    FS_FClose(pFile);

    int i;
    for (i = 0; i < 3; i++) {
        if (index + i < list_length) {
            ret_items[i].name = music_list[i].name;
        } else {
            ret_items[i].name = "...";
        }
    }
    return list_length;
}

int8_t display_music(char *filename) {
    FS_FILE *bmp = FS_FOpen(filename, "rb");
    //int retval = bmp_to_flash(bmp);
    
    return 0;
}

void
music_menu_select(int16_t index)
{
    extern char *dispdata;
    extern char *passive_dispdata;
    
    char filename[13];
    if (index < list_length) {
        memcpy(filename, music_list[index % 3].filename, 8);
        filename[8] = '\0';
        strcat(filename, ".bmp");
        
        FS_FILE *bmp = FS_FOpen(filename, "rb");
        if(bmp == NULL) {
            draw_text("failed to open the bmp", 0, 0);
            draw_text(filename, 0, 1);
        }
        int retval = bmp_to_flash(bmp, passive_dispdata);
        FS_FClose(bmp);
    }
    enable_image_dma = 1;
    char *temp = dispdata;
    clear_menu_buffer();
    dispdata = passive_dispdata;
    passive_dispdata = temp;
    struct MusicEntry current_entry = music_list[index % 3];
    while (current_entry.next != 0) {
        struct MusicEntry next_entry;
        FS_FILE *pFile = FS_FOpen("hidden.txt", "rb");
        FS_FSeek(pFile, (current_entry.next - 1) * sizeof(struct MusicEntry), FS_SEEK_SET);
        FS_FRead(&next_entry, sizeof(struct MusicEntry), 1, pFile);
        FS_FClose(pFile);
        
        memcpy(filename, next_entry.filename, 8);
        filename[8] = '\0';
        strcat(filename, ".bmp");
        FS_FILE *bmp = FS_FOpen(filename, "rb");
        if(bmp == NULL) {
            draw_text("failed to open the bmp", 0, 0);
            draw_text(filename, 0, 1);
        }
        int retval = bmp_to_flash(bmp, passive_dispdata);
        FS_FClose(bmp);
        /* Next button press goes to next page */
        button_pressed = NO_BUTTON;
        while (button_pressed == NO_BUTTON) {
            uint8_t rv = receive_idle();
            if (rv != 0) {
                enable_image_dma = 0;
                return;
            }
        }
        button_pressed = NO_BUTTON;
        char *temp = dispdata;
        dispdata = passive_dispdata;
        passive_dispdata = temp; 
        new_frame = 1;
        current_entry = next_entry;
    }
    
    button_pressed = NO_BUTTON;
    while (button_pressed == NO_BUTTON) { 
            uint8_t rv = receive_idle();
        if (rv != 0) {
            enable_image_dma = 0;
            return;
        }
    }
    button_pressed = NO_BUTTON;
    enable_image_dma = 0;
        
}


struct Menu music_menu = {
    get_music_menu,
    music_menu_select
};
/* [] END OF FILE */
