/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include <stdint.h>
#include "menu_types.h"
#include "device.h"
char metronome_minus[] = "-";
char metronome_plus[] = "+";
char metronome_bpm[] = "120 BPM";

uint16_t metronome_speed = 240;


int16_t
get_metronome_menu(struct Item* ret_items, uint16_t index)
{
    ret_items[0].name = metronome_plus;
    ret_items[2].name = metronome_minus;
    
    char string[8];
    char temp[8];

    int i = 0;
    int n;
    int tempbpm = metronome_speed;

    
    while(tempbpm >= 10)
    {
        temp[i] = (tempbpm % 10) + '0';
        tempbpm /= LCD_Char_TEN;
        i++;
    }

    temp[i] = (tempbpm % 10) + '0';
    n = i;

    for (; i > 0; i--)
    {
        string[n - i] = temp[i];
    }

    string[n] = temp[0];
    string[n + 1] = 'b';
    string[n + 2] = 'p';
    string[n + 3] = 'm';
    string[n + 4] = '\0';

    strcpy(metronome_bpm, string);
    ret_items[1].name = metronome_bpm;
    return 3;
}

uint16_t
calc_metro_pwm( uint16_t speed ) {
    #define METRO_CLOCK 10000.0
    return METRO_CLOCK * 60.0/((float) speed);
}

uint8_t metronome_on = 0;

void
toggle_metronome() {
    if (metronome_on) {
        Control_Reg_Metronome_Write(0);
        metronome_on = 0;
    } else {
        PWM_LED_WritePeriod(calc_metro_pwm(metronome_speed));
        Control_Reg_Metronome_Write(1);
        metronome_on = 1;
    }
}

void
metronome_menu_select(int16_t index)
{
    switch (index) {
    case 0:
        metronome_speed += 2;
        break;
    case 2:
        metronome_speed -= 2;
        break;
    case 1:
        toggle_metronome();
        break;
     default:
        /*panic*/
        break;
     }
     PWM_LED_WritePeriod(calc_metro_pwm(metronome_speed));
 }

struct Menu metronome_menu = {
    get_metronome_menu,
    metronome_menu_select
};
/* [] END OF FILE */
