/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include "device.h"
#include "cdisp.h"
#include "stdint.h"
#include "bmptoflash.h"
// Buffer for a line of character data 

// Buffer for generic display data, with hack to allow large alignment.
extern char *dispdata_hack;
unsigned char __attribute__((aligned(256))) cdisp_buf[100];
extern char *dispdata;
char *passive_dispdata;

uint8_t enable_image_dma  = 0;
int doit = 0;
int yindex = 0;
int fixlines(int xchar) {
/*    xchar += 2;
    if (xchar >= 50) xchar -= 50;*/
    return xchar;
}
CY_ISR(isr_HPorch_ISR)
{
    int8 ychar = yindex / 30;
    if (ychar >= 16) return;
    int32_t yfont = yindex % 30;
    if (yfont < 0) {return;};
    int xchar;
    for (xchar = 0; xchar < 50; xchar++) {
        uint8_t charcode = *(active_text_buffer + ychar * 50 + fixlines(xchar));
        cdisp_buf[(xchar * 2)] = fnt_bits[yfont * 4080/8 + (int16) charcode * 2];
        cdisp_buf[(xchar * 2) + 1] = fnt_bits[yfont * 4080/8 + (int16) charcode * 2 + 1];
    }
        yindex++;

}


/* dispdata is not aligned for us to the right precision.  Force it to be. */
void fix_dispdata()
{
    uint32_t loc = (uint32_t) dispdata_hack;

    if (loc == 0x8000) {
        dispdata += 0x8000;
    }
    passive_dispdata = dispdata + 0x10000;
}

uint8 DMA_Disp_Chan;
uint8 DMA_Disp_TD[13];
uint8 DMA_Char_TD[2];
uint8 DMA_Char_Chan;
/* Initialize DMA for character register and display register */
void DMA_Init()
{   
    
    int32_t i;

    #define DMA_Disp_SRC_BASE ((uint32) dispdata)
    #define DMA_DST_BASE (CYDEV_PERIPH_BASE)
    #define DMA_Char_SRC_BASE ((uint32) cdisp_buf)
    
    /* 1 byte per burst, 1 request per burst for both channels */
    DMA_Disp_Chan = DMA_Disp_DmaInitialize(1, 1, HI16(DMA_Disp_SRC_BASE), HI16(CYDEV_PERIPH_BASE));
    DMA_Char_Chan = DMA_Char_DmaInitialize(1, 1, HI16(DMA_Char_SRC_BASE), HI16(CYDEV_PERIPH_BASE));

    /* Allocate TD's (TODO:Check if chaining like this is truly, 100% necessary).  Chain them for display */
    
    
    DMA_Disp_TD[12] = CyDmaTdAllocate();
    /* Last one loops upon itself to prevent it from restarting things */
    CyDmaTdSetConfiguration(DMA_Disp_TD[12], 1, DMA_Disp_TD[12], 0);
    CyDmaTdSetAddress(DMA_Disp_TD[12], LO16((uint32) dispdata), LO16((uint32)ShiftReg_disp_IN_FIFO_VAL_LSB_PTR));
    for (i = 11; i >= 0; i--) {
        DMA_Disp_TD[i] = CyDmaTdAllocate();
        /* 4000 bytes in length, chain to next one, increment memory but not target */
        CyDmaTdSetConfiguration(DMA_Disp_TD[i], 4000, DMA_Disp_TD[i + 1], TD_INC_SRC_ADR);
        /* Set base and dest targets */
        CyDmaTdSetAddress(DMA_Disp_TD[i], LO16(i * 4000 + (uint32)dispdata), LO16((uint32)ShiftReg_disp_IN_FIFO_VAL_LSB_PTR));
    }
    /* For the character TD's, set up a line's worth */
    DMA_Char_TD[0] = CyDmaTdAllocate();
    DMA_Char_TD[1] = CyDmaTdAllocate();
    /* Idle one loops back upon itself */
    CyDmaTdSetConfiguration(DMA_Char_TD[1], 1, DMA_Char_TD[1], 0);
    CyDmaTdSetAddress(DMA_Char_TD[1], LO16(DMA_Char_SRC_BASE), LO16((uint32) ShiftReg_char_IN_FIFO_VAL_LSB_PTR));
    /* Non idle one doesn't */
    
    CyDmaTdSetConfiguration(DMA_Char_TD[0], 100, DMA_Char_TD[0], TD_INC_SRC_ADR);
    CyDmaTdSetAddress(DMA_Char_TD[0], LO16(DMA_Char_SRC_BASE), LO16((uint32) ShiftReg_char_IN_FIFO_VAL_LSB_PTR));
    
    /* Set initial TD's and enable */
    CyDmaChSetInitialTd(DMA_Disp_Chan, DMA_Disp_TD[0]);
    CyDmaChSetInitialTd(DMA_Char_Chan, DMA_Char_TD[0]);
    CyDmaChEnable(DMA_Disp_Chan, 1);
    CyDmaChEnable(DMA_Char_Chan, 1);
    
}

CY_ISR(isr_Backporch_ISR)
{
    yindex = 0;
    if (stop_disp_clock) {
        Disp_Clk_In_Stop();
        stop_disp_clock = 0;
    }
    CyDmaClearPendingDrq(DMA_Disp_Chan);
    CyDmaClearPendingDrq(DMA_Char_Chan);
    CyDmaChDisable(DMA_Disp_Chan);
    CyDmaChDisable(DMA_Char_Chan);
    uint8_t status = 255;
    while (status & STATUS_TD_ACTIVE) {
    
        CyDmaChStatus(DMA_Disp_Chan, NULL, &status);
    }
    status = 255;
    while (status & STATUS_TD_ACTIVE) {
    
        CyDmaChStatus(DMA_Char_Chan, NULL, &status);
    }
    
    int32_t i;
    /*for (i = 0; i < 13; i++) {
        CyDmaTdFree(DMA_Disp_TD[i]);
    }*/

    ShiftReg_disp_Stop();
    *ShiftReg_disp_SR_AUX_CONTROL_PTR = 1;
    *ShiftReg_disp_SR_AUX_CONTROL_PTR = 0;
    if (enable_image_dma) ShiftReg_disp_Start();
    ShiftReg_disp_WriteData(dispdata[0]);
    
    ShiftReg_char_Stop();
    *ShiftReg_char_SR_AUX_CONTROL_PTR = 1;
    *ShiftReg_char_SR_AUX_CONTROL_PTR = 0;
    ShiftReg_char_Start();
    
    if (new_frame == 1) {
        DMA_Disp_DmaRelease();
        DMA_Char_DmaRelease();
        for (i = 0; i < 13; i++) {
            CyDmaTdFree(DMA_Disp_TD[i]);
        }
        CyDmaTdFree(DMA_Char_TD[0]);
        CyDmaTdFree(DMA_Char_TD[1]);
        DMA_Init();
        new_frame = 0;
    } else {
        CyDmaChSetInitialTd(DMA_Disp_Chan, DMA_Disp_TD[0]);
        CyDmaChSetInitialTd(DMA_Char_Chan, DMA_Char_TD[0]);
        CyDmaChEnable(DMA_Disp_Chan, 1);
        CyDmaChEnable(DMA_Char_Chan, 1);
    }
}

void blank_palette() {
    Control_Reg_mono_1_Write(0);
    Control_Reg_mono_0_Write(3);
}

void
display_init()
{
    enable_image_dma = 0;
    blank_palette();
    fix_dispdata();
    DMA_Init();
    /* Enable necessary pwm/registers */
    if (enable_image_dma) ShiftReg_disp_Start();
    ShiftReg_char_Start();
    dispcontrol_PWM_horiz_pulse_Start();
    dispcontrol_PWM_vert_pulse_Start();
    isr_Backporch_StartEx(isr_Backporch_ISR);
    isr_HPorch_StartEx(isr_HPorch_ISR);

}
/* [] END OF FILE */
