/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include <stdint.h>
#include "PLACEHOLDERS.h"
#include "device.h"
#include "FS.h"
#include "display.h"
#include "cdisp.h"
#include "buttons.h"
#include "bmptoflash.h"
#define CMD_FLIP 1
#define CMD_TEXT 2
#define CMD_DIST 3
#define CMD_BUTT 4

char message_buffer[256] = "";
struct MessageHeader {
    char magic[3];
    uint8_t length;
    uint8_t type;
    uint8_t reserved;
    char payload[];
} __attribute__ ((packed));

struct MessageHeader *message_header = (struct MessageHeader*) message_buffer;

uint8_t receive_idle();


int16_t message_pos = 0;
char magic[] = "MSG";
int magic_pos = 0;
int8_t message_len;
int light = 1;
void toggle_light() {
    Control_Reg_Metronome_Write(light);
    light = !light;
}
uint8_t process_data(uint8_t c) {
    if (message_pos == 0) {
        
        if (c == magic[magic_pos]) {
            message_buffer[magic_pos] = c;
            magic_pos++;
            if (magic_pos == 3) {
                message_pos = 3;
                return 0;
            }
        } else {
            magic_pos = 0;
        }
        return 0;
    }
    
    /* Message detected! Find length.*/
    if (message_pos == 3) {
        message_buffer[3] = c;
        message_len = c;
        message_pos++;
        return 0;
    }
    /* Just store data until we're finished */
    message_buffer[message_pos++] = c;
    if (message_pos < message_len) {
        return 0;
    }
    message_pos = 0;
    magic_pos = 0;
    /* Now parse! */
    if (message_header->type == CMD_FLIP) {
        toggle_light();
        int internal_location = 6;
        /* Every eight is filename */
        extern char *dispdata;
        extern char *passive_dispdata;
        if (internal_location + 8 <= message_len) {
            char filename[13];
        
            memcpy(filename, &message_buffer[internal_location], 8);
            filename[8] = '\0';
            strcat(filename, ".bmp");
            
            FS_FILE *bmp = FS_FOpen(filename, "rb");
            if(bmp == NULL) {
                draw_text("failed to open the bmp", 0, 0);
                draw_text(filename, 0, 1);
            } else {
                int retval = bmp_to_flash(bmp, passive_dispdata);
            }
            FS_FClose(bmp);
        }
        enable_image_dma = 1;
        char *temp = dispdata;
        clear_menu_buffer();
        dispdata = passive_dispdata;
        passive_dispdata = temp;
        
        internal_location += 8;
        while (internal_location + 8 <= message_len) {
            char filename[13];
            memcpy(filename, &message_buffer[internal_location], 8);
            filename[8] = '\0';
            strcat(filename, ".bmp");
            
            FS_FILE *bmp = FS_FOpen(filename, "rb");
            int retval = bmp_to_flash(bmp, passive_dispdata);
            FS_FClose(bmp);
            
            
            /* Next button press goes to next page */
            button_pressed = NO_BUTTON;
            while (button_pressed == NO_BUTTON) {
                uint8_t rv = receive_idle();
                if (rv != 0) {
                    enable_image_dma = 0;
                    return 1;
                }
            }
            button_pressed = NO_BUTTON;
            char *temp = dispdata;
            dispdata = passive_dispdata;
            passive_dispdata = temp; 
            new_frame = 1;
            internal_location += 8;
        }
        
        button_pressed = NO_BUTTON;
        while (button_pressed == NO_BUTTON) {
            int rv = receive_idle();
            if (rv != 0) {
                enable_image_dma = 0;
                return 1;
            }            
        }
        button_pressed = NO_BUTTON;
        enable_image_dma = 0;
    } else if (message_header->type == CMD_BUTT) {
        button_pressed = message_header->payload[0];
        if (message_header->payload[0] == 2) toggle_light();
    } else if (message_header->type == CMD_TEXT) {
        uint8_t x = message_header->payload[0];
        uint8_t y = message_header->payload[1];
        toggle_light();
        draw_text(&message_buffer[sizeof(struct MessageHeader) + 2], x, y);
    }
    return 0;
}

uint8_t 
receive_idle()
{
//toggle_light();
    if (UART_Xbee_GetRxBufferSize() > 00) {
        //toggle_light();
        //UART_Xbee_ReadRxData();
        return process_data(UART_Xbee_ReadRxData());
    }
    return 0;
}

/* [] END OF FILE */
