/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include "FS.H"
#include <device.h>
#include <string.h>
#include "comm.h"
#include <stdint.h>

uint8_t stop_disp_clock;
struct __attribute__ ((__packed__)) BitmapFileHeader {
    char Type[2];
    uint32_t Size;
    uint16_t Reserved1;
    uint16_t Reserved2;
    uint32_t OffBits;
 };
 
 struct __attribute__ ((__packed__)) BitmapImageHeader {
    uint32_t Size;
    uint32_t Width;
    int32_t Height;
    int16_t Planes;
    int16_t BitCount;
    int32_t Compression;
    int32_t SizeImage;
    int32_t XPelsPerMeter;
    int32_t YPelsPerMeter;
    int32_t ClrUsed;
    int32_t ClrImportant;
 };

uint8_t new_frame = 0;
/* Assume we have the open filehandle */


uint8_t
bmp_to_flash_try(FS_FILE *bmp, char *dispdata)
{
    if (bmp == NULL) {
        return 123;
    }
    uint8_t extra_head = 0;
    unsigned char buf[256];
    struct BitmapFileHeader bf;
    struct BitmapImageHeader bi;
    uint8_t upside_down = 1;
    bf.Type[0] = 'A';
    bf.Type[1] = 'B';
    FS_Read(bmp, &bf, sizeof(bf));
    if (strncmp("BM", bf.Type, 2) != 0) {
        return 1;
    }
    
    FS_Read(bmp, &bi, sizeof(bi));
    if (bi.Size != 40) {
        if (bi.Size == 108) {
            extra_head = 108 - 40;
        } else {
            return 2;
        }
    }
    if (bi.Width != 800) {
        return 3;
    }
    
    if (bi.Height == 480) {
        upside_down = 1;
    } else if (bi.Height == -480) {
        upside_down = 0;
    } else {
        return 4;
    }
    
    if (bi.Planes != 1) {
        return 5;
    }
    
    if (bi.BitCount != 1) {
        return 6;
    }
    
    if (bi.Compression != 0) {
        return 7;
    }
    /* Chomp off data from windows 4.x bitmaps */
    if (extra_head) {
        FS_Read(bmp, buf, extra_head);
    }
    /* Done checking the header.  Data time! */
    /* Color data:  Right now, monochrome.  One is black (000000FF), one is white (FFFFFFFF) */
    /* If white is first, we have to XOR the image */
    uint32_t colormap[2];
    FS_Read(bmp, colormap, 8);
    
    if ((colormap[0] & 0x00FFFFFF) > 0x00800000) {
        Control_Reg_mono_0_Write(3);
    } else {
        Control_Reg_mono_0_Write(0);
    }
    
    if ((colormap[1] & 0x00FFFFFF) > 0x00800000) {
        Control_Reg_mono_1_Write(3);
    } else {
        Control_Reg_mono_1_Write(0);
    }
    
    /* If the picture is not upside-down, we can do it the normal way, load a row and boit */
    /* If not, we have to be careful: load a half-row first, then 187 regular rows */

    


    uint16_t array = (((uint32_t) dispdata) - CY_FLASH_BASE)/CY_FLASH_SIZEOF_ARRAY;
    uint16_t base_row = (((uint32_t) dispdata) - CY_FLASH_BASE - array * CY_FLASH_SIZEOF_ARRAY)/CY_FLASH_SIZEOF_ROW;

    CySetTemp();
    char flashbuf[288];
    uint16_t retval = CySetFlashEEBuffer(flashbuf);
    LCD_Char_PrintInt16((uint32_t) 55);
    
    if (upside_down) {
        /* Process:
         * Read in a scanline
         * Place it ending at the marker in the buf
         * Write the buf when the marker overflows
         * If overflowed, write the overflowing into the end of the buf
         * Reset the pointer
         * If need be, optimizable by reading straight to the buffer
         */
        uint8_t row = 187;
        int buf_marker = 128;
        char scanline[100];
        int i;
        for (i = 0; i < 480; i++) {
            FS_Read(bmp, scanline, 100);
            if (buf_marker >= 100) {
                /* Case 1:  We have enough legroom */
                memcpy(buf + buf_marker - 100, scanline, 100);
                buf_marker -= 100;
                if (buf_marker == 0) {

                    buf_marker = 256;
                    CyWriteRowData(array, base_row + row, buf);
                    row--;
                }
            } else {
                /* Case 2:  Not enough room */
                memcpy(buf, scanline + 100 - buf_marker, buf_marker);
                CyWriteRowData(array, base_row + row, buf);
                row--;
                memcpy(buf + 256 - (100 - buf_marker), scanline, 100 - buf_marker);
                buf_marker = 256 - (100 - buf_marker);
            }
        }
    } else {
        int i;
        toggle_light();
        for (i = 0; i < 187; i++) {
            FS_Read(bmp, buf, 256);
            CyWriteRowData(array, base_row + i, buf);
        }
        
        for (i = 128; i < 256; i++ ) {
            buf[i] = 0;
        }
        
        FS_Read(bmp, buf, 128);
        CyWriteRowData(array, base_row + 187, buf);
    }
    new_frame = 1;
    return 0;
}

uint8_t
bmp_to_flash(FS_FILE *bmp, char *dispdata) {
    stop_disp_clock = 1;
    while (stop_disp_clock);
    
    uint8_t rv = bmp_to_flash_try(bmp, dispdata);
    Disp_Clk_In_Start();
    return rv;
}

int waiting_for_write = 0;
uint16_t delay_write_array;
uint16_t delay_write_row;
unsigned char *delay_write_buf;

void write_flash_delay(uint16_t array, uint16_t base_row, unsigned char *buf) {
/*
    delay_write_array = array;
    delay_write_buf = buf;
    delay_write_row = base_row;
    waiting_for_write = 1;
    while (waiting_for_write);
    */
    
}

/* [] END OF FILE */