%{
    open Mp5common
%}

/* DO NOT CHANGE TOKEN DEFINITIONS */

%token <int> INTEGER_LITERAL LONG_LITERAL
%token <float> FLOAT_LITERAL DOUBLE_LITERAL
%token <bool> BOOLEAN_LITERAL
%token <char> CHARACTER_LITERAL
%token <string> STRING_LITERAL IDENTIFIER
%token     EOF
  ABSTRACT BOOLEAN BREAK BYTE CASE CATCH CHAR CLASS CONST CONTINUE
  DO DOUBLE ELSE EXTENDS FINAL FINALLY FLOAT FOR DEFAULT IMPLEMENTS IMPORT
  INSTANCEOF INT INTERFACE LONG NATIVE NEW GOTO IF PUBLIC SHORT SUPER SWITCH
  SYNCHRONIZED PACKAGE PRIVATE PROTECTED TRANSIENT RETURN VOID STATIC WHILE THIS
  THROW THROWS TRY VOLATILE STRICTFP
  NULL_LITERAL LPAREN RPAREN LBRACE RBRACE LBRACK RBRACK SEMICOLON COMMA DOT
  EQ GT LT NOT COMP QUESTION COLON EQEQ LTEQ GTEQ NOTEQ ANDAND OROR
  PLUSPLUS MINUSMINUS PLUS MINUS MULT DIV AND OR XOR MOD LSHIFT RSHIFT
  URSHIFT PLUSEQ MINUSEQ MULTEQ DIVEQ ANDEQ OREQ XOREQ MODEQ LSHIFTEQ RSHIFTEQ
  URSHIFTEQ

/* DO NOT CHANGE THE NAME OR THE TYPE OF THE MAIN NONTERMINAL */
%start program
%type <Mp5common.program> program
%right ELSE /* Keep this directive, or you'll get a conflict */

/* ADD PRECEDENCES AND ASSOCIATIVITY HERE */

%%

program:
    classdecl+			{ }

classdecl:
    CLASS IDENTIFIER LBRACE vardecl* methoddecl* RBRACE 			{ }
  | CLASS IDENTIFIER EXTENDS IDENTIFIER LBRACE vardecl* methoddecl* RBRACE 	{ }

vardecl:
    exp_type IDENTIFIER SEMICOLON		{ } 
  | STATIC exp_type IDENTIFIER SEMICOLON	{ }

methoddecl:
    PUBLIC exp_type IDENTIFIER LPAREN (exp_type IDENTIFIER (COMMA exp_type IDENTIFIER)*)? RPAREN 
    LBRACE vardecl* stmt* RETURN expression SEMICOLON RBRACE    { }

exp_type:
    exp_type LBRACK RBRACK	{ }
  | BOOLEAN			{ }
  | IDENTIFIER			{ }
  | FLOAT			{ }
  | INT				{ }

stmt:
    LBRACE stmt* RBRACE		{ }
  | IF LPAREN expression RPAREN stmt ELSE stmt	{ }  
  /* Do NOT remove the %prec directive below 
     Otherwise you'll get a conflict and lose points
  */
  | IF LPAREN expression RPAREN stmt %prec ELSE { }

  | WHILE LPAREN expression RPAREN stmt		{ }
  | IDENTIFIER DOT IDENTIFIER DOT IDENTIFIER LPAREN expression RPAREN SEMICOLON	{ }
  | IDENTIFIER EQ expression SEMICOLON		{ }
  | IDENTIFIER LBRACK expression RBRACK EQ expression SEMICOLON			{ }
  | BREAK SEMICOLON		{ }
  | CONTINUE SEMICOLON		{ }
  | SWITCH LPAREN expression RPAREN LBRACE case* DEFAULT COLON stmt+ RBRACE	{ }

case:
    CASE INTEGER_LITERAL COLON stmt+		{ }

expression:
    expression AND expression							{ }
  | expression OR expression							{ }
  | expression LT expression							{ }
  | expression PLUS expression							{ }
  | expression MINUS expression							{ }
  | expression MULT expression							{ }
  | expression DIV expression							{ }
  | expression LBRACK expression RBRACK 					{ }
  | expression DOT IDENTIFIER							{ if $3="length" then Length $1 else raise(Parsing.Parse_error) } 
  | expression DOT IDENTIFIER LPAREN (expression (COMMA expression)*)? RPAREN 	{ }
  | INTEGER_LITERAL								{ }
  | FLOAT_LITERAL								{ }
  | STRING_LITERAL								{ }
  | NULL_LITERAL								{ }
  | BOOLEAN_LITERAL 								{ }
  | IDENTIFIER									{ }
  | THIS									{ }
  | NEW exp_type LBRACK expression RBRACK					{ }
  | NEW IDENTIFIER LPAREN RPAREN 						{ }
  | NOT expression 								{ } 
  | LPAREN expression RPAREN							{ }
 
