{
  open Mp4common
}

(* definitions for letters and alpha-numeric chars *)
let jletter = ['A' - 'Z'] | ['a' - 'z']
let jletterdigit = jletter | ['0' - '9']

(* You can assign names to commonly-used regular expressions in this part
   of the code, to save the trouble of re-typing them each time they are used *)

(* these are useful for line comments *)
let LineTerminator = (['\r' '\n'] | "\r\n")
let InputCharacter = [^'\r' '\n']

(* whitespace *)
let WhiteSpace = LineTerminator | ['\t' ' ']

(* string characters *)
let StringCharacter = [^'\r' '\n' '\"' '\\']

rule tokenize = parse
  (* your rules go here *)

  (* whitespace *)
  | WhiteSpace             { tokenize lexbuf (* ignore *) }


  | eof                    { EOF } 

  (* error fallback *)
  | _ as c                 { failwith ("Illegal character \"" ^ String.make 1 c) }

(* do not modify this function: *)
{ let lextest s = tokenize (Lexing.from_string s)

  let get_all_tokens s =
      let b = Lexing.from_string (s^"\n") in
      let rec g () = 
      match tokenize b with EOF -> []
      | t -> t :: g () in
      g ()
 }

