(* MP9 common file -- many useful functions included here *)


(* helpful functions *)
let incr x = x + 1
and decr x = x - 1
and funmod f x y = fun z -> if x=z then y else f z
and compose f g = fun x -> f (g x)

(* types *)
type 'a fset = int * ('a -> bool)
type 'a set = 'a -> bool

let empty = (0, fun x -> false) (* for finite sets *)
let empty_inf = fun x -> false  (* for infinite sets *)

(* Church Numerals *)
let compose f g = fun x -> f (g x)
let show nbar = nbar succ 0;;
let id = fun x -> x
let zero = fun f -> id
let one = id
let two = fun f -> compose f f
let three = fun f -> compose f (compose f f)

