let output = ref "";;
let myprint n = 
  print_int n; print_string " ";
  output := !output ^ string_of_int n
;;

let outputOk () =
  try (
  let len = String.length !output
  in let half1 = String.sub !output 0 (len / 2)
     and half2 = String.sub !output (len / 2) (len / 2)
     in half1=half2
  ) with e -> false
let isEq i j =
  if (i = j) then
   (let res = outputOk() in output := ""; res)
  else
   ((output := ""); false)

type program = Program of (class_decl list)

and class_decl = Class of id * id   
        * (var_decl list) 
        * (method_decl list)

and var_decl = Var of var_kind * exp_type * id

and var_kind = Static | NonStatic

and method_decl = Method of exp_type 
        * id 
        * ((exp_type * id) list) 
        * (var_decl list) 
        * (statement list) 
        * exp

and statement = Block of (statement list)
    | If of exp * statement * statement
    | While of exp * statement
    | Println of exp
    | Assignment of id * exp
    | ArrayAssignment of id * exp * exp
    | Break
    | Continue
    | Switch of exp 
        * ((int * (statement list)) list)   (* cases *)
        * (statement list)   (* default *)

and exp = Operation of exp * binary_operation * exp
    | Array of exp * exp
    | Length of exp
    | MethodCall of exp * id * (exp list)
    | Integer of int
    | True
    | False
    | Id of id
    | This
    | NewArray of exp_type * exp
    | NewId of id
    | Not of exp
    | Null
    | String of string
    | Float of float

and binary_operation = And
    | Or
    | LessThan
    | Plus
    | Minus
    | Multiplication
    | Division

and exp_type = ArrayType of exp_type
    | Boolean 
    | IntType
    | ObjectType of id 
    | FloatType

and id = string

(*
type symbol_table =
    ((class_name * method_name * (variable list)) list)

and variable =
    Field of class_name
        * exp_type
        * string
    | Argument of exp_type
        * string
    | MethodVar of exp_type
        * string

and class_name =
    string

type method_name =
    string
*)

(* types for intermediate representation *)
type memloc = string
and  label = string
and  name = string

type instr =
   MOVE of expr * memloc
 | LABEL of label
 | JUMP of label
 | CJUMP of memloc * label * label
 | PRINT of memloc
 | MOVEIND of expr * memloc (* not used *)
 | RET of memloc

and expr =
   CONST of int
 | BINOP of binary_operation * memloc * memloc
 | CALL of name * memloc
 | LOAD of memloc
 | LOADIND of memloc (* not used *)
 | MALLOC of memloc  (* not used *)

type methodLL = name * memloc list * instr list

type prog = methodLL list

(* location, label generation *)
let gen str = 
  let x = ref 0
  in
    fun () -> let res = !x in x := res + 1; str ^ (string_of_int res)

let genloc = gen "t"
and newlabel = gen "label"


(*** emulator ***)

let rec execFun f i prog = 
  let (args, instrs) = prog f
  in match args with
     [arg] -> execInstrs instrs instrs [arg,i] prog
   | _     -> failwith "execFun: exactly 1 arg per fun call, please"

and execInstrs instrs body values prog =
  let rec find_label code label =
    match code with
       LABEL l::code' when l = label -> code'
     | _::code' -> find_label code' label
     | [] -> failwith "execInstrs: label not found"
  in
    match instrs with 
       []            -> failwith "execInstrs: missing RET"
     | MOVE(e,t)::is -> 
         execInstrs is body ((t,execExpr e values prog)::
           List.remove_assoc t values) prog
     | LABEL l::is   -> execInstrs is body values prog
     | JUMP l::_     -> execInstrs (find_label body l) body values prog
     | CJUMP(t,l1,l2)::_ -> execInstrs 
        (find_label body (if List.assoc t values = 0 then l2 else l1))
         body values prog
     | PRINT t::is   -> myprint (List.assoc t values);
                        execInstrs is body values prog
     | MOVEIND(_,_)::is -> failwith "moveind not implemented"
     | RET t::is     -> List.assoc t values

and execExpr e values prog =
  match e with
     CONST i   -> i
   | BINOP(op,t1,t2) -> 
     let v1 = List.assoc t1 values and v2 = List.assoc t2 values
     in
     (
       match op with
          And            -> if v1 <> 0 && v2 <> 0 then 1 else 0
        | Or             -> if v1 <> 0 || v2 <> 0 then 1 else 0
        | LessThan    -> if v1 < v2 then 1 else 0
        | Plus           -> v1 + v2
        | Minus          -> v1 - v2
        | Multiplication -> v1 * v2
        | Division       -> v1 / v2
     )
   | CALL(f,t) -> 
     (
       match prog f with 
          ([arg],instrs) -> execFun f (List.assoc t values) prog
        | _ -> failwith "execExpr: call to fun of bad format"
      )
   | LOAD t    -> List.assoc t values
   | LOADIND t -> failwith "not implemented"
   | MALLOC t  -> failwith "not implemented"

and execProg prog =
  (* execute "main" function with 0 *)
  let progFun f= 
    let rec aux funs =
      match funs with
        [] -> failwith "Function does not exist."
      | (fn,pl,il)::rest -> if f=fn then (pl,il) else aux rest
    in aux prog
  in execFun "main" 0 (progFun)

let shortCircuitOn = ref false
let turnOnShortCircuit () = 
  shortCircuitOn := true
let turnOffShortCircuit () =
  shortCircuitOn := false


let id_to_name x:name = x ;;
let id_to_memloc x:memloc = x ;;


