type program = Program of (class_decl list)

and class_decl = Class of id * id   (* class [class_name] extends [superclass_name] {*)
        * (var_decl list)
        * (method_decl list)

and method_decl = Method of exp_type
        * id
        * ((exp_type * id) list)
(*      * (var_decl list)
        * (statement list)
        * exp
*)

and var_decl = Var of var_kind * exp_type * id

and var_kind = Static | NonStatic

and statement = Block of (statement list)
    | If of exp * statement * statement
    | While of exp * statement
    | Println of exp
    | Assignment of id * exp
    | ArrayAssignment of id * exp * exp
    | Break
    | Continue
    | Switch of exp
        * ((int * (statement list)) list)   (* cases *)
        * (statement list)   (* default *)

and exp = Operation of exp * binary_operation * exp
    | Array of exp * exp
    | Length of exp
    | MethodCall of exp * id * (exp list)
    | Integer of int
    | True
    | False
    | Id of id
    | This
    | NewArray of exp_type * exp
    | NewId of id
    | Not of exp
    | Null
    | String of string
    | Float of float

and binary_operation = And
    | Or
    | GreaterThan
    | Plus
    | Minus
    | Multiplication
    | Division

and exp_type = ArrayType of exp_type
    | Boolean
    | IntType
    | ObjectType of id
    | FloatType

and id = string


type token = 
    EOF
  | ABSTRACT | BOOLEAN | BREAK | BYTE | CASE | CATCH | CHAR | CLASS | CONST | CONTINUE | STRING
  | DO | DOUBLE | ELSE | EXTENDS | FINAL | FINALLY | FLOAT | FOR | DEFAULT | IMPLEMENTS | IMPORT
  | INSTANCEOF | INT | INTERFACE | LONG | NATIVE | NEW | GOTO | IF | PUBLIC | SHORT | SUPER | SWITCH
  | SYNCHRONIZED | PACKAGE | PRIVATE | PROTECTED | TRANSIENT | RETURN | VOID | STATIC | WHILE | THIS
  | THROW | THROWS | TRY | VOLATILE | STRICTFP
  | BOOLEAN_LITERAL of bool
  | NULL_LITERAL | LPAREN | RPAREN | LBRACE | RBRACE | LBRACK | RBRACK | SEMICOLON | COMMA | DOT
  | EQ | GT | LT | NOT | COMP | QUESTION | COLON | EQEQ | LTEQ | GTEQ | NOTEQ | ANDAND | OROR
  | PLUSPLUS | MINUSMINUS | PLUS | MINUS | MULT | DIV | AND | OR | XOR | MOD | LSHIFT | RSHIFT
  | URSHIFT | PLUSEQ | MINUSEQ | MULTEQ | DIVEQ | ANDEQ | OREQ | XOREQ | MODEQ | LSHIFTEQ | RSHIFTEQ
  | URSHIFTEQ
  | CHARACTER_LITERAL of char
  | INTEGER_LITERAL of int
  | LONG_LITERAL of int
  | FLOAT_LITERAL of float
  | DOUBLE_LITERAL of float
  | IDENTIFIER of string
  | STRING_LITERAL of string
