(* CS421 - Spring 2009
 * MP3
 *
 *)

open Mp3common

(* Problem 1 *)
(* These functions take an Abstract Syntax Tree and return a program code string.
 * Each print_* function takes care of each AST constructor, and pretty_print provides an interface.
 * 
 * pretty_print: Mp3common.program -> string = <fun>
 *)
let rec p_indent n = match n with
    0 -> ""
    | i -> "    " ^ (p_indent (i - 1));;

let rec pretty_print p = match p with
    Program(cl) ->
        print_classes cl

and print_classes cl = match cl with
    [] -> ""
    | Class(id1, id2, vl, ml)::cl2 -> 
        "class " ^ id1
        ^ (if id2 = "" then "" else (" extends " ^ id2)) ^ " {\n"
        ^ print_vars vl 1
        ^ "\n"
        ^ print_methods ml
        ^ "}\n"
        ^ print_classes cl2

and print_methods ml = 
    raise (Failure "not implemented yet")

and print_vars vl n = 
    raise (Failure "not implemented yet")


(* Problem 2 *)
(* These functions take an Abstract Syntax Tree and return a simple symbol table.
 * Each sb_* function takes care of each AST constructor, and symboltable provides an interface.
 * 
 * symboltable: Mp3common.program -> (Mp3common.class_name * string * Mp3common.variable list) list = <fun>
 *)
let rec symboltable prog = 
    raise (Failure "not implemented yet")

(* Problem 2 extra *)
(* These functions take an Abstract Syntax Tree and return a simple symbol table including inheritances.
 * It traverses the result from the function of Problem2, to take care of inheritances. And, symboltable2 provides an interface.
 * 
 * symboltable2: Mp3common.program -> (Mp3common.class_name * string * Mp3common.variable list) list = <fun>
 *)
let rec symboltable2 prog =
    raise (Failure "not implemented yet")
