/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.eck.mdb;

import edu.hws.eck.mdb.I18n;
import edu.hws.eck.mdb.MandelbrotFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;

public class LauncherApplet
extends JApplet {
    private String launchCommand;
    private String closeCommand;
    private JButton launchButton;
    private MandelbrotFrame frame;

    public void init() {
        this.launchCommand = I18n.tr("launcherApplet.launchCommand", new Object[0]);
        this.closeCommand = I18n.tr("launcherApplet.closeCommand", new Object[0]);
        this.launchButton = new JButton(this.launchCommand);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.launchButton, "Center");
        this.launchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LauncherApplet.this.doClick();
            }
        });
    }

    private void doClick() {
        this.launchButton.setEnabled(false);
        if (this.frame == null) {
            this.frame = new MandelbrotFrame(true);
            this.frame.adjustToScreenIfNecessary();
            this.frame.setDefaultCloseOperation(2);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent evt) {
                    LauncherApplet.this.launchButton.setText(LauncherApplet.this.closeCommand);
                    LauncherApplet.this.launchButton.setEnabled(true);
                }

                public void windowClosed(WindowEvent evt) {
                    LauncherApplet.this.launchButton.setText(LauncherApplet.this.launchCommand);
                    LauncherApplet.this.launchButton.setEnabled(true);
                    LauncherApplet.this.frame = null;
                }
            });
            this.frame.setVisible(true);
        } else {
            this.frame.dispose();
            this.frame.getMandelbrotPanel().getDisplay().shutDownThreads();
        }
    }

    public void destroy() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame.getMandelbrotPanel().getDisplay().shutDownThreads();
            this.frame = null;
        }
    }
}

