/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;

public class JUnitPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_TEST = "isTest";
    private static final String PROPERTY_CAN_LAUNCH_AS_JUNIT_TEST = "canLaunchAsJUnit";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IJavaElement element;
        if (!(receiver instanceof IAdaptable)) {
            throw new IllegalArgumentException("Element must be of type 'IAdaptable', is " + receiver == null ? "null" : receiver.getClass().getName());
        }
        if (receiver instanceof IJavaElement) {
            element = (IJavaElement)receiver;
        } else if (receiver instanceof IResource) {
            element = JavaCore.create((IResource)((IResource)receiver));
            if (element == null) {
                return false;
            }
        } else {
            IAdaptable iAdaptable = (IAdaptable)receiver;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) == null) {
                IResource resource;
                IAdaptable iAdaptable2 = (IAdaptable)receiver;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = JavaCore.create((IResource)(resource = (IResource)iAdaptable2.getAdapter((Class)clazz2)))) == null) {
                    return false;
                }
            }
        }
        if (PROPERTY_IS_TEST.equals(property)) {
            return this.isJUnitTest(element);
        }
        if (PROPERTY_CAN_LAUNCH_AS_JUNIT_TEST.equals(property)) {
            return this.canLaunchAsJUnitTest(element);
        }
        throw new IllegalArgumentException("Unknown test property '" + property + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canLaunchAsJUnitTest(IJavaElement element) {
        try {
            switch (element.getElementType()) {
                case 2: 
                case 3: {
                    return true;
                }
                case 4: {
                    return ((IPackageFragment)element).hasChildren();
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    return this.isJUnitTest(element);
                }
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private boolean isJUnitTest(IJavaElement element) {
        try {
            IType testType = null;
            if (element instanceof ICompilationUnit) {
                testType = ((ICompilationUnit)element).findPrimaryType();
            } else if (element instanceof IClassFile) {
                testType = ((IClassFile)element).getType();
            } else if (element instanceof IType) {
                testType = (IType)element;
            } else if (element instanceof IMember) {
                testType = ((IMember)element).getDeclaringType();
            }
            if (testType != null && testType.exists()) {
                return TestSearchEngine.isTestOrTestSuite(testType);
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

