/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director.app;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.StringHelper;
import org.eclipse.equinox.internal.p2.director.app.Activator;
import org.eclipse.equinox.internal.p2.director.app.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.PlanExecutionHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.CompoundQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class DirectorApplication
implements IApplication {
    private static final CommandLineOption OPTION_HELP = new CommandLineOption(new String[]{"-help", "-h", "-?"}, null, Messages.Help_Prints_this_command_line_help);
    private static final CommandLineOption OPTION_LIST = new CommandLineOption(new String[]{"-list", "-l"}, null, Messages.Help_List_all_IUs_found_in_repos);
    private static final CommandLineOption OPTION_INSTALL_IU = new CommandLineOption(new String[]{"-installIU", "-installIUs", "-i"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_Installs_the_listed_IUs);
    private static final CommandLineOption OPTION_UNINSTALL_IU = new CommandLineOption(new String[]{"-uninstallIU", "-uninstallIUs", "-u"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_Uninstalls_the_listed_IUs);
    private static final CommandLineOption OPTION_DESTINATION = new CommandLineOption(new String[]{"-destination", "-d"}, Messages.Help_lt_path_gt, Messages.Help_The_folder_in_which_the_targetd_product_is_located);
    private static final CommandLineOption OPTION_METADATAREPOS = new CommandLineOption(new String[]{"-metadatarepository", "metadatarepositories", "-m"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_A_list_of_URLs_denoting_metadata_repositories);
    private static final CommandLineOption OPTION_ARTIFACTREPOS = new CommandLineOption(new String[]{"-artifactrepository", "artifactrepositories", "-a"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_A_list_of_URLs_denoting_artifact_repositories);
    private static final CommandLineOption OPTION_REPOSITORIES = new CommandLineOption(new String[]{"-repository", "repositories", "-r"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_A_list_of_URLs_denoting_colocated_repositories);
    private static final CommandLineOption OPTION_VERIFY_ONLY = new CommandLineOption(new String[]{"-verifyOnly"}, null, Messages.Help_Only_verify_dont_install);
    private static final CommandLineOption OPTION_PROFILE = new CommandLineOption(new String[]{"-profile", "-p"}, Messages.Help_lt_name_gt, Messages.Help_Defines_what_profile_to_use_for_the_actions);
    private static final CommandLineOption OPTION_FLAVOR = new CommandLineOption(new String[]{"-flavor", "-f"}, Messages.Help_lt_name_gt, Messages.Help_Defines_flavor_to_use_for_created_profile);
    private static final CommandLineOption OPTION_SHARED = new CommandLineOption(new String[]{"-shared", "-s"}, Messages.Help_lb_lt_path_gt_rb, Messages.Help_Use_a_shared_location_for_the_install);
    private static final CommandLineOption OPTION_BUNDLEPOOL = new CommandLineOption(new String[]{"-bundlepool", "-b"}, Messages.Help_lt_path_gt, Messages.Help_The_location_where_the_plugins_and_features_will_be_stored);
    private static final CommandLineOption OPTION_PROFILE_PROPS = new CommandLineOption(new String[]{"-profileproperties"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_A_list_of_properties_in_the_form_key_value_pairs);
    private static final CommandLineOption OPTION_ROAMING = new CommandLineOption(new String[]{"-roaming"}, null, Messages.Help_Indicates_that_the_product_can_be_moved);
    private static final CommandLineOption OPTION_P2_OS = new CommandLineOption(new String[]{"-p2.os"}, null, Messages.Help_The_OS_when_profile_is_created);
    private static final CommandLineOption OPTION_P2_WS = new CommandLineOption(new String[]{"-p2.ws"}, null, Messages.Help_The_WS_when_profile_is_created);
    private static final CommandLineOption OPTION_P2_ARCH = new CommandLineOption(new String[]{"-p2.arch"}, null, Messages.Help_The_ARCH_when_profile_is_created);
    private static final CommandLineOption OPTION_P2_NL = new CommandLineOption(new String[]{"-p2.nl"}, null, Messages.Help_The_NL_when_profile_is_created);
    private static final String BUNDLE_CORE = "org.eclipse.equinox.p2.core";
    private static final String BUNDLE_ENGINE = "org.eclipse.equinox.p2.engine";
    private static final String BUNDLE_EXEMPLARY_SETUP = "org.eclipse.equinox.p2.exemplarysetup";
    private static final String BUNDLE_FRAMEWORKADMIN_EQUINOX = "org.eclipse.equinox.frameworkadmin.equinox";
    private static final String BUNDLE_SIMPLE_CONFIGURATOR_MANIPULATOR = "org.eclipse.equinox.simpleconfigurator.manipulator";
    private static final Integer EXIT_ERROR = new Integer(13);
    private static final String FLAVOR_DEFAULT = "tooling";
    private static final String PROP_P2_DATA_AREA = "eclipse.p2.data.area";
    private static final String PROP_P2_PROFILE = "eclipse.p2.profile";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private IArtifactRepositoryManager artifactManager;
    private IMetadataRepositoryManager metadataManager;
    private URI[] artifactReposForRemoval;
    private URI[] metadataReposForRemoval;
    private final List artifactRepositoryLocations = new ArrayList();
    private final List metadataRepositoryLocations = new ArrayList();
    private final List rootsToInstall = new ArrayList();
    private final List rootsToUninstall = new ArrayList();
    private String bundlePool = null;
    private String destination;
    private String sharedLocation;
    private String flavor;
    private boolean printHelpInfo = false;
    private boolean printIUList = false;
    private boolean verifyOnly = false;
    private boolean roamingProfile = false;
    private boolean stackTrace = false;
    private String profileId;
    private String profileProperties;
    private String ws;
    private String os;
    private String arch;
    private String nl;
    private IEngine engine;
    private boolean noProfileId = false;
    private PackageAdmin packageAdmin;
    private ServiceReference packageAdminRef;
    private IPlanner planner;
    private String preservedDataArea;
    private String preservedProfile;
    private boolean restartCore;
    private boolean restartEngine;
    private boolean restartExemplarySetup;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    private static void getURIs(List uris, String spec) throws CoreException {
        if (spec == null) {
            return;
        }
        String[] urlSpecs = StringHelper.getArrayFromString((String)spec, (char)',');
        int i = 0;
        while (i < urlSpecs.length) {
            try {
                uris.add(URIUtil.fromString((String)urlSpecs[i]));
            }
            catch (URISyntaxException e) {
                throw new ProvisionException(NLS.bind((String)Messages.unable_to_parse_0_to_uri_1, (Object)urlSpecs[i], (Object)e.getMessage()));
            }
            ++i;
        }
    }

    private static String getRequiredArgument(String[] args, int argIdx) throws CoreException {
        String arg;
        if (argIdx < args.length && !(arg = args[argIdx]).startsWith("-")) {
            return arg;
        }
        throw new ProvisionException(NLS.bind((String)Messages.option_0_requires_an_argument, (Object)args[argIdx - 1]));
    }

    private static void parseIUsArgument(List vnames, String arg) {
        String[] roots = StringHelper.getArrayFromString((String)arg, (char)',');
        int i = 0;
        while (i < roots.length) {
            vnames.add(VersionedName.parse((String)roots[i]));
            ++i;
        }
    }

    private static String processFileArgument(String arg) {
        if (arg.startsWith("file:")) {
            arg = arg.substring(5);
        }
        return Path.fromOSString((String)arg).toOSString();
    }

    private ProfileChangeRequest buildProvisioningRequest(IProfile profile, IInstallableUnit[] installs, IInstallableUnit[] uninstalls) {
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        this.markRoots(request, installs);
        this.markRoots(request, uninstalls);
        request.addInstallableUnits(installs);
        request.removeInstallableUnits(uninstalls);
        return request;
    }

    private void cleanupRepositories() {
        int i;
        if (this.artifactReposForRemoval != null && this.artifactManager != null) {
            i = 0;
            while (i < this.artifactReposForRemoval.length && this.artifactReposForRemoval[i] != null) {
                this.artifactManager.removeRepository(this.artifactReposForRemoval[i]);
                ++i;
            }
        }
        if (this.metadataReposForRemoval != null && this.metadataManager != null) {
            i = 0;
            while (i < this.metadataReposForRemoval.length && this.metadataReposForRemoval[i] != null) {
                this.metadataManager.removeRepository(this.metadataReposForRemoval[i]);
                ++i;
            }
        }
    }

    private Collector collectRootIUs(Query query, Collector collector) {
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        int top = this.metadataRepositoryLocations.size();
        if (top == 0) {
            return ProvisioningHelper.getInstallableUnits(null, (Query)query, (Collector)collector, (IProgressMonitor)nullMonitor);
        }
        Collector result = collector != null ? collector : new Collector();
        IQueryable[] locationQueryables = new IQueryable[top];
        int i = 0;
        while (i < top) {
            locationQueryables[i] = new LocationQueryable((URI)this.metadataRepositoryLocations.get(i));
            ++i;
        }
        return new CompoundQueryable(locationQueryables).query(query, result, (IProgressMonitor)nullMonitor);
    }

    private IInstallableUnit[] collectRoots(IProfile profile, List rootNames, boolean forInstall) throws CoreException {
        ArrayList allRoots = new ArrayList();
        int top = rootNames.size();
        int i = 0;
        while (i < top) {
            VersionedName rootName = (VersionedName)rootNames.get(i);
            Version v = rootName.getVersion();
            InstallableUnitQuery query = new InstallableUnitQuery(rootName.getId(), Version.emptyVersion.equals((Object)v) ? VersionRange.emptyRange : new VersionRange(v, true, v, true));
            Collector roots = forInstall ? this.collectRootIUs((Query)new CompositeQuery(new Query[]{query, new LatestIUVersionQuery()}), new Collector()) : new Collector();
            if (roots.size() <= 0) {
                roots = profile.query((Query)query, roots, (IProgressMonitor)new NullProgressMonitor());
            }
            if (roots.size() <= 0) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_IU, (Object)rootName)));
            }
            allRoots.addAll(roots.toCollection());
            ++i;
        }
        return allRoots.toArray(new IInstallableUnit[allRoots.size()]);
    }

    synchronized Bundle getBundle(String symbolicName) {
        if (this.packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = this.packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    private String getEnvironmentProperty() {
        HashMap<String, String> values = new HashMap<String, String>();
        if (this.os != null) {
            values.put("osgi.os", this.os);
        }
        if (this.nl != null) {
            values.put("osgi.nl", this.nl);
        }
        if (this.ws != null) {
            values.put("osgi.ws", this.ws);
        }
        if (this.arch != null) {
            values.put("osgi.arch", this.arch);
        }
        return values.isEmpty() ? null : this.toString(values);
    }

    private IProfile initializeProfile() throws CoreException {
        IProfile profile;
        if (this.profileId == null) {
            this.profileId = "_SELF_";
            this.noProfileId = true;
        }
        if ((profile = ProvisioningHelper.getProfile((String)this.profileId)) == null) {
            String currentFlavor;
            String env;
            if (this.destination == null) {
                this.missingArgument("destination");
            }
            if (this.flavor == null) {
                this.flavor = System.getProperty("eclipse.p2.configurationFlavor", FLAVOR_DEFAULT);
            }
            Properties props = new Properties();
            props.setProperty("org.eclipse.equinox.p2.installFolder", this.destination);
            props.setProperty("org.eclipse.equinox.p2.flavor", this.flavor);
            if (this.bundlePool == null) {
                props.setProperty("org.eclipse.equinox.p2.cache", this.sharedLocation == null ? this.destination : this.sharedLocation);
            } else {
                props.setProperty("org.eclipse.equinox.p2.cache", this.bundlePool);
            }
            if (this.roamingProfile) {
                props.setProperty("org.eclipse.equinox.p2.roaming", Boolean.TRUE.toString());
            }
            if ((env = this.getEnvironmentProperty()) != null) {
                props.setProperty("org.eclipse.equinox.p2.environments", env);
            }
            if (this.profileProperties != null) {
                this.putProperties(this.profileProperties, props);
            }
            if ((currentFlavor = (profile = ProvisioningHelper.addProfile((String)this.profileId, (Properties)props)).getProperty("org.eclipse.equinox.p2.flavor")) != null && !currentFlavor.endsWith(this.flavor)) {
                throw new RuntimeException(NLS.bind((String)Messages.flavor_0_inconsistent_with_flavor_1, (Object)this.flavor, (Object)currentFlavor));
            }
        }
        return profile;
    }

    private void initializeRepositories() throws CoreException {
        if (this.rootsToInstall.isEmpty()) {
            return;
        }
        if (this.artifactRepositoryLocations == null) {
            this.missingArgument("-artifactRepository");
        }
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.artifactManager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        if (this.artifactManager == null) {
            throw new ProvisionException(Messages.Application_NoManager);
        }
        int removalIdx = 0;
        boolean anyValid = false;
        this.artifactReposForRemoval = new URI[this.artifactRepositoryLocations.size()];
        int i = 0;
        while (i < this.artifactRepositoryLocations.size()) {
            URI location = (URI)this.artifactRepositoryLocations.get(i);
            try {
                if (!this.artifactManager.contains(location)) {
                    this.artifactManager.loadRepository(location, null);
                    this.artifactReposForRemoval[removalIdx++] = location;
                }
                anyValid = true;
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)e.getStatus());
            }
            ++i;
        }
        if (!anyValid) {
            throw new ProvisionException(Messages.Application_NoRepositories);
        }
        if (this.metadataRepositoryLocations == null) {
            this.missingArgument("metadataRepository");
        }
        BundleContext bundleContext2 = Activator.getContext();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.metadataManager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName());
        if (this.metadataManager == null) {
            throw new ProvisionException(Messages.Application_NoManager);
        }
        removalIdx = 0;
        anyValid = false;
        int top = this.metadataRepositoryLocations.size();
        this.metadataReposForRemoval = new URI[top];
        int i2 = 0;
        while (i2 < top) {
            URI location = (URI)this.metadataRepositoryLocations.get(i2);
            try {
                if (!this.metadataManager.contains(location)) {
                    this.metadataManager.loadRepository(location, null);
                    this.metadataReposForRemoval[removalIdx++] = location;
                }
                anyValid = true;
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)e.getStatus());
            }
            ++i2;
        }
        if (!anyValid) {
            throw new ProvisionException(Messages.Application_NoRepositories);
        }
    }

    private void initializeServices() throws CoreException {
        IDirector director;
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.packageAdminRef = context.getServiceReference(clazz.getName());
        this.packageAdmin = (PackageAdmin)context.getService(this.packageAdminRef);
        if (this.destination != null || this.sharedLocation != null) {
            this.restartExemplarySetup = this.stopTransient(BUNDLE_EXEMPLARY_SETUP);
            this.restartEngine = this.stopTransient(BUNDLE_ENGINE);
            this.restartCore = this.stopTransient(BUNDLE_CORE);
            String p2DataArea = this.sharedLocation == null ? new File(this.destination, "p2").getAbsolutePath() : this.sharedLocation;
            this.preservedDataArea = System.setProperty(PROP_P2_DATA_AREA, p2DataArea);
            if (this.profileId == null && this.destination != null) {
                block37: {
                    File configIni = new File(this.destination, "configuration/config.ini");
                    InputStream in = null;
                    try {
                        try {
                            Properties ciProps = new Properties();
                            in = new BufferedInputStream(new FileInputStream(configIni));
                            ciProps.load(in);
                            this.profileId = ciProps.getProperty(PROP_P2_PROFILE);
                        }
                        catch (IOException iOException) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block37;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (this.profileId == null) {
                    this.profileId = this.destination;
                }
            }
            if (this.profileId == null) {
                this.preservedProfile = System.setProperty(PROP_P2_PROFILE, this.profileId);
            } else {
                System.getProperties().remove(PROP_P2_PROFILE);
            }
        }
        if (!this.startTransient(BUNDLE_SIMPLE_CONFIGURATOR_MANIPULATOR)) {
            throw new ProvisionException(NLS.bind((String)Messages.Missing_bundle, (Object)BUNDLE_SIMPLE_CONFIGURATOR_MANIPULATOR));
        }
        if (!this.startTransient(BUNDLE_FRAMEWORKADMIN_EQUINOX)) {
            throw new ProvisionException(NLS.bind((String)Messages.Missing_bundle, (Object)BUNDLE_FRAMEWORKADMIN_EQUINOX));
        }
        if (!this.startTransient(BUNDLE_CORE)) {
            throw new ProvisionException(NLS.bind((String)Messages.Missing_bundle, (Object)BUNDLE_CORE));
        }
        if (!this.startTransient(BUNDLE_ENGINE)) {
            throw new ProvisionException(NLS.bind((String)Messages.Missing_bundle, (Object)BUNDLE_ENGINE));
        }
        if (!this.startTransient(BUNDLE_EXEMPLARY_SETUP)) {
            throw new ProvisionException(NLS.bind((String)Messages.Missing_bundle, (Object)BUNDLE_EXEMPLARY_SETUP));
        }
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IDirector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((director = (IDirector)ServiceHelper.getService((BundleContext)context, (String)clazz2.getName())) == null) {
            throw new ProvisionException(Messages.Missing_director);
        }
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.planner = (IPlanner)ServiceHelper.getService((BundleContext)context, (String)clazz3.getName());
        if (this.planner == null) {
            throw new ProvisionException(Messages.Missing_planner);
        }
        this.engine = (IEngine)ServiceHelper.getService((BundleContext)context, (String)IEngine.SERVICE_NAME);
        if (this.engine == null) {
            throw new ProvisionException(Messages.Missing_Engine);
        }
    }

    private void logFailure(IStatus status) {
        FrameworkLog log;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((log = (FrameworkLog)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
            System.err.println("Application failed, log file location: " + log.getFile());
        }
        LogHelper.log((IStatus)status);
    }

    private void markRoots(ProfileChangeRequest request, IInstallableUnit[] roots) {
        int idx = 0;
        while (idx < roots.length) {
            request.setInstallableUnitProfileProperty(roots[idx], "org.eclipse.equinox.p2.type.root", (Object)Boolean.TRUE.toString());
            ++idx;
        }
    }

    private void missingArgument(String argumentName) throws CoreException {
        throw new ProvisionException(NLS.bind((String)Messages.Missing_Required_Argument, (Object)argumentName));
    }

    private void performList() throws CoreException {
        InstallableUnitQuery query = new InstallableUnitQuery(null, VersionRange.emptyRange);
        if (this.metadataRepositoryLocations.isEmpty()) {
            this.missingArgument("metadataRepository");
        }
        Collector roots = this.collectRootIUs((Query)query, null);
        Iterator unitIterator = roots.iterator();
        while (unitIterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)unitIterator.next();
            System.out.println(iu.getId());
        }
    }

    private void performProvisioningActions() throws CoreException {
        IProfile profile = this.initializeProfile();
        IInstallableUnit[] installs = this.collectRoots(profile, this.rootsToInstall, true);
        IInstallableUnit[] uninstalls = this.collectRoots(profile, this.rootsToUninstall, false);
        boolean wasRoaming = Boolean.valueOf(profile.getProperty("org.eclipse.equinox.p2.roaming"));
        try {
            this.updateRoamingProperties(profile);
            ProvisioningContext context = new ProvisioningContext(this.metadataRepositoryLocations.toArray(new URI[this.metadataRepositoryLocations.size()]));
            context.setArtifactRepositories(this.artifactRepositoryLocations.toArray(new URI[this.artifactRepositoryLocations.size()]));
            ProfileChangeRequest request = this.buildProvisioningRequest(profile, installs, uninstalls);
            this.printRequest(request);
            this.planAndExecute(profile, context, request);
        }
        finally {
            if (wasRoaming && !Boolean.valueOf(profile.getProperty("org.eclipse.equinox.p2.roaming")).booleanValue()) {
                this.setRoaming(profile);
            }
        }
    }

    private void planAndExecute(IProfile profile, ProvisioningContext context, ProfileChangeRequest request) throws CoreException {
        ProvisioningPlan result = this.planner.getProvisioningPlan(request, context, (IProgressMonitor)new NullProgressMonitor());
        IStatus operationStatus = result.getStatus();
        if (!operationStatus.isOK()) {
            throw new CoreException(operationStatus);
        }
        if (!this.verifyOnly && !(operationStatus = PlanExecutionHelper.executePlan((ProvisioningPlan)result, (IEngine)this.engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor())).isOK()) {
            throw new CoreException(operationStatus);
        }
    }

    private void printRequest(ProfileChangeRequest request) {
        IInstallableUnit[] toAdd = request.getAddedInstallableUnits();
        int i = 0;
        while (i < toAdd.length) {
            System.out.println(NLS.bind((String)Messages.Installing, (Object)toAdd[i].getId(), (Object)toAdd[i].getVersion()));
            ++i;
        }
        IInstallableUnit[] toRemove = request.getRemovedInstallableUnits();
        int i2 = 0;
        while (i2 < toRemove.length) {
            System.out.println(NLS.bind((String)Messages.Uninstalling, (Object)toRemove[i2].getId(), (Object)toRemove[i2].getVersion()));
            ++i2;
        }
    }

    public void processArguments(String[] args) throws CoreException {
        if (args == null) {
            this.printHelpInfo = true;
            return;
        }
        int i = 0;
        while (i < args.length) {
            String opt = args[i];
            if (OPTION_LIST.isOption(opt)) {
                this.printIUList = true;
            } else if (OPTION_HELP.isOption(opt)) {
                this.printHelpInfo = true;
            } else if (OPTION_INSTALL_IU.isOption(opt)) {
                DirectorApplication.parseIUsArgument(this.rootsToInstall, DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_UNINSTALL_IU.isOption(opt)) {
                DirectorApplication.parseIUsArgument(this.rootsToUninstall, DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_PROFILE.isOption(opt)) {
                this.profileId = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_FLAVOR.isOption(opt)) {
                this.flavor = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_SHARED.isOption(opt)) {
                if (++i < args.length) {
                    String nxt = args[i];
                    if (nxt.startsWith("-")) {
                        --i;
                    } else {
                        this.sharedLocation = DirectorApplication.processFileArgument(nxt);
                    }
                }
                if (this.sharedLocation == null) {
                    this.sharedLocation = Path.fromOSString((String)System.getProperty("user.home")).append(".p2/").toOSString();
                }
            } else if (OPTION_DESTINATION.isOption(opt)) {
                this.destination = DirectorApplication.processFileArgument(DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_BUNDLEPOOL.isOption(opt)) {
                this.bundlePool = DirectorApplication.processFileArgument(DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_METADATAREPOS.isOption(opt)) {
                DirectorApplication.getURIs(this.metadataRepositoryLocations, DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_ARTIFACTREPOS.isOption(opt)) {
                DirectorApplication.getURIs(this.artifactRepositoryLocations, DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_REPOSITORIES.isOption(opt)) {
                String arg = DirectorApplication.getRequiredArgument(args, ++i);
                DirectorApplication.getURIs(this.metadataRepositoryLocations, arg);
                DirectorApplication.getURIs(this.artifactRepositoryLocations, arg);
            } else if (OPTION_PROFILE_PROPS.isOption(opt)) {
                this.profileProperties = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_ROAMING.isOption(opt)) {
                this.roamingProfile = true;
            } else if (OPTION_VERIFY_ONLY.isOption(opt)) {
                this.verifyOnly = true;
            } else if (OPTION_P2_OS.isOption(opt)) {
                this.os = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_P2_WS.isOption(opt)) {
                this.ws = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_P2_NL.isOption(opt)) {
                this.nl = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_P2_ARCH.isOption(opt)) {
                this.arch = DirectorApplication.getRequiredArgument(args, ++i);
            } else {
                throw new ProvisionException(NLS.bind((String)Messages.unknown_option_0, (Object)opt));
            }
            ++i;
        }
        if (!this.printHelpInfo && !this.printIUList && this.rootsToInstall.isEmpty() && this.rootsToUninstall.isEmpty()) {
            System.out.println(Messages.Help_Missing_argument);
            this.printHelpInfo = true;
        }
    }

    private void putProperties(String pairs, Properties properties) {
        String[] propPairs = StringHelper.getArrayFromString((String)pairs, (char)',');
        int i = 0;
        while (i < propPairs.length) {
            String value;
            String tag;
            String propPair = propPairs[i];
            int eqIdx = propPair.indexOf(61);
            if (eqIdx >= 0 && (tag = propPair.substring(0, eqIdx).trim()).length() != 0 && (value = propPair.substring(eqIdx + 1).trim()).length() > 0) {
                properties.put(tag, value);
            }
            ++i;
        }
    }

    private void restoreServices() throws CoreException {
        BundleContext context = Activator.getContext();
        try {
            if (this.destination == null && this.sharedLocation == null) {
                return;
            }
            this.stopTransient(BUNDLE_EXEMPLARY_SETUP);
            this.stopTransient(BUNDLE_CORE);
            if (this.preservedDataArea != null) {
                System.setProperty(PROP_P2_DATA_AREA, this.preservedDataArea);
            } else {
                System.getProperties().remove(PROP_P2_DATA_AREA);
            }
            if (this.preservedProfile != null) {
                System.setProperty(PROP_P2_PROFILE, this.preservedProfile);
            } else {
                System.getProperties().remove(PROP_P2_PROFILE);
            }
            if (this.restartCore) {
                this.startTransient(BUNDLE_CORE);
            }
            if (this.restartEngine) {
                this.startTransient(BUNDLE_ENGINE);
            }
            if (this.restartExemplarySetup) {
                this.startTransient(BUNDLE_EXEMPLARY_SETUP);
            }
        }
        finally {
            context.ungetService(this.packageAdminRef);
        }
    }

    public Object run(String[] args) throws CoreException {
        long time = System.currentTimeMillis();
        try {
            this.processArguments(args);
            if (this.printHelpInfo) {
                this.performHelpInfo();
            } else {
                this.initializeServices();
                this.initializeRepositories();
                if (!this.rootsToInstall.isEmpty() || !this.rootsToUninstall.isEmpty()) {
                    this.performProvisioningActions();
                }
                if (this.printIUList) {
                    this.performList();
                }
                System.out.println(NLS.bind((String)Messages.Operation_complete, (Object)new Long(System.currentTimeMillis() - time)));
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (CoreException e) {
            this.deeplyPrint(e.getStatus(), System.err, 0);
            this.logFailure(e.getStatus());
            this.setSystemProperty("eclipse.exitdata", "");
            Integer n = EXIT_ERROR;
            return n;
        }
        finally {
            if (this.packageAdminRef != null) {
                this.cleanupRepositories();
                this.restoreServices();
            }
        }
    }

    private void setSystemProperty(String key, String value) {
        EnvironmentInfo env;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((env = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
            env.setProperty(key, value);
        } else {
            System.getProperties().put(key, value);
        }
    }

    private static void appendLevelPrefix(PrintStream strm, int level) {
        int idx = 0;
        while (idx < level) {
            strm.print(' ');
            ++idx;
        }
    }

    private void deeplyPrint(CoreException ce, PrintStream strm, int level) {
        DirectorApplication.appendLevelPrefix(strm, level);
        if (this.stackTrace) {
            ce.printStackTrace(strm);
        }
        this.deeplyPrint(ce.getStatus(), strm, level);
    }

    private void deeplyPrint(IStatus status, PrintStream strm, int level) {
        DirectorApplication.appendLevelPrefix(strm, level);
        String msg = status.getMessage();
        strm.println(msg);
        Throwable cause = status.getException();
        if (cause != null) {
            strm.print("Caused by: ");
            if (this.stackTrace || !msg.equals(cause.getMessage()) && !msg.equals(cause.toString())) {
                this.deeplyPrint(cause, strm, level);
            }
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.deeplyPrint(children[i], strm, level + 1);
                ++i;
            }
        }
    }

    private void deeplyPrint(Throwable t, PrintStream strm, int level) {
        if (t instanceof CoreException) {
            this.deeplyPrint((CoreException)t, strm, level);
        } else {
            DirectorApplication.appendLevelPrefix(strm, level);
            if (this.stackTrace) {
                t.printStackTrace(strm);
            } else {
                strm.println(t.toString());
                Throwable cause = t.getCause();
                if (cause != null) {
                    strm.print("Caused by: ");
                    this.deeplyPrint(cause, strm, level);
                }
            }
        }
    }

    private void performHelpInfo() {
        CommandLineOption[] allOptions = new CommandLineOption[]{OPTION_HELP, OPTION_LIST, OPTION_INSTALL_IU, OPTION_UNINSTALL_IU, OPTION_DESTINATION, OPTION_METADATAREPOS, OPTION_ARTIFACTREPOS, OPTION_REPOSITORIES, OPTION_VERIFY_ONLY, OPTION_PROFILE, OPTION_FLAVOR, OPTION_SHARED, OPTION_BUNDLEPOOL, OPTION_PROFILE_PROPS, OPTION_ROAMING, OPTION_P2_OS, OPTION_P2_WS, OPTION_P2_ARCH, OPTION_P2_NL};
        int i = 0;
        while (i < allOptions.length) {
            allOptions[i].appendHelp(System.out);
            ++i;
        }
    }

    private IStatus setRoaming(IProfile profile) {
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.setProfileProperty("org.eclipse.equinox.p2.roaming", (Object)"true");
        ProvisioningContext context = new ProvisioningContext(new URI[0]);
        context.setArtifactRepositories(new URI[0]);
        ProvisioningPlan result = this.planner.getProvisioningPlan(request, context, (IProgressMonitor)new NullProgressMonitor());
        return PlanExecutionHelper.executePlan((ProvisioningPlan)result, (IEngine)this.engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
    }

    public Object start(IApplicationContext context) throws Exception {
        return this.run((String[])context.getArguments().get("application.args"));
    }

    private boolean startTransient(String bundleName) throws CoreException {
        Bundle bundle = this.getBundle(bundleName);
        if (bundle == null) {
            return false;
        }
        try {
            bundle.start(1);
        }
        catch (BundleException bundleException) {
            throw new ProvisionException(NLS.bind((String)Messages.unable_to_start_bundle_0, (Object)bundleName));
        }
        return true;
    }

    public void stop() {
    }

    private boolean stopTransient(String bundleName) throws CoreException {
        Bundle bundle = this.getBundle(bundleName);
        boolean wasActive = false;
        if (bundle != null) {
            boolean bl = wasActive = (bundle.getState() & 0x28) != 0;
            if (wasActive) {
                try {
                    bundle.stop(1);
                }
                catch (BundleException bundleException) {
                    throw new ProvisionException(NLS.bind((String)Messages.unable_to_stop_bundle_0, (Object)bundleName));
                }
            }
        }
        return wasActive;
    }

    private String toString(Map context) {
        StringBuffer result = new StringBuffer();
        Iterator entries = context.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (result.length() > 0) {
                result.append(',');
            }
            result.append((String)entry.getKey());
            result.append('=');
            result.append((String)entry.getValue());
        }
        return result.toString();
    }

    private void updateRoamingProperties(IProfile profile) throws CoreException {
        if (this.destination == null) {
            return;
        }
        if (this.noProfileId) {
            throw new ProvisionException(Messages.Missing_profileid);
        }
        if (!Boolean.valueOf(profile.getProperty("org.eclipse.equinox.p2.roaming")).booleanValue()) {
            return;
        }
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        File destinationFile = new File(this.destination);
        if (!destinationFile.equals(new File(profile.getProperty("org.eclipse.equinox.p2.installFolder")))) {
            request.setProfileProperty("org.eclipse.equinox.p2.installFolder", (Object)this.destination);
        }
        if (!destinationFile.equals(new File(profile.getProperty("org.eclipse.equinox.p2.cache")))) {
            request.setProfileProperty("org.eclipse.equinox.p2.cache", (Object)this.destination);
        }
        if (request.getProfileProperties().size() == 0) {
            return;
        }
        request.setProfileProperty("org.eclipse.equinox.p2.roaming", (Object)"false");
        ProvisioningContext context = new ProvisioningContext(new URI[0]);
        context.setArtifactRepositories(new URI[0]);
        ProvisioningPlan result = this.planner.getProvisioningPlan(request, context, (IProgressMonitor)new NullProgressMonitor());
        IStatus status = PlanExecutionHelper.executePlan((ProvisioningPlan)result, (IEngine)this.engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK()) {
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.equinox.p2.director.app", 4, new IStatus[]{status}, NLS.bind((String)Messages.Cant_change_roaming, (Object)profile.getProfileId()), null));
        }
    }

    private static class CommandLineOption {
        private final String[] identifiers;
        private final String optionSyntaxString;
        private final String helpString;

        CommandLineOption(String[] identifiers, String optionSyntaxString, String helpString) {
            this.identifiers = identifiers;
            this.optionSyntaxString = optionSyntaxString;
            this.helpString = helpString;
        }

        boolean isOption(String opt) {
            int idx = this.identifiers.length;
            while (--idx >= 0) {
                if (!this.identifiers[idx].equalsIgnoreCase(opt)) continue;
                return true;
            }
            return false;
        }

        void appendHelp(PrintStream out) {
            out.print(this.identifiers[0]);
            int idx = 1;
            while (idx < this.identifiers.length) {
                out.print(" | ");
                out.print(this.identifiers[idx]);
                ++idx;
            }
            if (this.optionSyntaxString != null) {
                out.print(' ');
                out.print(this.optionSyntaxString);
            }
            out.println();
            out.print("  ");
            out.println(this.helpString);
        }
    }

    class LocationQueryable
    implements IQueryable {
        private URI location;

        public LocationQueryable(URI location) {
            this.location = location;
        }

        public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
            return ProvisioningHelper.getInstallableUnits((URI)this.location, (Query)query, (Collector)collector, (IProgressMonitor)monitor);
        }
    }
}

