/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.preferences.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ContextUiPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private Button autoFocusNavigatorsButton = null;
    private Button manageEditorsButton = null;
    private Button mapCloseToRemoveButton = null;
    private Button managePerspectivesButton = null;
    private Button manageExpansionButton = null;

    public ContextUiPreferencePage() {
        this.setPreferenceStore(ContextUiPlugin.getDefault().getPreferenceStore());
        this.setTitle(Messages.ContextUiPreferencePage_Context);
        this.setDescription(Messages.ContextUiPreferencePage_CONFIGURE_TASK_FOCUSED_UI_MANAGEMENT_AND_AUTOMATION);
    }

    protected Control createContents(Composite parent) {
        Composite entryTable = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 4;
        entryTable.setLayout((Layout)layout);
        this.createUiManagementSection(entryTable);
        this.applyDialogFont(entryTable);
        return entryTable;
    }

    public void init(IWorkbench workbench) {
    }

    public void widgetDefaultSelected(SelectionEvent se) {
        this.widgetSelected(se);
    }

    public void widgetSelected(SelectionEvent se) {
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.mylyn.context.ui.navigators.filter.auto.enable", this.autoFocusNavigatorsButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.context.ui.editors.auto.manage", this.manageEditorsButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.ide.ui.perspectives.auto.manage", this.managePerspectivesButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.ide.ui.expansion.auto.manage", this.manageExpansionButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.context.ui.close.action.manage", this.mapCloseToRemoveButton.getSelection());
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.auto.expand", this.manageExpansionButton.getSelection());
        return true;
    }

    public boolean performCancel() {
        this.autoFocusNavigatorsButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.navigators.filter.auto.enable"));
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.autoFocusNavigatorsButton.setSelection(true);
        this.manageEditorsButton.setSelection(true);
        this.manageExpansionButton.setSelection(true);
        this.managePerspectivesButton.setSelection(false);
        this.mapCloseToRemoveButton.setSelection(false);
    }

    private void createUiManagementSection(Composite parent) {
        Group groupViews = new Group(parent, 16);
        groupViews.setLayout((Layout)new GridLayout(1, false));
        groupViews.setLayoutData((Object)new GridData(768));
        groupViews.setText(Messages.ContextUiPreferencePage_Views);
        this.autoFocusNavigatorsButton = new Button((Composite)groupViews, 32);
        this.autoFocusNavigatorsButton.setText(Messages.ContextUiPreferencePage_Auto_focus_navigator_views_on_task_activation);
        this.autoFocusNavigatorsButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.navigators.filter.auto.enable"));
        this.manageExpansionButton = new Button((Composite)groupViews, 32);
        this.manageExpansionButton.setText(Messages.ContextUiPreferencePage_Auto_expand_tree_views_when_focused);
        this.manageExpansionButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.expansion.auto.manage"));
        Group groupEditors = new Group(parent, 16);
        groupEditors.setLayout((Layout)new GridLayout(1, false));
        groupEditors.setLayoutData((Object)new GridData(768));
        groupEditors.setText(Messages.ContextUiPreferencePage_Editors);
        this.manageEditorsButton = new Button((Composite)groupEditors, 32);
        this.manageEditorsButton.setText(Messages.ContextUiPreferencePage_Manage_open_editors_to_match_task_context);
        this.manageEditorsButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editors.auto.manage"));
        if (this.getContainer() instanceof IWorkbenchPreferenceContainer) {
            String message = "<a>''{0}''</a> " + Messages.ContextUiPreferencePage_will_be_toggled_with_activation;
            new PreferenceLinkArea((Composite)groupEditors, 0, "org.eclipse.ui.preferencePages.Editors", message, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        }
        this.mapCloseToRemoveButton = new Button((Composite)groupEditors, 32);
        this.mapCloseToRemoveButton.setText(Messages.ContextUiPreferencePage_Remove_file_from_context_when_editor_is_closed);
        this.mapCloseToRemoveButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.close.action.manage"));
        Group groupPerspectives = new Group(parent, 16);
        groupPerspectives.setLayout((Layout)new GridLayout(1, false));
        groupPerspectives.setLayoutData((Object)new GridData(768));
        groupPerspectives.setText(Messages.ContextUiPreferencePage_Perspectives);
        this.managePerspectivesButton = new Button((Composite)groupPerspectives, 32);
        this.managePerspectivesButton.setText(Messages.ContextUiPreferencePage_Open_last_used_perspective_on_task_activation);
        this.managePerspectivesButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.perspectives.auto.manage"));
    }
}

