/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractTaskEditorPart
extends AbstractFormPart {
    protected static final Font TEXT_FONT = JFaceResources.getDefaultFont();
    private Control control;
    private String partName;
    private String partId;
    private AbstractTaskEditorPage taskEditorPage;
    private boolean expandVertically;

    protected AbstractAttributeEditor createAttributeEditor(TaskAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        String type = attribute.getMetaData().getType();
        if (type != null) {
            AttributeEditorFactory attributeEditorFactory = this.getTaskEditorPage().getAttributeEditorFactory();
            AbstractAttributeEditor editor = attributeEditorFactory.createEditor(type, attribute);
            if (editor instanceof RichTextAttributeEditor) {
                boolean spellChecking = this.getTaskEditorPage().getAttributeEditorToolkit().hasSpellChecking(attribute);
                ((RichTextAttributeEditor)editor).setSpellCheckingEnabled(spellChecking);
            }
            return editor;
        }
        return null;
    }

    public abstract void createControl(Composite var1, FormToolkit var2);

    protected Section createSection(Composite parent, FormToolkit toolkit, int style) {
        Section section = toolkit.createSection(parent, style);
        section.setText(this.getPartName());
        return section;
    }

    protected Section createSection(Composite parent, FormToolkit toolkit, boolean expandedState) {
        int style = 258;
        if (expandedState) {
            style |= 0x40;
        }
        return this.createSection(parent, toolkit, style);
    }

    protected void fillToolBar(ToolBarManager toolBarManager) {
    }

    public Control getControl() {
        return this.control;
    }

    public TaskDataModel getModel() {
        return this.getTaskEditorPage().getModel();
    }

    public String getPartId() {
        return this.partId;
    }

    public String getPartName() {
        return this.partName;
    }

    public TaskData getTaskData() {
        return this.getTaskEditorPage().getModel().getTaskData();
    }

    public AbstractTaskEditorPage getTaskEditorPage() {
        return this.taskEditorPage;
    }

    public void initialize(AbstractTaskEditorPage taskEditorPage) {
        this.taskEditorPage = taskEditorPage;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    void setPartId(String partId) {
        this.partId = partId;
    }

    protected void setPartName(String partName) {
        this.partName = partName;
    }

    protected void setSection(FormToolkit toolkit, Section section) {
        if (section.getTextClient() == null) {
            ToolBarManager toolBarManager = new ToolBarManager(0x800000);
            this.fillToolBar(toolBarManager);
            if (toolBarManager.getSize() > 0) {
                Composite toolbarComposite = toolkit.createComposite((Composite)section);
                toolbarComposite.setBackground(null);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                toolbarComposite.setLayout((Layout)rowLayout);
                toolBarManager.createControl(toolbarComposite);
                section.clientVerticalSpacing = 0;
                section.descriptionVerticalSpacing = 0;
                section.setTextClient((Control)toolbarComposite);
            }
        }
        this.setControl((Control)section);
    }

    protected boolean setSelection(ISelection selection) {
        return false;
    }

    public boolean getExpandVertically() {
        return this.expandVertically;
    }

    public void setExpandVertically(boolean expandVertically) {
        this.expandVertically = expandVertically;
    }
}

