/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.twiki.core.block;

import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.twiki.core.TWikiLanguage;

public class ParagraphBlock
extends Block {
    private int blockLineCount = 0;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
        }
        if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        TWikiLanguage textileLanguage = (TWikiLanguage)this.getMarkupLanguage();
        for (Block block : textileLanguage.getParagraphBreakingBlocks()) {
            if (!block.canStart(line, offset)) continue;
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount != 0) {
            this.builder.lineBreak();
        }
        ++this.blockLineCount;
        textileLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        return true;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

