/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.policy;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.osgi.util.NLS;

public abstract class RepositoryLocationValidator {
    public static final int LOCAL_VALIDATION_ERROR = 3000;
    public static final int ALTERNATE_ACTION_TAKEN = 3001;

    public static IStatus getInvalidLocationStatus(String urlText) {
        return new Status(4, "org.eclipse.equinox.p2.ui", 3000, NLS.bind((String)ProvUIMessages.URLValidator_UnrecognizedURL, (Object)urlText), null);
    }

    public static URI locationFromString(String locationString) {
        URI userLocation;
        try {
            userLocation = URIUtil.fromString((String)locationString);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        String uriString = URIUtil.toUnencodedString((URI)userLocation);
        if (uriString.length() > 0 && (uriString.charAt(0) == '/' || uriString.charAt(0) == File.separatorChar)) {
            return RepositoryHelper.localRepoURIHelper((URI)userLocation);
        }
        return userLocation;
    }

    public abstract IStatus validateRepositoryLocation(URI var1, boolean var2, IProgressMonitor var3);
}

