/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.policy;

import java.net.URI;
import org.eclipse.equinox.internal.p2.ui.DefaultMetadataURLValidator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.RepositoryManipulationPage;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.AddColocatedRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.AddRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.RemoveColocatedRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.RemoveRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryLocationValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryManipulator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ColocatedRepositoryManipulator
extends RepositoryManipulator {
    Policy policy;
    String prefPageId = null;

    public ColocatedRepositoryManipulator(Policy policy, String prefPageId) {
        this.policy = policy;
        this.prefPageId = prefPageId;
    }

    public String getManipulatorButtonLabel() {
        return ProvUIMessages.ColocatedRepositoryManipulator_ManageSites;
    }

    public boolean manipulateRepositories(Shell shell) {
        if (this.prefPageId != null) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)this.prefPageId, null, null);
            dialog.open();
        } else {
            TitleAreaDialog dialog = new TitleAreaDialog(shell){
                RepositoryManipulationPage page;

                protected Control createDialogArea(Composite parent) {
                    this.page = new RepositoryManipulationPage();
                    this.page.setPolicy(ColocatedRepositoryManipulator.this.policy);
                    this.page.init(PlatformUI.getWorkbench());
                    this.page.createControl(parent);
                    this.setTitle(ProvUIMessages.RepositoryManipulationPage_Title);
                    this.setMessage(ProvUIMessages.RepositoryManipulationPage_Description);
                    return this.page.getControl();
                }

                protected void okPressed() {
                    if (this.page.performOk()) {
                        super.okPressed();
                    }
                }

                protected void cancelPressed() {
                    if (this.page.performCancel()) {
                        super.cancelPressed();
                    }
                }
            };
            dialog.open();
        }
        return true;
    }

    public AddRepositoryOperation getAddOperation(URI repoLocation) {
        return new AddColocatedRepositoryOperation(this.getAddOperationLabel(), repoLocation);
    }

    public String getAddOperationLabel() {
        return ProvUIMessages.ColocatedRepositoryManipulator_AddSiteOperationLabel;
    }

    public URI[] getKnownRepositories() {
        try {
            return ProvisioningUtil.getMetadataRepositories(this.policy.getQueryContext().getMetadataRepositoryFlags());
        }
        catch (ProvisionException provisionException) {
            return new URI[0];
        }
    }

    public RemoveRepositoryOperation getRemoveOperation(URI[] reposToRemove) {
        return new RemoveColocatedRepositoryOperation(this.getRemoveOperationLabel(), reposToRemove);
    }

    public String getRemoveOperationLabel() {
        return ProvUIMessages.ColocatedRepositoryManipulator_RemoveSiteOperationLabel;
    }

    public RepositoryLocationValidator getRepositoryLocationValidator(Shell shell) {
        DefaultMetadataURLValidator validator = new DefaultMetadataURLValidator();
        validator.setKnownRepositoriesFlag(this.policy.getQueryContext().getMetadataRepositoryFlags());
        return validator;
    }

    public String getManipulatorLinkLabel() {
        return ProvUIMessages.ColocatedRepositoryManipulator_GotoPrefs;
    }

    public String getRepositoryNotFoundInstructionString() {
        return ProvUIMessages.ColocatedRepositoryManipulator_SiteNotFoundDescription;
    }

    public String getManipulatorInstructionString() {
        return ProvUIMessages.ColocatedRepositoryManipulator_NoContentExplanation;
    }
}

