/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.ui.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class ProvisioningOperationWizard
extends Wizard {
    private static final String WIZARD_SETTINGS_SECTION = "WizardSettings";
    protected Policy policy;
    protected String profileId;
    protected IUElementListRoot root;
    protected IUElementListRoot originalRoot;
    protected PlannerResolutionOperation resolutionOperation;
    private Object[] planSelections;
    protected ISelectableIUsPage mainPage;
    protected IResolutionErrorReportingPage errorPage;
    protected ResolutionResultsWizardPage resolutionPage;
    private ProvisioningContext provisioningContext;
    boolean couldNotResolve;
    boolean waitingForOtherJobs = false;

    public ProvisioningOperationWizard(Policy policy, String profileId, IUElementListRoot root, Object[] initialSelections, PlannerResolutionOperation initialResolution) {
        this.policy = policy;
        this.profileId = profileId;
        this.root = root;
        this.originalRoot = root;
        this.resolutionOperation = initialResolution;
        this.planSelections = initialSelections == null ? new Object[0] : initialSelections;
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mainPage = this.createMainPage(this.root, this.planSelections);
        this.addPage(this.mainPage);
    }

    protected abstract IResolutionErrorReportingPage getErrorReportingPage();

    protected abstract ISelectableIUsPage createMainPage(IUElementListRoot var1, Object[] var2);

    protected abstract ResolutionResultsWizardPage createResolutionPage();

    public boolean performFinish() {
        return this.resolutionPage.performFinish();
    }

    public boolean canFinish() {
        if (this.resolutionPage == null) {
            return false;
        }
        if (!super.canFinish()) {
            return false;
        }
        if (this.resolutionOperation != null) {
            int severity = this.resolutionOperation.getResolutionResult().getSummaryStatus().getSeverity();
            return severity != 4 && severity != 8;
        }
        return false;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mainPage || page == this.errorPage) {
            ISelectableIUsPage currentPage = (ISelectableIUsPage)page;
            boolean weResolved = false;
            if (this.resolutionOperation == null || this.resolutionOperation != null && this.shouldRecomputePlan(currentPage)) {
                this.resolutionOperation = null;
                this.provisioningContext = this.getProvisioningContext();
                this.planSelections = currentPage.getCheckedIUElements();
                this.root = this.makeResolutionElementRoot(this.planSelections);
                this.recomputePlan((IRunnableContext)this.getContainer());
                this.planChanged();
                weResolved = true;
            } else {
                this.planSelections = currentPage.getCheckedIUElements();
                this.root = this.makeResolutionElementRoot(this.planSelections);
            }
            return this.selectNextPage(page, this.getCurrentStatus(), weResolved);
        }
        return super.getNextPage(page);
    }

    protected IWizardPage selectNextPage(IWizardPage currentPage, IStatus status, boolean hasResolved) {
        if (status.getSeverity() == 8) {
            return currentPage;
        }
        if (status.getSeverity() == 4) {
            if (this.errorPage == null) {
                this.errorPage = this.getErrorReportingPage();
            }
            if (currentPage == this.errorPage) {
                this.updateErrorPageStatus(this.errorPage);
                return null;
            }
            this.showingErrorPage();
            return this.errorPage;
        }
        if (this.resolutionPage == null) {
            this.resolutionPage = this.createResolutionPage();
            this.addPage((IWizardPage)this.resolutionPage);
        }
        if (currentPage instanceof IResolutionErrorReportingPage) {
            this.updateErrorPageStatus((IResolutionErrorReportingPage)currentPage);
        }
        return this.resolutionPage;
    }

    protected void showingErrorPage() {
    }

    private boolean shouldRecomputePlan(ISelectableIUsPage page) {
        boolean previouslyWaiting = this.waitingForOtherJobs;
        boolean previouslyCanceled = this.getCurrentStatus().getSeverity() == 8;
        this.waitingForOtherJobs = ProvisioningOperationRunner.hasScheduledOperationsFor(this.profileId);
        return this.waitingForOtherJobs || previouslyWaiting || previouslyCanceled || this.pageSelectionsHaveChanged(page) || this.provisioningContextChanged();
    }

    private boolean pageSelectionsHaveChanged(ISelectableIUsPage page) {
        HashSet<IInstallableUnit> selectedIUs = new HashSet<IInstallableUnit>();
        Object[] currentSelections = page.getCheckedIUElements();
        selectedIUs.addAll(Arrays.asList(ElementUtils.elementsToIUs(currentSelections)));
        HashSet<IInstallableUnit> lastIUSelections = new HashSet<IInstallableUnit>();
        lastIUSelections.addAll(Arrays.asList(ElementUtils.elementsToIUs(this.planSelections)));
        return !selectedIUs.equals(lastIUSelections);
    }

    private boolean provisioningContextChanged() {
        ProvisioningContext currentProvisioningContext = this.getProvisioningContext();
        if (currentProvisioningContext == null && this.provisioningContext == null) {
            return false;
        }
        if (currentProvisioningContext != null && this.provisioningContext != null) {
            return !Arrays.equals(this.provisioningContext.getMetadataRepositories(), currentProvisioningContext.getMetadataRepositories());
        }
        return true;
    }

    protected void planChanged() {
        IStatus status;
        if (this.resolutionOperation != null && (status = this.resolutionOperation.getResolutionResult().getSummaryStatus()).getSeverity() != 4 && status.getSeverity() != 8) {
            if (this.resolutionPage != null) {
                this.resolutionPage.updateStatus(this.root, this.resolutionOperation);
            } else {
                this.resolutionPage = this.createResolutionPage();
                this.addPage((IWizardPage)this.resolutionPage);
            }
        }
    }

    protected abstract IUElementListRoot makeResolutionElementRoot(Object[] var1);

    protected ProvisioningContext getProvisioningContext() {
        return null;
    }

    public void recomputePlan(IRunnableContext runnableContext) {
        final Object[] elements = this.root.getChildren(this.root);
        this.couldNotResolve = false;
        try {
            if (elements.length == 0) {
                this.couldNotResolve(ProvUIMessages.ResolutionWizardPage_NoSelections);
            } else {
                runnableContext.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        ProvisioningOperationWizard.this.resolutionOperation = null;
                        MultiStatus status = PlanAnalyzer.getProfileChangeAlteredStatus();
                        ProfileChangeRequest request = ProvisioningOperationWizard.this.computeProfileChangeRequest(elements, status, monitor);
                        if (request != null) {
                            ProvisioningOperationWizard.this.resolutionOperation = new PlannerResolutionOperation(ProvUIMessages.ProfileModificationWizardPage_ResolutionOperationLabel, ProvisioningOperationWizard.this.profileId, request, ProvisioningOperationWizard.this.provisioningContext, status, false);
                            try {
                                ProvisioningOperationWizard.this.resolutionOperation.execute(monitor);
                            }
                            catch (ProvisionException e) {
                                ProvUI.handleException(e, null, 3);
                                ProvisioningOperationWizard.this.couldNotResolve(null);
                            }
                        }
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ProvUI.handleException(e.getCause(), null, 3);
            this.couldNotResolve(null);
        }
        if (this.errorPage == null) {
            this.errorPage = this.getErrorReportingPage();
        }
        this.updateErrorPageStatus(this.errorPage);
    }

    void updateErrorPageStatus(IResolutionErrorReportingPage page) {
        page.updateStatus(this.originalRoot, this.resolutionOperation);
    }

    void couldNotResolve(String message) {
        this.resolutionOperation = null;
        this.couldNotResolve = true;
        if (message != null) {
            MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.ui", 10050, message, null);
            StatusManager.getManager().handle((IStatus)status, 1);
        }
    }

    public IStatus getCurrentStatus() {
        if (this.couldNotResolve || this.resolutionOperation == null) {
            return PlanAnalyzer.getStatus(10050, null);
        }
        return this.resolutionOperation.getResolutionResult().getSummaryStatus();
    }

    public String getDialogSettingsSectionName() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + WIZARD_SETTINGS_SECTION;
    }

    public void saveBoundsRelatedSettings() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (pages[i] instanceof ProvisioningWizardPage) {
                ((ProvisioningWizardPage)pages[i]).saveBoundsRelatedSettings();
            }
            ++i;
        }
    }

    protected abstract ProfileChangeRequest computeProfileChangeRequest(Object[] var1, MultiStatus var2, IProgressMonitor var3);
}

