/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.OpenExternalBrowserAction;
import org.eclipse.jdt.internal.ui.actions.SimpleSelectionProvider;
import org.eclipse.jdt.internal.ui.infoviews.AbstractInfoView;
import org.eclipse.jdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.jdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.internal.text.html.BrowserInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;

public class JavadocView
extends AbstractInfoView {
    private static final String DO_NOT_WARN_PREFERENCE_KEY = "JavadocView.error.doNotWarn";
    private static final boolean WARNING_DIALOG_ENABLED = false;
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 0x200000L;
    private Browser fBrowser;
    private StyledText fText;
    private HTMLTextPresenter fPresenter;
    private final TextPresentation fPresentation = new TextPresentation();
    private SelectAllAction fSelectAllAction;
    private static String fgStyleSheet;
    private static boolean fgStyleSheetLoaded;
    private boolean fIsUsingBrowserWidget;
    private RGB fBackgroundColorRGB;
    private IPropertyChangeListener fFontListener;
    private String fOriginalInput;
    private BrowserInput fCurrent;
    private BackAction fBackAction;
    private ForthAction fForthAction;
    private LinkAction fToggleLinkAction;
    private OpenExternalBrowserAction fOpenExternalBrowserAction;
    private ISelectionProvider fInputSelectionProvider;
    static /* synthetic */ Class class$0;

    static {
        fgStyleSheetLoaded = false;
    }

    protected void internalCreatePartControl(Composite parent) {
        try {
            this.fBrowser = new Browser(parent, 0);
            this.fBrowser.setJavascriptEnabled(false);
            this.fIsUsingBrowserWidget = true;
            this.addLinkListener(this.fBrowser);
            this.fBrowser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    event.required = true;
                }
            });
        }
        catch (SWTError sWTError) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            store.getBoolean(DO_NOT_WARN_PREFERENCE_KEY);
            this.fIsUsingBrowserWidget = false;
        }
        if (!this.fIsUsingBrowserWidget) {
            this.fText = new StyledText(parent, 768);
            this.fText.setEditable(false);
            this.fPresenter = new HTMLTextPresenter(false);
            this.fText.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    JavadocView.this.doSetInput(JavadocView.this.fOriginalInput);
                }
            });
        }
        JavadocView.initStyleSheet();
        this.listenForFontChanges();
        this.getViewSite().setSelectionProvider((ISelectionProvider)new SelectionProvider(this.getControl()));
    }

    private void listenForFontChanges() {
        this.fFontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jdt.ui.javadocfont".equals(event.getProperty())) {
                    fgStyleSheetLoaded = false;
                    Display display = JavadocView.this.getSite().getPage().getWorkbenchWindow().getWorkbench().getDisplay();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(this, display){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ Display val$display;
                            {
                                this.this$1 = var1_1;
                                this.val$display = display;
                            }

                            public void run() {
                                if (!this.val$display.isDisposed()) {
                                    JavadocView.access$5();
                                    JavadocView.access$6(4.access$0(this.this$1));
                                }
                            }
                        });
                    }
                }
            }

            static /* synthetic */ JavadocView access$0(4 var0) {
                return var0.JavadocView.this;
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fFontListener);
    }

    private static void initStyleSheet() {
        if (fgStyleSheetLoaded) {
            return;
        }
        fgStyleSheetLoaded = true;
        fgStyleSheet = JavadocView.loadStyleSheet();
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocViewStyleSheet.css");
        if (styleSheetURL == null) {
            return null;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
        StringBuffer buffer = new StringBuffer(1500);
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append('\n');
            line = reader.readLine();
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
        String string = HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException ex) {
            try {
                JavaPlugin.log(ex);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction(this.getControl(), (SelectionProvider)this.getSelectionProvider());
        this.fBackAction = new BackAction();
        this.fBackAction.setActionDefinitionId("org.eclipse.ui.navigate.back");
        this.fForthAction = new ForthAction();
        this.fForthAction.setActionDefinitionId("org.eclipse.ui.navigate.forward");
        this.fToggleLinkAction = new LinkAction();
        this.fToggleLinkAction.setActionDefinitionId("org.eclipse.ui.navigate.linkWithEditor");
        this.fInputSelectionProvider = new SimpleSelectionProvider();
        this.fOpenExternalBrowserAction = new OpenExternalBrowserAction(this.getSite().getShell().getDisplay(), this.fInputSelectionProvider);
        this.fOpenExternalBrowserAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.external.javadoc");
        this.fInputSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenExternalBrowserAction);
        IJavaElement input = this.getInput();
        StructuredSelection selection = input != null ? new StructuredSelection((Object)input) : new StructuredSelection();
        this.fInputSelectionProvider.setSelection((ISelection)selection);
    }

    protected void fillActionBars(final IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.fBackAction);
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.fForthAction);
        this.fInputSelectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OpenExternalJavaDoc", (IAction)JavadocView.this.fOpenExternalBrowserAction);
            }
        });
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbenchPartSite.getService((Class)clazz);
        handlerService.activateHandler("org.eclipse.ui.navigate.linkWithEditor", (IHandler)new ActionHandler((IAction)this.fToggleLinkAction));
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.fBackAction);
        tbm.add((IAction)this.fForthAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fToggleLinkAction);
        super.fillToolBar(tbm);
        tbm.add((IAction)this.fOpenExternalBrowserAction);
    }

    public void menuAboutToShow(IMenuManager menu) {
        super.menuAboutToShow(menu);
        menu.appendToGroup("group.goto", (IAction)this.fBackAction);
        menu.appendToGroup("group.goto", (IAction)this.fForthAction);
        menu.appendToGroup("group.open", (IAction)this.fOpenExternalBrowserAction);
    }

    protected IAction getSelectAllAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return this.fSelectAllAction;
    }

    protected IAction getCopyToClipboardAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return super.getCopyToClipboardAction();
    }

    protected void setForeground(Color color) {
        this.getControl().setForeground(color);
    }

    protected void setBackground(Color color) {
        this.getControl().setBackground(color);
        this.fBackgroundColorRGB = color.getRGB();
        this.refresh();
    }

    private void refresh() {
        IJavaElement input = this.getInput();
        if (input == null) {
            StringBuffer buffer = new StringBuffer("");
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, null, (RGB)this.fBackgroundColorRGB, (String)fgStyleSheet);
            this.doSetInput(buffer.toString());
        } else {
            this.doSetInput(this.computeInput(input));
        }
    }

    protected String getBackgroundColorKey() {
        return "org.eclipse.jdt.ui.JavadocView.backgroundColor";
    }

    protected void internalDispose() {
        this.fText = null;
        this.fBrowser = null;
        if (this.fFontListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fFontListener);
            this.fFontListener = null;
        }
        if (this.fOpenExternalBrowserAction != null) {
            this.fInputSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenExternalBrowserAction);
            this.fOpenExternalBrowserAction = null;
        }
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    protected Object computeInput(Object input) {
        ISelectionProvider provider;
        IWorkbenchPartSite site;
        IWorkbenchPage page;
        if (this.getControl() == null || !(input instanceof IJavaElement)) {
            return null;
        }
        IWorkbenchPart part = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            part = page.getActivePart();
        }
        ISelection selection = null;
        if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null) {
            selection = provider.getSelection();
        }
        return this.computeInput(part, selection, (IJavaElement)input, (IProgressMonitor)new NullProgressMonitor());
    }

    protected Object computeInput(IWorkbenchPart part, ISelection selection, IJavaElement input, IProgressMonitor monitor) {
        String javadocHtml;
        if (this.getControl() == null || input == null) {
            return null;
        }
        switch (input.getElementType()) {
            case 5: {
                try {
                    javadocHtml = this.getJavadocHtml((IJavaElement[])((ICompilationUnit)input).getTypes(), part, selection, monitor);
                }
                catch (JavaModelException javaModelException) {
                    javadocHtml = null;
                }
                break;
            }
            case 6: {
                javadocHtml = this.getJavadocHtml(new IJavaElement[]{((IClassFile)input).getType()}, part, selection, monitor);
                break;
            }
            default: {
                javadocHtml = this.getJavadocHtml(new IJavaElement[]{input}, part, selection, monitor);
            }
        }
        if (javadocHtml == null) {
            return "";
        }
        return javadocHtml;
    }

    protected String computeDescription(IWorkbenchPart part, ISelection selection, IJavaElement inputElement, IProgressMonitor monitor) {
        return "";
    }

    public void setInput(BrowserInput input) {
        this.fCurrent = input;
        Object inputElement = input.getInputElement();
        if (inputElement instanceof IJavaElement) {
            this.setInput((IJavaElement)inputElement);
        } else if (inputElement instanceof URL) {
            this.fBrowser.setUrl(((URL)inputElement).toExternalForm());
            if (this.fInputSelectionProvider != null) {
                this.fInputSelectionProvider.setSelection((ISelection)new StructuredSelection(inputElement));
            }
        }
        this.fForthAction.update();
        this.fBackAction.update();
    }

    protected void doSetInput(Object input) {
        String javadocHtml;
        this.fOriginalInput = javadocHtml = (String)input;
        if (this.fInputSelectionProvider != null) {
            IJavaElement inputElement = this.getInput();
            StructuredSelection selection = inputElement == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)inputElement);
            this.fInputSelectionProvider.setSelection((ISelection)selection);
        }
        if (this.fIsUsingBrowserWidget) {
            if (javadocHtml != null && javadocHtml.length() > 0) {
                boolean RTL;
                boolean bl = RTL = (this.getSite().getShell().getStyle() & 0x4000000) != 0;
                if (RTL) {
                    StringBuffer buffer = new StringBuffer(javadocHtml);
                    HTMLPrinter.insertStyles((StringBuffer)buffer, (String[])new String[]{"direction:rtl"});
                    javadocHtml = buffer.toString();
                }
            }
            this.fBrowser.setText(javadocHtml);
        } else {
            this.fPresentation.clear();
            Rectangle size = this.fText.getClientArea();
            try {
                javadocHtml = this.fPresenter.updatePresentation((Drawable)this.fBrowser, javadocHtml, this.fPresentation, size.width, size.height);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            this.fText.setText(javadocHtml);
            TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
        }
    }

    private String getJavadocHtml(IJavaElement[] result, IWorkbenchPart activePart, ISelection selection, IProgressMonitor monitor) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        String base = null;
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList((StringBuffer)buffer);
                IJavaElement curr = result[i];
                if (curr instanceof IMember || curr.getElementType() == 14) {
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)this.getInfoText(curr, null, false));
                }
                HTMLPrinter.endBulletList((StringBuffer)buffer);
                ++i;
            }
        } else {
            IJavaElement curr = result[0];
            if (curr instanceof IMember) {
                StringReader reader;
                IMember member = (IMember)curr;
                String constantValue = null;
                if (member instanceof IField && (constantValue = this.computeFieldConstant(activePart, selection, (IField)member, monitor)) != null) {
                    constantValue = HTMLPrinter.convertToHTMLContent((String)constantValue);
                }
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)this.getInfoText((IJavaElement)member, constantValue, true));
                try {
                    String content = JavadocContentAccess2.getHTMLContent(member, true);
                    StringReader stringReader = reader = content == null ? null : new StringReader(content);
                    if (reader == null && member.isBinary()) {
                        boolean hasSource;
                        boolean hasAttachedJavadoc = JavaDocLocations.getJavadocBaseLocation((IJavaElement)member) != null;
                        IPackageFragmentRoot root = (IPackageFragmentRoot)member.getAncestor(3);
                        boolean hasAttachedSource = root != null && root.getSourceAttachmentPath() != null;
                        IOpenable openable = member.getOpenable();
                        boolean bl = hasSource = openable.getBuffer() != null;
                        if (!hasAttachedSource && !hasAttachedJavadoc) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noAttachments);
                        } else if (!hasAttachedJavadoc && !hasSource) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noAttachedJavadoc);
                        } else if (!hasAttachedSource) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noAttachedSource);
                        } else if (!hasSource) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noInformation);
                        }
                    } else {
                        base = JavaDocLocations.getBaseURL(member);
                    }
                }
                catch (JavaModelException ex) {
                    reader = new StringReader(InfoViewMessages.JavadocView_error_gettingJavadoc);
                    JavaPlugin.log(ex.getStatus());
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
                }
            } else if (curr.getElementType() == 14 || curr.getElementType() == 15) {
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)this.getInfoText(curr, null, true));
            }
        }
        boolean flushContent = true;
        if (buffer.length() > 0 || flushContent) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, null, (RGB)this.fBackgroundColorRGB, (String)fgStyleSheet);
            if (base != null) {
                int endHeadIdx = buffer.indexOf("</head>");
                buffer.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
            }
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(IJavaElement member, String constantValue, boolean allowImage) {
        URL imageUrl;
        StringBuffer label = new StringBuffer(JavaElementLinks.getElementLabel(member, LABEL_FLAGS));
        if (member.getElementType() == 8 && constantValue != null) {
            label.append(constantValue);
        }
        String imageName = null;
        if (allowImage && (imageUrl = JavaPlugin.getDefault().getImagesOnFSRegistry().getImageURL(member)) != null) {
            imageName = imageUrl.toExternalForm();
        }
        StringBuffer buf = new StringBuffer();
        JavadocHover.addImageAndLabel(buf, imageName, 16, 16, 8, 5, label.toString(), 22, 0);
        return buf.toString();
    }

    protected boolean isIgnoringNewInput(IJavaElement je, IWorkbenchPart part, ISelection selection) {
        if (this.fCurrent != null && this.fCurrent.getInputElement() instanceof URL) {
            return false;
        }
        if (super.isIgnoringNewInput(je, part, selection) && part instanceof ITextEditor && selection instanceof ITextSelection) {
            ITextEditor editor = (ITextEditor)part;
            IDocumentProvider docProvider = editor.getDocumentProvider();
            if (docProvider == null) {
                return false;
            }
            IDocument document = docProvider.getDocument((Object)editor.getEditorInput());
            if (!(document instanceof IDocumentExtension3)) {
                return false;
            }
            try {
                int offset = ((ITextSelection)selection).getOffset();
                String partition = ((IDocumentExtension3)document).getContentType("___java_partitioning", offset, false);
                return partition != "__java_javadoc";
            }
            catch (BadPartitioningException badPartitioningException) {
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return false;
    }

    protected IJavaElement findSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        IJavaElement element;
        block7: {
            IDocument document;
            ITextSelection textSelection;
            block9: {
                IDocumentProvider documentProvider;
                JavaEditor editor;
                block8: {
                    element = super.findSelectedJavaElement(part, selection);
                    if (element != null || !(part instanceof JavaEditor) || !(selection instanceof ITextSelection)) break block7;
                    editor = (JavaEditor)part;
                    textSelection = (ITextSelection)selection;
                    documentProvider = editor.getDocumentProvider();
                    if (documentProvider != null) break block8;
                    return null;
                }
                document = documentProvider.getDocument((Object)editor.getEditorInput());
                if (document != null) break block9;
                return null;
            }
            ITypedRegion typedRegion = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)textSelection.getOffset(), (boolean)false);
            if ("__java_javadoc".equals(typedRegion.getType())) {
                return TextSelectionConverter.getElementAtOffset((JavaEditor)part, textSelection);
            }
            return null;
        }
        try {
            return element;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected Control getControl() {
        if (this.fIsUsingBrowserWidget) {
            return this.fBrowser;
        }
        return this.fText;
    }

    protected String getHelpContextId() {
        return "org.eclipse.jdt.ui.javadoc_view_context";
    }

    private String computeFieldConstant(IWorkbenchPart activePart, ISelection selection, IField resolvedField, IProgressMonitor monitor) {
        Object constantValue;
        IJavaProject preferenceProject;
        if (!JavadocView.isStaticFinal((IJavaElement)resolvedField)) {
            return null;
        }
        if (selection instanceof ITextSelection && activePart instanceof JavaEditor) {
            IEditorPart editor = (IEditorPart)activePart;
            ITypeRoot activeType = JavaUI.getEditorInputTypeRoot(editor.getEditorInput());
            preferenceProject = activeType.getJavaProject();
            constantValue = JavadocView.getConstantValueFromActiveEditor(activeType, resolvedField, (ITextSelection)selection, monitor);
            if (constantValue == null) {
                constantValue = this.computeFieldConstantFromTypeAST(resolvedField, monitor);
            }
        } else {
            constantValue = this.computeFieldConstantFromTypeAST(resolvedField, monitor);
            preferenceProject = resolvedField.getJavaProject();
        }
        if (constantValue != null) {
            return String.valueOf(JavadocView.getFormattedAssignmentOperator(preferenceProject)) + JavadocView.formatCompilerConstantValue(constantValue);
        }
        return null;
    }

    private Object computeFieldConstantFromTypeAST(IField constantField, IProgressMonitor monitor) {
        IBinding[] createBindings;
        if (monitor.isCanceled()) {
            return null;
        }
        CompilationUnit ast = SharedASTProvider.getAST(constantField.getTypeRoot(), SharedASTProvider.WAIT_NO, monitor);
        if (ast != null) {
            Expression initializer;
            block11: {
                block10: {
                    try {
                        if (!constantField.isEnumConstant()) break block10;
                        return null;
                    }
                    catch (JavaModelException javaModelException) {}
                }
                VariableDeclarationFragment fieldDecl = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(constantField, ast);
                initializer = fieldDecl.getInitializer();
                if (initializer != null) break block11;
                return null;
            }
            return initializer.resolveConstantExpressionValue();
        }
        if (monitor.isCanceled()) {
            return null;
        }
        ASTParser p = ASTParser.newParser((int)3);
        p.setProject(constantField.getJavaProject());
        try {
            createBindings = p.createBindings(new IJavaElement[]{constantField}, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        IVariableBinding variableBinding = (IVariableBinding)createBindings[0];
        if (variableBinding != null) {
            return variableBinding.getConstantValue();
        }
        return null;
    }

    private static boolean isStaticFinal(IJavaElement member) {
        if (member.getElementType() != 8) {
            return false;
        }
        IField field = (IField)member;
        try {
            return JdtFlags.isFinal((IMember)field) && JdtFlags.isStatic((IMember)field);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    private static Object getConstantValueFromActiveEditor(ITypeRoot activeType, IField field, ITextSelection selection, IProgressMonitor monitor) {
        IVariableBinding variableBinding;
        IBinding binding;
        Object constantValue = null;
        CompilationUnit unit = SharedASTProvider.getAST(activeType, SharedASTProvider.WAIT_ACTIVE_ONLY, monitor);
        if (unit == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)unit, selection.getOffset(), selection.getLength());
        if (node != null && node.getNodeType() == 42 && (binding = ((SimpleName)node).resolveBinding()) != null && binding.getKind() == 3 && field.equals((variableBinding = (IVariableBinding)binding).getJavaElement())) {
            constantValue = variableBinding.getConstantValue();
        }
        return constantValue;
    }

    private static String formatCompilerConstantValue(Object constantValue) {
        if (constantValue instanceof String) {
            StringBuffer result = new StringBuffer();
            result.append('\"');
            String stringConstant = (String)constantValue;
            if (stringConstant.length() > 80) {
                result.append(stringConstant.substring(0, 80));
                result.append("...");
            } else {
                result.append(stringConstant);
            }
            result.append('\"');
            return result.toString();
        }
        if (constantValue instanceof Character) {
            String constantResult = String.valueOf('\'') + constantValue.toString() + '\'';
            char charValue = ((Character)constantValue).charValue();
            String hexString = Integer.toHexString(charValue);
            StringBuffer hexResult = new StringBuffer("\\u");
            int i = hexString.length();
            while (i < 4) {
                hexResult.append('0');
                ++i;
            }
            hexResult.append(hexString);
            return JavadocView.formatWithHexValue(constantResult, hexResult.toString());
        }
        if (constantValue instanceof Byte) {
            int byteValue = ((Byte)constantValue).intValue() & 0xFF;
            return JavadocView.formatWithHexValue(constantValue, "0x" + Integer.toHexString(byteValue));
        }
        if (constantValue instanceof Short) {
            int shortValue = (Short)constantValue & 0xFFFF;
            return JavadocView.formatWithHexValue(constantValue, "0x" + Integer.toHexString(shortValue));
        }
        if (constantValue instanceof Integer) {
            int intValue = (Integer)constantValue;
            return JavadocView.formatWithHexValue(constantValue, "0x" + Integer.toHexString(intValue));
        }
        if (constantValue instanceof Long) {
            long longValue = (Long)constantValue;
            return JavadocView.formatWithHexValue(constantValue, "0x" + Long.toHexString(longValue));
        }
        return constantValue.toString();
    }

    private static String formatWithHexValue(Object constantValue, String hexValue) {
        return Messages.format(InfoViewMessages.JavadocView_constantValue_hexValue, new String[]{constantValue.toString(), hexValue});
    }

    private static String getFormattedAssignmentOperator(IJavaProject javaProject) {
        StringBuffer buffer = new StringBuffer();
        if ("insert".equals(javaProject.getOption("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", true))) {
            buffer.append(' ');
        }
        buffer.append('=');
        if ("insert".equals(javaProject.getOption("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", true))) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private void addLinkListener(Browser browser) {
        browser.addLocationListener(JavaElementLinks.createLocationListener(new JavaElementLinks.ILinkHandler(){

            public void handleDeclarationLink(IJavaElement target) {
                try {
                    JavaUI.openInEditor(target);
                }
                catch (PartInitException e) {
                    JavaPlugin.log(e);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }

            public boolean handleExternalLink(URL url, Display display) {
                if (JavadocView.this.fCurrent == null || !url.equals(JavadocView.this.fCurrent.getInputElement())) {
                    JavadocView.this.fCurrent = new URLBrowserInput(JavadocView.this.fCurrent, url);
                    if (JavadocView.this.fBackAction != null) {
                        JavadocView.this.fBackAction.update();
                        JavadocView.this.fForthAction.update();
                    }
                    if (JavadocView.this.fInputSelectionProvider != null) {
                        JavadocView.this.fInputSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)url));
                    }
                }
                return false;
            }

            public void handleInlineJavadocLink(IJavaElement target) {
                JavaElementBrowserInput newInput = new JavaElementBrowserInput(JavadocView.this.fCurrent, target);
                JavadocView.this.setInput(newInput);
            }

            public void handleJavadocViewLink(IJavaElement target) {
                this.handleInlineJavadocLink(target);
            }

            public void handleTextSet() {
                IJavaElement input = JavadocView.this.getInput();
                if (input == null) {
                    return;
                }
                if (JavadocView.this.fCurrent == null || !JavadocView.this.fCurrent.getInputElement().equals(input)) {
                    JavadocView.this.fCurrent = new JavaElementBrowserInput(null, input);
                    if (JavadocView.this.fBackAction != null) {
                        JavadocView.this.fBackAction.update();
                        JavadocView.this.fForthAction.update();
                    }
                }
            }
        }));
    }

    static /* synthetic */ void access$5() {
        JavadocView.initStyleSheet();
    }

    static /* synthetic */ void access$6(JavadocView javadocView) {
        javadocView.refresh();
    }

    private final class BackAction
    extends Action {
        public BackAction() {
            this.setText(InfoViewMessages.JavadocView_action_back_name);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        private void update() {
            if (JavadocView.this.fCurrent != null && JavadocView.this.fCurrent.getPrevious() != null) {
                BrowserInput element = JavadocView.this.fCurrent.getPrevious();
                this.setToolTipText(Messages.format(InfoViewMessages.JavadocView_action_back_enabledTooltip, BasicElementLabels.getJavaElementName(element.getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(InfoViewMessages.JavadocView_action_back_disabledTooltip);
                this.setEnabled(false);
            }
        }

        public void run() {
            JavadocView.this.setInput(JavadocView.this.fCurrent.getPrevious());
        }
    }

    private final class ForthAction
    extends Action {
        public ForthAction() {
            this.setText(InfoViewMessages.JavadocView_action_forward_name);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void update() {
            if (JavadocView.this.fCurrent != null && JavadocView.this.fCurrent.getNext() != null) {
                BrowserInput element = JavadocView.this.fCurrent.getNext();
                this.setToolTipText(Messages.format(InfoViewMessages.JavadocView_action_forward_enabledTooltip, BasicElementLabels.getJavaElementName(element.getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(InfoViewMessages.JavadocView_action_forward_disabledTooltip);
                this.setEnabled(false);
            }
        }

        public void run() {
            JavadocView.this.setInput(JavadocView.this.fCurrent.getNext());
        }
    }

    private static final class JavaElementBrowserInput
    extends BrowserInput {
        private final IJavaElement fInput;

        public JavaElementBrowserInput(BrowserInput previous, IJavaElement inputElement) {
            super(previous);
            Assert.isNotNull((Object)inputElement);
            this.fInput = inputElement;
        }

        public Object getInputElement() {
            return this.fInput;
        }

        public String getInputName() {
            return this.fInput.getElementName();
        }
    }

    private class LinkAction
    extends Action {
        public LinkAction() {
            super(InfoViewMessages.JavadocView_action_toogleLinking_text, 2);
            JavadocView.this.setTitleToolTip(InfoViewMessages.JavadocView_action_toggleLinking_toolTipText);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "synced.gif");
            this.setChecked(JavadocView.this.isLinkingEnabled());
        }

        public void run() {
            JavadocView.this.setLinkingEnabled(!JavadocView.this.isLinkingEnabled());
        }
    }

    private class SelectAllAction
    extends Action {
        private final Control fControl;
        private final SelectionProvider fSelectionProvider;

        public SelectAllAction(Control control, SelectionProvider selectionProvider) {
            super("selectAll");
            Assert.isNotNull((Object)control);
            Assert.isNotNull((Object)selectionProvider);
            this.fControl = control;
            this.fSelectionProvider = selectionProvider;
            this.setEnabled(!JavadocView.this.fIsUsingBrowserWidget);
            this.setText(InfoViewMessages.SelectAllAction_label);
            this.setToolTipText(InfoViewMessages.SelectAllAction_tooltip);
            this.setDescription(InfoViewMessages.SelectAllAction_description);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        }

        public void run() {
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).selectAll();
            } else if (this.fSelectionProvider != null) {
                this.fSelectionProvider.fireSelectionChanged();
            }
        }
    }

    private static class SelectionProvider
    implements ISelectionProvider {
        private final ListenerList fListeners = new ListenerList(1);
        private final Control fControl;

        public SelectionProvider(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SelectionProvider this$1;
                    {
                        this.this$1 = selectionProvider;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$1.fireSelectionChanged();
                    }
                });
            }
        }

        public void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] selectionChangedListeners = this.fListeners.getListeners();
            int i = 0;
            while (i < selectionChangedListeners.length) {
                ((ISelectionChangedListener)selectionChangedListeners[i]).selectionChanged(event);
                ++i;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fControl instanceof StyledText) {
                Document document = new Document(((StyledText)this.fControl).getSelectionText());
                return new TextSelection((IDocument)document, 0, document.getLength());
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
        }
    }

    private static class URLBrowserInput
    extends BrowserInput {
        private final URL fURL;

        public URLBrowserInput(BrowserInput previous, URL url) {
            super(previous);
            Assert.isNotNull((Object)url);
            this.fURL = url;
        }

        public Object getInputElement() {
            return this.fURL;
        }

        public String getInputName() {
            return this.fURL.toExternalForm();
        }
    }
}

