/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.PullUpDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.HierarchyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableUtil;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ISourceConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class PullUpRefactoringProcessor
extends HierarchyProcessor {
    protected static final String ATTRIBUTE_ABSTRACT = "abstract";
    protected static final String ATTRIBUTE_DELETE = "delete";
    protected static final String ATTRIBUTE_PULL = "pull";
    protected static final String ATTRIBUTE_STUBS = "stubs";
    private static final String IDENTIFIER = "org.eclipse.jdt.ui.pullUpProcessor";
    private static final GroupCategorySet SET_PULL_UP = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.pullUp", RefactoringCoreMessages.PullUpRefactoring_category_name, RefactoringCoreMessages.PullUpRefactoring_category_description));
    protected IMethod[] fAbstractMethods = new IMethod[0];
    private ITypeHierarchy fCachedDeclaringSuperTypeHierarchy;
    private ITypeHierarchy fCachedDestinationTypeHierarchy;
    private Set fCachedSkippedSuperTypes;
    protected Map fCompilationUnitRewrites;
    protected boolean fCreateMethodStubs = true;
    protected IMethod[] fDeletedMethods = new IMethod[0];
    protected IType fDestinationType;

    private static void addMatchingMember(Map mapping, IMember key, IMember matchingMember) {
        Set<IMember> matchingSet;
        if (mapping.containsKey(key)) {
            matchingSet = (Set)mapping.get(key);
        } else {
            matchingSet = new HashSet();
            mapping.put(key, matchingSet);
        }
        Assert.isTrue((!matchingSet.contains(matchingMember) ? 1 : 0) != 0);
        matchingSet.add(matchingMember);
    }

    private static Block createMethodStub(MethodDeclaration method, AST ast) {
        Block body = ast.newBlock();
        Expression expression = ASTNodeFactory.newDefaultExpression(ast, method.getReturnType2(), method.getExtraDimensions());
        if (expression != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            body.statements().add(returnStatement);
        }
        return body;
    }

    private static Set getEffectedSubTypes(ITypeHierarchy hierarchy, IType type) throws JavaModelException {
        IType[] types = null;
        boolean isInterface = type.isInterface();
        if (isInterface) {
            ArrayList<IType> remove = new ArrayList<IType>();
            ArrayList<IType> list = new ArrayList<IType>(Arrays.asList(hierarchy.getSubtypes(type)));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IType element = (IType)iterator.next();
                if (!element.isInterface()) continue;
                remove.add(element);
            }
            list.removeAll(remove);
            types = list.toArray(new IType[list.size()]);
        } else {
            types = hierarchy.getSubclasses(type);
        }
        HashSet<IType> result = new HashSet<IType>();
        int index = 0;
        while (index < types.length) {
            if (!isInterface && JdtFlags.isAbstract((IMember)types[index])) {
                result.addAll(PullUpRefactoringProcessor.getEffectedSubTypes(hierarchy, types[index]));
            } else {
                result.add(types[index]);
            }
            ++index;
        }
        return result;
    }

    private static IMember[] getMembers(IMember[] members, int type) {
        List<IJavaElement> list = Arrays.asList(JavaElementUtil.getElementsOfType((IJavaElement[])members, type));
        return list.toArray(new IMember[list.size()]);
    }

    private static void mergeMaps(Map result, Map map) {
        Iterator iter = result.keySet().iterator();
        while (iter.hasNext()) {
            IMember key = (IMember)iter.next();
            if (!map.containsKey(key)) continue;
            Set resultSet = (Set)result.get(key);
            Set mapSet = (Set)map.get(key);
            resultSet.addAll(mapSet);
        }
    }

    private static void upgradeMap(Map result, Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            IMember key = (IMember)iter.next();
            if (result.containsKey(key)) continue;
            Set mapSet = (Set)map.get(key);
            HashSet resultSet = new HashSet(mapSet);
            result.put(key, resultSet);
        }
    }

    public PullUpRefactoringProcessor(IMember[] members, CodeGenerationSettings settings) {
        this(members, settings, false);
    }

    public PullUpRefactoringProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, null, false);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    protected PullUpRefactoringProcessor(IMember[] members, CodeGenerationSettings settings, boolean layer) {
        super(members, settings, layer);
        if (members != null) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(this.fMembersToMove);
            try {
                if (type != null && RefactoringAvailabilityTester.getPullUpMembers(type).length != 0) {
                    this.fCachedDeclaringType = RefactoringAvailabilityTester.getTopLevelType(this.fMembersToMove);
                    this.fMembersToMove = new IMember[0];
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
    }

    private void addAllRequiredPullableMembers(List queue, IMember member, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)queue);
        Assert.isNotNull((Object)member);
        Assert.isNotNull((Object)monitor);
        SubProgressMonitor sub = null;
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, 6);
            IMethod[] requiredMethods = ReferenceFinderUtil.getMethodsReferencedIn(new IJavaElement[]{member}, this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            sub = new SubProgressMonitor(monitor, 1);
            boolean isStatic = false;
            try {
                sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, requiredMethods.length);
                isStatic = JdtFlags.isStatic(member);
                int index = 0;
                while (index < requiredMethods.length) {
                    IMethod requiredMethod = requiredMethods[index];
                    if (!(isStatic && !JdtFlags.isStatic((IMember)requiredMethod) || !this.isRequiredPullableMember(queue, (IMember)requiredMethod) || MethodChecks.isVirtual(requiredMethod) && this.isAvailableInDestination(requiredMethod, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1)))) {
                        queue.add(requiredMethod);
                    }
                    ++index;
                }
            }
            finally {
                sub.done();
            }
            IField[] requiredFields = ReferenceFinderUtil.getFieldsReferencedIn(new IJavaElement[]{member}, this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            sub = new SubProgressMonitor(monitor, 1);
            try {
                sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, requiredFields.length);
                isStatic = JdtFlags.isStatic(member);
                int index = 0;
                while (index < requiredFields.length) {
                    IField requiredField = requiredFields[index];
                    if ((!isStatic || JdtFlags.isStatic((IMember)requiredField)) && this.isRequiredPullableMember(queue, (IMember)requiredField)) {
                        queue.add(requiredField);
                    }
                    ++index;
                }
            }
            finally {
                sub.done();
            }
            IType[] requiredTypes = ReferenceFinderUtil.getTypesReferencedIn(new IJavaElement[]{member}, this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            sub = new SubProgressMonitor(monitor, 1);
            try {
                sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, requiredMethods.length);
                isStatic = JdtFlags.isStatic(member);
                int index = 0;
                while (index < requiredTypes.length) {
                    IType requiredType = requiredTypes[index];
                    if ((!isStatic || JdtFlags.isStatic((IMember)requiredType)) && this.isRequiredPullableMember(queue, (IMember)requiredType)) {
                        queue.add(requiredType);
                    }
                    ++index;
                }
            }
            finally {
                sub.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void addMethodStubForAbstractMethod(IMethod sourceMethod, CompilationUnit declaringCuNode, AbstractTypeDeclaration typeToCreateStubIn, ICompilationUnit newCu, CompilationUnitRewrite rewriter, Map adjustments, IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        MethodDeclaration methodToCreateStubFor = ASTNodeSearchUtil.getMethodDeclarationNode(sourceMethod, declaringCuNode);
        AST ast = rewriter.getRoot().getAST();
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        newMethod.setBody(PullUpRefactoringProcessor.createMethodStub(methodToCreateStubFor, ast));
        newMethod.setConstructor(false);
        newMethod.setExtraDimensions(methodToCreateStubFor.getExtraDimensions());
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.getModifiersWithUpdatedVisibility((IMember)sourceMethod, JdtFlags.clearFlag(1280, methodToCreateStubFor.getModifiers()), adjustments, (IProgressMonitor)new SubProgressMonitor(monitor, 1), false, status)));
        newMethod.setName((SimpleName)ASTNode.copySubtree((AST)ast, (ASTNode)methodToCreateStubFor.getName()));
        TypeVariableMaplet[] mapping = TypeVariableUtil.composeMappings(TypeVariableUtil.subTypeToSuperType(this.getDeclaringType(), this.getDestinationType()), TypeVariableUtil.superTypeToInheritedType(this.getDestinationType(), (IType)typeToCreateStubIn.resolveBinding().getJavaElement()));
        this.copyReturnType(rewriter.getASTRewrite(), this.getDeclaringType().getCompilationUnit(), methodToCreateStubFor, newMethod, mapping);
        this.copyParameters(rewriter.getASTRewrite(), this.getDeclaringType().getCompilationUnit(), methodToCreateStubFor, newMethod, mapping);
        PullUpRefactoringProcessor.copyThrownExceptions(methodToCreateStubFor, newMethod);
        newMethod.setJavadoc(this.createJavadocForStub(typeToCreateStubIn.getName().getIdentifier(), methodToCreateStubFor, newMethod, newCu, rewriter.getASTRewrite()));
        ImportRewriteUtil.addImports(rewriter, (ASTNode)newMethod, new HashMap(), new HashMap(), false);
        rewriter.getASTRewrite().getListRewrite((ASTNode)typeToCreateStubIn, typeToCreateStubIn.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, ASTNodes.getInsertionIndex((BodyDeclaration)newMethod, typeToCreateStubIn.bodyDeclarations()), (TextEditGroup)rewriter.createCategorizedGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_method_stub, SET_PULL_UP));
    }

    private void addNecessaryMethodStubs(List effected, CompilationUnit root, CompilationUnitRewrite unitRewriter, Map adjustments, IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        IType declaringType = this.getDeclaringType();
        IMethod[] methods = this.getAbstractMethods();
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, effected.size());
            Iterator iter = effected.iterator();
            while (iter.hasNext()) {
                IType type = (IType)iter.next();
                if (type.equals(declaringType)) continue;
                AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(type, unitRewriter.getRoot());
                ICompilationUnit unit = type.getCompilationUnit();
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                try {
                    subMonitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, methods.length);
                    int j = 0;
                    while (j < methods.length) {
                        IMethod method = methods[j];
                        if (JavaModelUtil.findMethod(method.getElementName(), method.getParameterTypes(), method.isConstructor(), type) == null) {
                            this.addMethodStubForAbstractMethod(method, root, declaration, unit, unitRewriter, adjustments, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1), status);
                        }
                        ++j;
                    }
                    subMonitor.done();
                }
                finally {
                    subMonitor.done();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean canBeAccessedFrom(IMember member, IType target, ITypeHierarchy hierarchy) throws JavaModelException {
        if (super.canBeAccessedFrom(member, target, hierarchy)) {
            IMethod method;
            IMethod stub;
            if (target.isInterface()) {
                return true;
            }
            if (target.equals(member.getDeclaringType())) {
                return true;
            }
            if (target.equals(member)) {
                return true;
            }
            if (member instanceof IMethod && (stub = target.getMethod((method = (IMethod)member).getElementName(), method.getParameterTypes())).exists()) {
                return true;
            }
            if (member.getDeclaringType() == null) {
                if (!(member instanceof IType)) {
                    return false;
                }
                if (JdtFlags.isPublic(member)) {
                    return true;
                }
                if (!JdtFlags.isPackageVisible(member)) {
                    return false;
                }
                if (JavaModelUtil.isSamePackage(((IType)member).getPackageFragment(), target.getPackageFragment())) {
                    return true;
                }
                IType type = member.getDeclaringType();
                if (type != null) {
                    return hierarchy.contains(type);
                }
                return false;
            }
            IType declaringType = member.getDeclaringType();
            if (!this.canBeAccessedFrom((IMember)declaringType, target, hierarchy)) {
                return false;
            }
            return !declaringType.equals(this.getDeclaringType());
        }
        return false;
    }

    private RefactoringStatus checkAccessedFields(IProgressMonitor monitor, ITypeHierarchy hierarchy) throws JavaModelException {
        monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking_referenced_elements, 2);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToMove);
        List<IMember> deletedList = Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])this.fMembersToMove, this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IType destination = this.getDestinationType();
        int i = 0;
        while (i < accessedFields.length) {
            IField field = accessedFields[i];
            if (field.exists()) {
                String message;
                boolean isAccessible;
                boolean bl = isAccessible = pulledUpList.contains(field) || deletedList.contains(field) || this.canBeAccessedFrom((IMember)field, destination, hierarchy) || Flags.isEnum((int)field.getFlags());
                if (!isAccessible) {
                    message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_field_not_accessible, new String[]{JavaElementLabels.getTextLabel(field, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_FULLY_QUALIFIED)});
                    result.addError(message, JavaStatusContext.create((IMember)field));
                } else if (this.getSkippedSuperTypes((IProgressMonitor)new SubProgressMonitor(monitor, 1)).contains(field.getDeclaringType())) {
                    message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_field_cannot_be_accessed, new String[]{JavaElementLabels.getTextLabel(field, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_FULLY_QUALIFIED)});
                    result.addError(message, JavaStatusContext.create((IMember)field));
                }
            }
            ++i;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethods(IProgressMonitor monitor, ITypeHierarchy hierarchy) throws JavaModelException {
        monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking_referenced_elements, 2);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToMove);
        List<IMethod> declaredAbstractList = Arrays.asList(this.fAbstractMethods);
        List<IMember> deletedList = Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])this.fMembersToMove, this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IType destination = this.getDestinationType();
        int index = 0;
        while (index < accessedMethods.length) {
            IMethod method = accessedMethods[index];
            if (method.exists()) {
                boolean isAccessible;
                boolean bl = isAccessible = pulledUpList.contains(method) || deletedList.contains(method) || declaredAbstractList.contains(method) || this.canBeAccessedFrom((IMember)method, destination, hierarchy);
                if (!isAccessible) {
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_method_not_accessible, new String[]{JavaElementLabels.getTextLabel(method, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_FULLY_QUALIFIED)});
                    result.addError(message, JavaStatusContext.create((IMember)method));
                } else if (this.getSkippedSuperTypes((IProgressMonitor)new SubProgressMonitor(monitor, 1)).contains(method.getDeclaringType())) {
                    Object[] keys = new String[]{JavaElementLabels.getTextLabel(method, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_FULLY_QUALIFIED)};
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_method_cannot_be_accessed, keys);
                    result.addError(message, JavaStatusContext.create((IMember)method));
                }
            }
            ++index;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus checkAccessedTypes(IProgressMonitor monitor, ITypeHierarchy hierarchy) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = this.getTypesReferencedInMovedMembers(monitor);
        IType destination = this.getDestinationType();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToMove);
        int index = 0;
        while (index < accessedTypes.length) {
            IType type = accessedTypes[index];
            if (type.exists() && !this.canBeAccessedFrom((IMember)type, destination, hierarchy) && !pulledUpList.contains(type)) {
                String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_type_not_accessible, new String[]{JavaElementLabels.getTextLabel(type, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_FULLY_QUALIFIED)});
                result.addError(message, JavaStatusContext.create((IMember)type));
            }
            ++index;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus checkAccesses(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking_referenced_elements, 4);
            ITypeHierarchy hierarchy = this.getDestinationType().newSupertypeHierarchy(this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            result.merge(this.checkAccessedTypes((IProgressMonitor)new SubProgressMonitor(monitor, 1), hierarchy));
            result.merge(this.checkAccessedFields((IProgressMonitor)new SubProgressMonitor(monitor, 1), hierarchy));
            result.merge(this.checkAccessedMethods((IProgressMonitor)new SubProgressMonitor(monitor, 1), hierarchy));
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private void checkAccessModifiers(RefactoringStatus result, Set notDeletedMembersInSubtypes) throws JavaModelException {
        if (this.fDestinationType.isInterface()) {
            return;
        }
        List<IMethod> toDeclareAbstract = Arrays.asList(this.fAbstractMethods);
        Iterator iter = notDeletedMembersInSubtypes.iterator();
        while (iter.hasNext()) {
            IMember member = (IMember)iter.next();
            if (member.getElementType() != 9 || toDeclareAbstract.contains(member)) continue;
            IMethod method = (IMethod)member;
            if (method.getDeclaringType().getPackageFragment().equals(this.fDestinationType.getPackageFragment())) {
                if (!JdtFlags.isPrivate((IMember)method)) continue;
                result.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_lower_default_visibility, new String[]{JavaElementLabels.getTextLabel(method, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(method.getDeclaringType(), JavaElementLabels.ALL_FULLY_QUALIFIED)}), JavaStatusContext.create((IMember)method));
                continue;
            }
            if (JdtFlags.isPublic((IMember)method) || JdtFlags.isProtected((IMember)method)) continue;
            result.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_lower_protected_visibility, new String[]{JavaElementLabels.getTextLabel(method, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(method.getDeclaringType(), JavaElementLabels.ALL_FULLY_QUALIFIED)}), JavaStatusContext.create((IMember)method));
        }
    }

    protected RefactoringStatus checkDeclaringSuperTypes(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.getCandidateTypes(result, monitor).length == 0 && !result.hasFatalError()) {
            String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_not_this_type, new String[]{JavaElementLabels.getTextLabel(this.getDeclaringType(), JavaElementLabels.ALL_FULLY_QUALIFIED)});
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        return result;
    }

    protected RefactoringStatus checkDeclaringType(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus status = super.checkDeclaringType(monitor);
        if (this.getDeclaringType().getFullyQualifiedName('.').equals("java.lang.Object")) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PullUpRefactoring_no_java_lang_Object));
        }
        status.merge(this.checkDeclaringSuperTypes(monitor));
        return status;
    }

    private void checkFieldTypes(IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        Map mapping = this.getMatchingMembers(this.getDestinationTypeHierarchy(monitor), this.getDestinationType(), true);
        int i = 0;
        while (i < this.fMembersToMove.length) {
            if (this.fMembersToMove[i].getElementType() == 8) {
                IField field = (IField)this.fMembersToMove[i];
                String type = Signature.toString((String)field.getTypeSignature());
                Assert.isTrue((boolean)mapping.containsKey(field));
                Iterator iter = ((Set)mapping.get(field)).iterator();
                while (iter.hasNext()) {
                    IField matchingField = (IField)iter.next();
                    if (field.equals(matchingField) || type.equals(Signature.toString((String)matchingField.getTypeSignature()))) continue;
                    Object[] keys = new String[]{JavaElementLabels.getTextLabel(matchingField, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(matchingField.getDeclaringType(), JavaElementLabels.ALL_FULLY_QUALIFIED)};
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_different_field_type, keys);
                    RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)matchingField.getCompilationUnit(), matchingField.getSourceRange());
                    status.addError(message, context);
                }
            }
            ++i;
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 12);
            this.clearCaches();
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.createWorkingCopyLayer((IProgressMonitor)new SubProgressMonitor(monitor, 4)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkGenericDeclaringType(new SubProgressMonitor(monitor, 1)));
            result.merge(this.checkFinalFields((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkAccesses((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            result.merge(this.checkMembersInTypeAndAllSubtypes((IProgressMonitor)new SubProgressMonitor(monitor, 2)));
            result.merge(this.checkIfSkippingOverElements((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!JdtFlags.isAbstract((IMember)this.getDestinationType()) && this.getAbstractMethods().length > 0) {
                result.merge(this.checkConstructorCalls(this.getDestinationType(), (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            } else {
                monitor.worked(1);
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.fCompilationUnitRewrites = new HashMap(3);
            result.merge(PullUpRefactoringProcessor.checkProjectCompliance(this.getCompilationUnitRewrite(this.fCompilationUnitRewrites, this.getDeclaringType().getCompilationUnit()), this.getDestinationType(), this.fMembersToMove));
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(monitor, 1), result);
            Checks.addModifiedFilesToChecker(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), context);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus checkFinalFields(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, this.fMembersToMove.length);
        int index = 0;
        while (index < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[index];
            if (member.getElementType() == 8 && !JdtFlags.isStatic(member)) {
                RefactoringStatusContext context;
                if (JdtFlags.isFinal(member)) {
                    context = JavaStatusContext.create(member);
                    result.addWarning(RefactoringCoreMessages.PullUpRefactoring_final_fields, context);
                } else if (this.getDestinationType().isInterface()) {
                    context = JavaStatusContext.create(member);
                    result.addWarning(RefactoringCoreMessages.PullUpRefactoring_non_final_pull_up_to_interface, context);
                }
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++index;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus checkGenericDeclaringType(SubProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            IMember[] pullables = this.getMembersToMove();
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, pullables.length);
            IType declaring = this.getDeclaringType();
            ITypeParameter[] parameters = declaring.getTypeParameters();
            if (parameters.length > 0) {
                TypeVariableMaplet[] mapping = TypeVariableUtil.subTypeToInheritedType(declaring);
                IMember member = null;
                int length = 0;
                int index = 0;
                while (index < pullables.length) {
                    member = pullables[index];
                    String[] unmapped = TypeVariableUtil.getUnmappedVariables(mapping, declaring, member);
                    length = unmapped.length;
                    String superClassLabel = BasicElementLabels.getJavaElementName(declaring.getSuperclassName());
                    switch (length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variable_not_available, new String[]{unmapped[0], superClassLabel}), JavaStatusContext.create(member));
                            break;
                        }
                        case 2: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variable2_not_available, new String[]{unmapped[0], unmapped[1], superClassLabel}), JavaStatusContext.create(member));
                            break;
                        }
                        case 3: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variable3_not_available, new String[]{unmapped[0], unmapped[1], unmapped[2], superClassLabel}), JavaStatusContext.create(member));
                            break;
                        }
                        default: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variables_not_available, new String[]{superClassLabel}), JavaStatusContext.create(member));
                        }
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++index;
                }
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus checkIfDeclaredIn(IMember element, IType type) throws JavaModelException {
        if (element instanceof IMethod) {
            return this.checkIfMethodDeclaredIn((IMethod)element, type);
        }
        if (element instanceof IField) {
            return this.checkIfFieldDeclaredIn((IField)element, type);
        }
        if (element instanceof IType) {
            return this.checkIfTypeDeclaredIn((IType)element, type);
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private RefactoringStatus checkIfFieldDeclaredIn(IField iField, IType type) {
        IField fieldInType = type.getField(iField.getElementName());
        if (!fieldInType.exists()) {
            return null;
        }
        Object[] keys = new String[]{JavaElementLabels.getTextLabel(fieldInType, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(type, JavaElementLabels.ALL_FULLY_QUALIFIED)};
        String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_Field_declared_in_class, keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)fieldInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    private RefactoringStatus checkIfMethodDeclaredIn(IMethod iMethod, IType type) throws JavaModelException {
        IMethod methodInType = JavaModelUtil.findMethod(iMethod.getElementName(), iMethod.getParameterTypes(), iMethod.isConstructor(), type);
        if (methodInType == null || !methodInType.exists()) {
            return null;
        }
        Object[] keys = new String[]{JavaElementLabels.getTextLabel(methodInType, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(type, JavaElementLabels.ALL_FULLY_QUALIFIED)};
        String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_Method_declared_in_class, keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)methodInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    private RefactoringStatus checkIfSkippingOverElements(IProgressMonitor monitor) throws JavaModelException {
        monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 1);
        try {
            Set skippedTypes = this.getSkippedSuperTypes((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] skipped = skippedTypes.toArray(new IType[skippedTypes.size()]);
            RefactoringStatus result = new RefactoringStatus();
            int i = 0;
            while (i < this.fMembersToMove.length) {
                IMember element = this.fMembersToMove[i];
                int j = 0;
                while (j < skipped.length) {
                    result.merge(this.checkIfDeclaredIn(element, skipped[j]));
                    ++j;
                }
                ++i;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus checkIfTypeDeclaredIn(IType iType, IType type) {
        IType typeInType = type.getType(iType.getElementName());
        if (!typeInType.exists()) {
            return null;
        }
        Object[] keys = new String[]{JavaElementLabels.getTextLabel(typeInType, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(type, JavaElementLabels.ALL_FULLY_QUALIFIED)};
        String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_declared_in_class, keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)typeInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 1);
            RefactoringStatus status = new RefactoringStatus();
            status.merge(this.checkDeclaringType((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            status.merge(this.checkIfMembersExist());
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private void checkMembersInDestinationType(RefactoringStatus status, Set set) throws JavaModelException {
        IMember[] destinationMembers = this.getCreatedDestinationMembers();
        ArrayList<IMember> list = new ArrayList<IMember>(destinationMembers.length);
        list.addAll(Arrays.asList(destinationMembers));
        list.addAll(set);
        list.removeAll(Arrays.asList(this.fDeletedMethods));
        IMember[] members = list.toArray(new IMember[list.size()]);
        status.merge(MemberCheckUtil.checkMembersInDestinationType(members, this.getDestinationType()));
    }

    private RefactoringStatus checkMembersInTypeAndAllSubtypes(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 3);
        Set notDeletedMembers = this.getNotDeletedMembers((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        HashSet<IMember> notDeletedMembersInTargetType = new HashSet<IMember>();
        HashSet<IMember> notDeletedMembersInSubtypes = new HashSet<IMember>();
        Iterator iter = notDeletedMembers.iterator();
        while (iter.hasNext()) {
            IMember member = (IMember)iter.next();
            if (this.getDestinationType().equals(member.getDeclaringType())) {
                notDeletedMembersInTargetType.add(member);
                continue;
            }
            notDeletedMembersInSubtypes.add(member);
        }
        this.checkMembersInDestinationType(result, notDeletedMembersInTargetType);
        this.checkAccessModifiers(result, notDeletedMembersInSubtypes);
        this.checkMethodReturnTypes((IProgressMonitor)new SubProgressMonitor(monitor, 1), result, notDeletedMembersInSubtypes);
        this.checkFieldTypes((IProgressMonitor)new SubProgressMonitor(monitor, 1), result);
        monitor.done();
        return result;
    }

    private void checkMethodReturnTypes(IProgressMonitor monitor, RefactoringStatus status, Set notDeletedMembersInSubtypes) throws JavaModelException {
        Map mapping = this.getMatchingMembers(this.getDestinationTypeHierarchy(monitor), this.getDestinationType(), true);
        IMember[] members = this.getCreatedDestinationMembers();
        int i = 0;
        while (i < members.length) {
            Set set;
            IMethod method;
            if (members[i].getElementType() == 9 && mapping.containsKey(method = (IMethod)members[i]) && (set = (Set)mapping.get(method)) != null) {
                String returnType = Signature.toString((String)Signature.getReturnType((String)method.getSignature()).toString());
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    IMethod matchingMethod = (IMethod)iter.next();
                    if (method.equals(matchingMethod) || !notDeletedMembersInSubtypes.contains(matchingMethod) || returnType.equals(Signature.toString((String)Signature.getReturnType((String)matchingMethod.getSignature()).toString()))) continue;
                    Object[] keys = new String[]{JavaElementLabels.getTextLabel(matchingMethod, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(matchingMethod.getDeclaringType(), JavaElementLabels.ALL_FULLY_QUALIFIED)};
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_different_method_return_type, keys);
                    RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)matchingMethod.getCompilationUnit(), matchingMethod.getNameRange());
                    status.addError(message, context);
                }
            }
            ++i;
        }
    }

    protected void clearCaches() {
        super.clearCaches();
        this.fCachedMembersReferences.clear();
        this.fCachedDestinationTypeHierarchy = null;
        this.fCachedDeclaringSuperTypeHierarchy = null;
    }

    private void copyBodyOfPulledUpMethod(CompilationUnitRewrite sourceRewrite, CompilationUnitRewrite targetRewrite, IMethod method, MethodDeclaration oldMethod, MethodDeclaration newMethod, TypeVariableMaplet[] mapping, IProgressMonitor monitor) throws JavaModelException {
        Block body = oldMethod.getBody();
        if (body == null) {
            newMethod.setBody(null);
            return;
        }
        try {
            Document document = new Document(method.getCompilationUnit().getBuffer().getContents());
            ASTRewrite rewrite = ASTRewrite.create((AST)body.getAST());
            ITrackedNodePosition position = rewrite.track((ASTNode)body);
            body.accept((ASTVisitor)new PullUpAstNodeMapper(sourceRewrite, targetRewrite, rewrite, this.getDeclaringSuperTypeHierarchy(monitor).getSuperclass(this.getDeclaringType()), mapping, oldMethod.resolveBinding()));
            rewrite.rewriteAST((IDocument)document, method.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            String content = document.get(position.getStartPosition(), position.getLength());
            String[] lines = Strings.convertIntoLines(content);
            Strings.trimIndentation(lines, method.getJavaProject(), false);
            content = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)method));
            newMethod.setBody((Block)targetRewrite.getASTRewrite().createStringPlaceholder(content, 8));
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
    }

    private void createAbstractMethod(IMethod sourceMethod, CompilationUnitRewrite sourceRewriter, CompilationUnit declaringCuNode, AbstractTypeDeclaration destination, TypeVariableMaplet[] mapping, CompilationUnitRewrite targetRewrite, Map adjustments, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        MethodDeclaration oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode(sourceMethod, declaringCuNode);
        if (JavaModelUtil.is50OrHigher(sourceMethod.getJavaProject()) && (this.fSettings.overrideAnnotation || "error".equals(sourceMethod.getJavaProject().getOption("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", true)))) {
            MarkerAnnotation annotation = sourceRewriter.getAST().newMarkerAnnotation();
            annotation.setTypeName((Name)sourceRewriter.getAST().newSimpleName("Override"));
            sourceRewriter.getASTRewrite().getListRewrite((ASTNode)oldMethod, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)annotation, (TextEditGroup)sourceRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_override_annotation, SET_PULL_UP));
        }
        MethodDeclaration newMethod = targetRewrite.getAST().newMethodDeclaration();
        newMethod.setBody(null);
        newMethod.setConstructor(false);
        newMethod.setExtraDimensions(oldMethod.getExtraDimensions());
        newMethod.setJavadoc(null);
        int modifiers = this.getModifiersWithUpdatedVisibility((IMember)sourceMethod, 0x400 | JdtFlags.clearFlag(272, sourceMethod.getFlags()), adjustments, monitor, false, status);
        if (oldMethod.isVarargs()) {
            modifiers &= 0xFFFFFF7F;
        }
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(targetRewrite.getAST(), modifiers));
        newMethod.setName((SimpleName)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)oldMethod.getName()));
        this.copyReturnType(targetRewrite.getASTRewrite(), this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        this.copyParameters(targetRewrite.getASTRewrite(), this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        PullUpRefactoringProcessor.copyThrownExceptions(oldMethod, newMethod);
        ImportRewriteUtil.addImports(targetRewrite, (ASTNode)newMethod, new HashMap(), new HashMap(), false);
        targetRewrite.getASTRewrite().getListRewrite((ASTNode)destination, destination.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, ASTNodes.getInsertionIndex((BodyDeclaration)newMethod, destination.bodyDeclarations()), (TextEditGroup)targetRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_abstract_method, SET_PULL_UP));
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IType declaring = this.getDeclaringType();
            IJavaProject javaProject = declaring.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            try {
                if (declaring.isLocal() || declaring.isAnonymous()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
            String description = this.fMembersToMove.length == 1 ? Messages.format(RefactoringCoreMessages.PullUpRefactoring_descriptor_description_short, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fMembersToMove[0], JavaElementLabels.ALL_DEFAULT), JavaElementLabels.getElementLabel((IJavaElement)this.fDestinationType, JavaElementLabels.ALL_DEFAULT)}) : Messages.format(RefactoringCoreMessages.PullUpRefactoring_descriptor_description_short_multiple, BasicElementLabels.getJavaElementName(this.fDestinationType.getElementName()));
            String header = this.fMembersToMove.length == 1 ? Messages.format(RefactoringCoreMessages.PullUpRefactoring_descriptor_description_full, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fMembersToMove[0], JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)declaring, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)this.fDestinationType, JavaElementLabels.ALL_FULLY_QUALIFIED)}) : Messages.format(RefactoringCoreMessages.PullUpRefactoring_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)declaring, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)this.fDestinationType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveStaticMembersProcessor_target_element_pattern, JavaElementLabels.getElementLabel((IJavaElement)this.fDestinationType, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            this.addSuperTypeSettings(comment, true);
            PullUpDescriptor descriptor = RefactoringSignatureDescriptorFactory.createPullUpDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fDestinationType));
            arguments.put("replace", Boolean.valueOf(this.fReplace).toString());
            arguments.put("instanceof", Boolean.valueOf(this.fInstanceOf).toString());
            arguments.put(ATTRIBUTE_STUBS, Boolean.valueOf(this.fCreateMethodStubs).toString());
            arguments.put(ATTRIBUTE_PULL, new Integer(this.fMembersToMove.length).toString());
            int offset = 0;
            while (offset < this.fMembersToMove.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fMembersToMove[offset]));
                ++offset;
            }
            arguments.put(ATTRIBUTE_DELETE, new Integer(this.fDeletedMethods.length).toString());
            offset = 0;
            while (offset < this.fDeletedMethods.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fDeletedMethods[offset]));
                ++offset;
            }
            arguments.put(ATTRIBUTE_ABSTRACT, new Integer(this.fAbstractMethods.length).toString());
            offset = 0;
            while (offset < this.fAbstractMethods.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + this.fDeletedMethods.length + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fAbstractMethods[offset]));
                ++offset;
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.PullUpRefactoring_Pull_Up, (Change[])this.fChangeManager.getAllChanges());
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
            this.clearCaches();
        }
    }

    /*
     * Unable to fully structure code
     */
    private TextEditBasedChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        try {
            block45: {
                monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 24);
                source = this.getDeclaringType().getCompilationUnit();
                destination = this.getDestinationType();
                target = destination.getCompilationUnit();
                sourceRewriter = this.getCompilationUnitRewrite(this.fCompilationUnitRewrites, source);
                targetRewriter = this.getCompilationUnitRewrite(this.fCompilationUnitRewrites, target);
                deleteMap = this.createMembersToDeleteMap((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                effectedMap = this.createEffectedTypesMap((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                units = this.getAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                adjustments = new HashMap<IMethod, MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment>();
                adjustor = null;
                sub = new SubProgressMonitor(monitor, 1);
                try {
                    sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, units.length * 11);
                    index = 0;
                    while (index < units.length) {
                        unit = units[index];
                        if (!(source.equals(unit) || target.equals(unit) || deleteMap.containsKey(unit) || effectedMap.containsKey(unit))) {
                            sub.worked(10);
                        } else {
                            rewrite = this.getCompilationUnitRewrite(this.fCompilationUnitRewrites, unit);
                            if (deleteMap.containsKey(unit)) {
                                list = new LinkedList<E>((List)deleteMap.get(unit));
                                if (destination.isInterface()) {
                                    iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        member = (IMember)iterator.next();
                                        if (!(member instanceof IMethod)) continue;
                                        iterator.remove();
                                    }
                                }
                                PullUpRefactoringProcessor.deleteDeclarationNodes(sourceRewriter, sourceRewriter.getCu().equals(targetRewriter.getCu()), rewrite, list, PullUpRefactoringProcessor.SET_PULL_UP);
                            }
                            root = sourceRewriter.getRoot();
                            if (unit.equals(target)) {
                                rewriter = rewrite.getASTRewrite();
                                if (!JdtFlags.isAbstract((IMember)destination) && !destination.isInterface() && this.getAbstractMethods().length > 0) {
                                    declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(destination, rewrite.getRoot());
                                    ModifierRewrite.create(rewriter, (ASTNode)declaration).setModifiers(declaration.getModifiers() | 1024, (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.PullUpRefactoring_make_target_abstract, PullUpRefactoringProcessor.SET_PULL_UP));
                                }
                                mapping = TypeVariableUtil.subTypeToSuperType(this.getDeclaringType(), destination);
                                subsub = new SubProgressMonitor((IProgressMonitor)sub, 1);
                                declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(destination, rewrite.getRoot());
                                this.fMembersToMove = JavaElementUtil.sortByOffset(this.fMembersToMove);
                                subsub.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, this.fMembersToMove.length);
                                member = null;
                                offset = this.fMembersToMove.length - 1;
                                while (offset >= 0) {
                                    member = this.fMembersToMove[offset];
                                    adjustor = new MemberVisibilityAdjustor((IJavaElement)destination, member);
                                    adjustor.setRewrite(sourceRewriter.getASTRewrite(), root);
                                    adjustor.setFailureSeverity(2);
                                    adjustor.setOwner(this.fOwner);
                                    adjustor.setRewrites(this.fCompilationUnitRewrites);
                                    adjustor.setStatus(status);
                                    adjustor.setAdjustments(adjustments);
                                    adjustor.adjustVisibility((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsub, 1));
                                    adjustments.remove(member);
                                    if (member instanceof IField) {
                                        oldField = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, root);
                                        if (oldField != null) {
                                            flags = this.getModifiersWithUpdatedVisibility(member, member.getFlags(), adjustments, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsub, 1), true, status);
                                            if (destination.isInterface()) {
                                                flags |= 16;
                                            }
                                            newField = PullUpRefactoringProcessor.createNewFieldDeclarationNode(rewriter, root, (IField)member, oldField, mapping, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsub, 1), status, flags);
                                            rewriter.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newField, ASTNodes.getInsertionIndex((BodyDeclaration)newField, declaration.bodyDeclarations()), (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, PullUpRefactoringProcessor.SET_PULL_UP));
                                            ImportRewriteUtil.addImports(rewrite, oldField.getParent(), new HashMap<K, V>(), new HashMap<K, V>(), false);
                                        }
                                    } else if (member instanceof IMethod) {
                                        oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, root);
                                        if (oldMethod != null) {
                                            if (JdtFlags.isStatic(member) && this.fDestinationType.isInterface()) {
                                                status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.PullUpRefactoring_moving_static_method_to_interface, new String[]{JavaElementLabels.getTextLabel(member, JavaElementLabels.ALL_FULLY_QUALIFIED)}), (RefactoringStatusContext)JavaStatusContext.create(member)));
                                            }
                                            newMethod = this.createNewMethodDeclarationNode(sourceRewriter, rewrite, (IMethod)member, oldMethod, mapping, adjustments, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsub, 1), status);
                                            rewriter.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, ASTNodes.getInsertionIndex((BodyDeclaration)newMethod, declaration.bodyDeclarations()), (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, PullUpRefactoringProcessor.SET_PULL_UP));
                                            ImportRewriteUtil.addImports(rewrite, (ASTNode)oldMethod, new HashMap<K, V>(), new HashMap<K, V>(), false);
                                        }
                                    } else if (member instanceof IType) {
                                        oldType = ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)member, root);
                                        if (oldType != null) {
                                            newType = this.createNewTypeDeclarationNode((IType)member, oldType, root, mapping, rewriter);
                                            rewriter.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newType, ASTNodes.getInsertionIndex(newType, declaration.bodyDeclarations()), (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, PullUpRefactoringProcessor.SET_PULL_UP));
                                            ImportRewriteUtil.addImports(rewrite, (ASTNode)oldType, new HashMap<K, V>(), new HashMap<K, V>(), false);
                                        }
                                    } else {
                                        Assert.isTrue((boolean)false);
                                    }
                                    subsub.worked(1);
                                    --offset;
                                }
                                subsub.done();
                                offset = 0;
                                while (offset < this.fAbstractMethods.length) {
                                    this.createAbstractMethod(this.fAbstractMethods[offset], sourceRewriter, root, declaration, mapping, rewrite, adjustments, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1), status);
                                    ++offset;
                                }
                            } else {
                                sub.worked(2);
                            }
                            if (unit.equals(sourceRewriter.getCu())) {
                                subsub = new SubProgressMonitor((IProgressMonitor)sub, 1);
                                subsub.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, this.fAbstractMethods.length * 2);
                                method = null;
                                offset = 0;
                                while (offset < this.fAbstractMethods.length) {
                                    method = this.fAbstractMethods[offset];
                                    adjustor = new MemberVisibilityAdjustor((IJavaElement)destination, (IMember)method);
                                    adjustor.setRewrite(sourceRewriter.getASTRewrite(), root);
                                    adjustor.setRewrites(this.fCompilationUnitRewrites);
                                    adjustor.setFailureSeverity(2);
                                    adjustor.setOwner(this.fOwner);
                                    adjustor.setStatus(status);
                                    adjustor.setAdjustments(adjustments);
                                    if (this.needsVisibilityAdjustment((IMember)method, false, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsub, 1), status)) {
                                        adjustments.put(method, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)method, Modifier.ModifierKeyword.PROTECTED_KEYWORD, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning, new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)method), RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_protected}), (RefactoringStatusContext)JavaStatusContext.create((IMember)method))));
                                    }
                                    ++offset;
                                }
                            } else {
                                sub.worked(2);
                            }
                            if (effectedMap.containsKey(unit)) {
                                this.addNecessaryMethodStubs((List)effectedMap.get(unit), root, rewrite, adjustments, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 2), status);
                            }
                            if (sub.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                        }
                        ++index;
                    }
                }
                finally {
                    sub.done();
                }
                if (adjustor != null && !adjustments.isEmpty()) {
                    adjustor.rewriteVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                manager = new TextEditBasedChangeManager();
                if (!this.fReplace) break block45;
                set = this.fCompilationUnitRewrites.keySet();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    unit = (ICompilationUnit)iterator.next();
                    rewrite = (CompilationUnitRewrite)this.fCompilationUnitRewrites.get(unit);
                    if (rewrite == null || (change = rewrite.createChange(false, null)) == null) continue;
                    manager.manage(unit, (TextEditBasedChange)change);
                }
                edit = null;
                change = null;
                workingcopies = new HashMap<ICompilationUnit, ICompilationUnit>();
                subMonitor = new SubProgressMonitor(monitor, 1);
                try {
                    subMonitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, set.size());
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        unit = (ICompilationUnit)iterator.next();
                        change = manager.get(unit);
                        if (!(change instanceof TextChange) || (edit = ((TextChange)change).getEdit()) == null || (copy = this.createWorkingCopy(unit, edit, status, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) == null) continue;
                        workingcopies.put(unit, copy);
                    }
                    current = (ICompilationUnit)workingcopies.get(sourceRewriter.getCu());
                    if (current != null) {
                        this.rewriteTypeOccurrences(manager, sourceRewriter, current, new HashSet<E>(), status, (IProgressMonitor)new SubProgressMonitor(monitor, 16));
                    }
                }
                finally {
                    subMonitor.done();
                    cus = manager.getAllCompilationUnits();
                    index = 0;
                    if (true) ** GOTO lbl178
                }
                {
                }
                do {
                    unit = cus[index];
                    current = (CompilationUnitChange)manager.get(unit);
                    if (change != null && current.getEdit() == null) {
                        manager.remove(unit);
                    }
                    if ((rewrite = (CompilationUnitRewrite)this.fCompilationUnitRewrites.get(unit)) != null) {
                        rewrite.clearGroupDescriptions();
                    }
                    ++index;
lbl178:
                    // 2 sources

                } while (index < cus.length);
            }
            this.registerChanges(manager);
            var30_40 = manager;
            return var30_40;
        }
        finally {
            this.fCompilationUnitRewrites.clear();
            monitor.done();
        }
    }

    private Map createEffectedTypesMap(IProgressMonitor monitor) throws JavaModelException {
        if (!this.fCreateMethodStubs || this.getAbstractMethods().length <= 0) {
            return new HashMap(0);
        }
        Set effected = PullUpRefactoringProcessor.getEffectedSubTypes(this.getDestinationTypeHierarchy(monitor), this.getDestinationType());
        HashMap result = new HashMap();
        Iterator iterator = effected.iterator();
        while (iterator.hasNext()) {
            IType type = (IType)iterator.next();
            ICompilationUnit unit = type.getCompilationUnit();
            if (!result.containsKey(unit)) {
                result.put(unit, new ArrayList(1));
            }
            ((List)result.get(unit)).add(type);
        }
        return result;
    }

    private Javadoc createJavadocForStub(String enclosingTypeName, MethodDeclaration oldMethod, MethodDeclaration newMethodNode, ICompilationUnit cu, ASTRewrite rewrite) throws CoreException {
        IMethodBinding binding;
        if (this.fSettings.createComments && (binding = oldMethod.resolveBinding()) != null) {
            ITypeBinding[] params = binding.getParameterTypes();
            String fullTypeName = this.getDestinationType().getFullyQualifiedName('.');
            String[] fullParamNames = new String[params.length];
            int i = 0;
            while (i < fullParamNames.length) {
                fullParamNames[i] = Bindings.getFullyQualifiedName(params[i]);
                ++i;
            }
            String comment = CodeGeneration.getMethodComment(cu, enclosingTypeName, newMethodNode, false, binding.getName(), fullTypeName, fullParamNames, StubUtility.getLineDelimiterUsed((IJavaElement)cu));
            return (Javadoc)rewrite.createStringPlaceholder(comment, 29);
        }
        return null;
    }

    private Map createMembersToDeleteMap(IProgressMonitor monitor) throws JavaModelException {
        IMember[] membersToDelete = this.getMembersToDelete(monitor);
        HashMap result = new HashMap();
        int i = 0;
        while (i < membersToDelete.length) {
            IMember member = membersToDelete[i];
            ICompilationUnit cu = member.getCompilationUnit();
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((List)result.get(cu)).add(member);
            ++i;
        }
        return result;
    }

    private MethodDeclaration createNewMethodDeclarationNode(CompilationUnitRewrite sourceRewrite, CompilationUnitRewrite targetRewrite, IMethod sourceMethod, MethodDeclaration oldMethod, TypeVariableMaplet[] mapping, Map adjustments, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        AST ast = rewrite.getAST();
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        if (!this.getDestinationType().isInterface()) {
            this.copyBodyOfPulledUpMethod(sourceRewrite, targetRewrite, sourceMethod, oldMethod, newMethod, mapping, monitor);
        }
        newMethod.setConstructor(oldMethod.isConstructor());
        newMethod.setExtraDimensions(oldMethod.getExtraDimensions());
        PullUpRefactoringProcessor.copyJavadocNode(rewrite, (BodyDeclaration)oldMethod, (BodyDeclaration)newMethod);
        int modifiers = this.getModifiersWithUpdatedVisibility((IMember)sourceMethod, sourceMethod.getFlags(), adjustments, monitor, true, status);
        if (this.fDeletedMethods.length == 0 || this.getDestinationType().isInterface()) {
            modifiers &= 0xFFFFFFEF;
        }
        if (oldMethod.isVarargs()) {
            modifiers &= 0xFFFFFF7F;
        }
        PullUpRefactoringProcessor.copyAnnotations(oldMethod, newMethod);
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers));
        newMethod.setName((SimpleName)ASTNode.copySubtree((AST)ast, (ASTNode)oldMethod.getName()));
        this.copyReturnType(rewrite, this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        this.copyParameters(rewrite, this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        PullUpRefactoringProcessor.copyThrownExceptions(oldMethod, newMethod);
        PullUpRefactoringProcessor.copyTypeParameters(oldMethod, newMethod);
        return newMethod;
    }

    private BodyDeclaration createNewTypeDeclarationNode(IType type, AbstractTypeDeclaration oldType, CompilationUnit declaringCuNode, TypeVariableMaplet[] mapping, ASTRewrite rewrite) throws JavaModelException {
        ICompilationUnit declaringCu = this.getDeclaringType().getCompilationUnit();
        if (!JdtFlags.isPublic((IMember)type) && !JdtFlags.isProtected((IMember)type)) {
            if (mapping.length > 0) {
                return PullUpRefactoringProcessor.createPlaceholderForTypeDeclaration((BodyDeclaration)oldType, declaringCu, mapping, rewrite, true);
            }
            return PullUpRefactoringProcessor.createPlaceholderForProtectedTypeDeclaration((BodyDeclaration)oldType, declaringCuNode, declaringCu, rewrite, true);
        }
        if (mapping.length > 0) {
            return PullUpRefactoringProcessor.createPlaceholderForTypeDeclaration((BodyDeclaration)oldType, declaringCu, mapping, rewrite, true);
        }
        return PullUpRefactoringProcessor.createPlaceholderForTypeDeclaration((BodyDeclaration)oldType, declaringCu, rewrite, true);
    }

    private ICompilationUnit createWorkingCopy(ICompilationUnit unit, TextEdit edit, RefactoringStatus status, IProgressMonitor monitor) {
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 1);
            ICompilationUnit copy = this.getSharedWorkingCopy(unit.getPrimary(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            Document document = new Document(unit.getBuffer().getContents());
            edit.apply((IDocument)document, 2);
            copy.getBuffer().setContents(document.get());
            JavaModelUtil.reconcile(copy);
            ICompilationUnit iCompilationUnit = copy;
            return iCompilationUnit;
        }
        catch (JavaModelException javaModelException) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
        }
        catch (MalformedTreeException malformedTreeException) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
        }
        catch (BadLocationException badLocationException) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
        }
        finally {
            monitor.done();
        }
        return null;
    }

    protected RefactoringStatus createWorkingCopyLayer(IProgressMonitor monitor) {
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 1);
            ICompilationUnit unit = this.getDeclaringType().getCompilationUnit();
            if (this.fLayer) {
                unit = unit.findWorkingCopy(this.fOwner);
            }
            this.resetWorkingCopies(unit);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private IMethod[] getAbstractMethods() throws JavaModelException {
        IMethod[] toDeclareAbstract = this.fAbstractMethods;
        IMethod[] abstractPulledUp = this.getAbstractMethodsToPullUp();
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(toDeclareAbstract.length + abstractPulledUp.length + this.fMembersToMove.length);
        if (this.fDestinationType.isInterface()) {
            int i = 0;
            while (i < this.fMembersToMove.length) {
                if (this.fMembersToMove[i].getElementType() == 9) {
                    result.add(this.fMembersToMove[i]);
                }
                ++i;
            }
        }
        result.addAll(Arrays.asList(toDeclareAbstract));
        result.addAll(Arrays.asList(abstractPulledUp));
        return result.toArray(new IMethod[result.size()]);
    }

    private IMethod[] getAbstractMethodsToPullUp() throws JavaModelException {
        ArrayList<IMember> result = new ArrayList<IMember>(this.fMembersToMove.length);
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[i];
            if (member instanceof IMethod && JdtFlags.isAbstract(member)) {
                result.add(member);
            }
            ++i;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public IMember[] getAdditionalRequiredMembersToPullUp(IProgressMonitor monitor) throws JavaModelException {
        ArrayList<IMember> queue;
        IMember[] members = this.getCreatedDestinationMembers();
        try {
            IMember current;
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, this.getDeclaringType().getChildren().length);
            queue = new ArrayList<IMember>(members.length);
            queue.addAll(Arrays.asList(members));
            if (queue.isEmpty()) {
                IMember[] iMemberArray = new IMember[]{};
                return iMemberArray;
            }
            int i = 0;
            do {
                current = (IMember)queue.get(i);
                this.addAllRequiredPullableMembers(queue, current, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (queue.size() != ++i) continue;
                current = null;
            } while (current != null);
            queue.removeAll(Arrays.asList(members));
        }
        finally {
            monitor.done();
        }
        return queue.toArray(new IMember[queue.size()]);
    }

    private ICompilationUnit[] getAffectedCompilationUnits(IProgressMonitor monitor) throws JavaModelException {
        IType[] allSubtypes = this.getDestinationTypeHierarchy(monitor).getAllSubtypes(this.getDestinationType());
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(allSubtypes.length);
        int i = 0;
        while (i < allSubtypes.length) {
            result.add(allSubtypes[i].getCompilationUnit());
            ++i;
        }
        result.add(this.getDestinationType().getCompilationUnit());
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    public IType[] getCandidateTypes(RefactoringStatus status, IProgressMonitor monitor) throws JavaModelException {
        IType declaring = this.getDeclaringType();
        IType[] superTypes = declaring.newSupertypeHierarchy(this.fOwner, monitor).getAllSupertypes(declaring);
        ArrayList<IType> list = new ArrayList<IType>(superTypes.length);
        int binary = 0;
        int index = 0;
        while (index < superTypes.length) {
            IType type = superTypes[index];
            if (type != null && type.exists() && !type.isReadOnly() && !type.isBinary() && !"java.lang.Object".equals(type.getFullyQualifiedName())) {
                list.add(type);
            } else if (type != null && type.isBinary()) {
                ++binary;
            }
            ++index;
        }
        if (superTypes.length == 1 && superTypes[0].getFullyQualifiedName().equals("java.lang.Object")) {
            status.addFatalError(RefactoringCoreMessages.PullUPRefactoring_not_java_lang_object);
        } else if (superTypes.length == binary) {
            status.addFatalError(RefactoringCoreMessages.PullUPRefactoring_no_all_binary);
        }
        Collections.reverse(list);
        return list.toArray(new IType[list.size()]);
    }

    protected CompilationUnitRewrite getCompilationUnitRewrite(Map rewrites, ICompilationUnit unit) {
        Assert.isNotNull((Object)rewrites);
        Assert.isNotNull((Object)unit);
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(this.fOwner, unit);
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    private IMember[] getCreatedDestinationMembers() {
        ArrayList<Object> result = new ArrayList<Object>(this.fMembersToMove.length + this.fAbstractMethods.length);
        result.addAll(Arrays.asList(this.fMembersToMove));
        result.addAll(Arrays.asList(this.fAbstractMethods));
        return result.toArray(new IMember[result.size()]);
    }

    public boolean getCreateMethodStubs() {
        return this.fCreateMethodStubs;
    }

    public ITypeHierarchy getDeclaringSuperTypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        try {
            if (this.fCachedDeclaringSuperTypeHierarchy != null) {
                ITypeHierarchy iTypeHierarchy = this.fCachedDeclaringSuperTypeHierarchy;
                return iTypeHierarchy;
            }
            ITypeHierarchy iTypeHierarchy = this.fCachedDeclaringSuperTypeHierarchy = this.getDeclaringType().newSupertypeHierarchy(this.fOwner, monitor);
            return iTypeHierarchy;
        }
        finally {
            monitor.done();
        }
    }

    public IType getDestinationType() {
        return this.fDestinationType;
    }

    public ITypeHierarchy getDestinationTypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        try {
            if (this.fCachedDestinationTypeHierarchy != null && this.fCachedDestinationTypeHierarchy.getType().equals(this.getDestinationType())) {
                ITypeHierarchy iTypeHierarchy = this.fCachedDestinationTypeHierarchy;
                return iTypeHierarchy;
            }
            ITypeHierarchy iTypeHierarchy = this.fCachedDestinationTypeHierarchy = this.getDestinationType().newTypeHierarchy(this.fOwner, monitor);
            return iTypeHierarchy;
        }
        finally {
            monitor.done();
        }
    }

    public Object[] getElements() {
        return this.fMembersToMove;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public IMember[] getMatchingElements(IProgressMonitor monitor, boolean includeAbstract) throws JavaModelException {
        try {
            HashSet result = new HashSet();
            IType destination = this.getDestinationType();
            Map matching = this.getMatchingMembers(this.getDestinationTypeHierarchy(monitor), this.getDestinationType(), includeAbstract);
            Iterator iterator = matching.keySet().iterator();
            while (iterator.hasNext()) {
                IMember key = (IMember)iterator.next();
                Assert.isTrue((!key.getDeclaringType().equals(destination) ? 1 : 0) != 0);
                result.addAll((Set)matching.get(key));
            }
            IMember[] iMemberArray = result.toArray(new IMember[result.size()]);
            return iMemberArray;
        }
        finally {
            monitor.done();
        }
    }

    private Map getMatchingMembers(ITypeHierarchy hierarchy, IType type, boolean includeAbstract) throws JavaModelException {
        HashMap result = new HashMap();
        result.putAll(this.getMatchingMembersMapping(type));
        IType[] subTypes = hierarchy.getAllSubtypes(type);
        int i = 0;
        while (i < subTypes.length) {
            Map map = this.getMatchingMembersMapping(subTypes[i]);
            PullUpRefactoringProcessor.mergeMaps(result, map);
            PullUpRefactoringProcessor.upgradeMap(result, map);
            ++i;
        }
        if (includeAbstract) {
            return result;
        }
        i = 0;
        while (i < this.fAbstractMethods.length) {
            if (result.containsKey(this.fAbstractMethods[i])) {
                result.remove(this.fAbstractMethods[i]);
            }
            ++i;
        }
        return result;
    }

    private Map getMatchingMembersMapping(IType initial) throws JavaModelException {
        HashMap result = new HashMap();
        IMember[] members = this.getCreatedDestinationMembers();
        int i = 0;
        while (i < members.length) {
            IMethod found;
            IMember member = members[i];
            if (member instanceof IMethod) {
                IMethod method = (IMethod)member;
                found = MemberCheckUtil.findMethod(method, initial.getMethods());
                if (found != null) {
                    PullUpRefactoringProcessor.addMatchingMember(result, (IMember)method, (IMember)found);
                }
            } else if (member instanceof IField) {
                IField field = (IField)member;
                found = initial.getField(field.getElementName());
                if (found.exists()) {
                    PullUpRefactoringProcessor.addMatchingMember(result, (IMember)field, (IMember)found);
                }
            } else if (member instanceof IType) {
                IType type = (IType)member;
                found = initial.getType(type.getElementName());
                if (found.exists()) {
                    PullUpRefactoringProcessor.addMatchingMember(result, (IMember)type, (IMember)found);
                }
            } else {
                Assert.isTrue((boolean)false);
            }
            ++i;
        }
        return result;
    }

    private IMember[] getMembersToDelete(IProgressMonitor monitor) throws JavaModelException {
        try {
            IMember[] typesToDelete = PullUpRefactoringProcessor.getMembers(this.fMembersToMove, 7);
            IMember[] matchingElements = this.getMatchingElements(monitor, false);
            IMember[] matchingFields = PullUpRefactoringProcessor.getMembers(matchingElements, 8);
            IMember[] iMemberArray = JavaElementUtil.merge(JavaElementUtil.merge(matchingFields, typesToDelete), (IMember[])this.fDeletedMethods);
            return iMemberArray;
        }
        finally {
            monitor.done();
        }
    }

    private int getModifiersWithUpdatedVisibility(IMember member, int modifiers, Map adjustments, IProgressMonitor monitor, boolean considerReferences, RefactoringStatus status) throws JavaModelException {
        if (this.needsVisibilityAdjustment(member, considerReferences, monitor, status)) {
            MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment adjustment = new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment(member, Modifier.ModifierKeyword.PROTECTED_KEYWORD, RefactoringStatus.createWarningStatus((String)Messages.format(MemberVisibilityAdjustor.getMessage(member), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)member), MemberVisibilityAdjustor.getLabel(Modifier.ModifierKeyword.PROTECTED_KEYWORD)})));
            adjustment.setNeedsRewriting(false);
            adjustments.put(member, adjustment);
            return JdtFlags.clearAccessModifiers(modifiers) | 4;
        }
        if (this.getDestinationType().isInterface()) {
            int flags = JdtFlags.clearAccessModifiers(modifiers) | 1;
            if (member instanceof IMethod) {
                return JdtFlags.clearFlag(8, flags);
            }
            return flags;
        }
        return modifiers;
    }

    private Set getNotDeletedMembers(IProgressMonitor monitor) throws JavaModelException {
        HashSet<IMember> matchingSet = new HashSet<IMember>();
        monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 2);
        matchingSet.addAll(Arrays.asList(this.getMatchingElements((IProgressMonitor)new SubProgressMonitor(monitor, 1), true)));
        matchingSet.removeAll(Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(monitor, 1))));
        monitor.done();
        return matchingSet;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.PullUpRefactoring_Pull_Up;
    }

    public IMember[] getPullableMembersOfDeclaringType() {
        try {
            return RefactoringAvailabilityTester.getPullUpMembers(this.getDeclaringType());
        }
        catch (JavaModelException javaModelException) {
            return new IMember[0];
        }
    }

    private Set getSkippedSuperTypes(IProgressMonitor monitor) throws JavaModelException {
        monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 1);
        try {
            if (this.fCachedSkippedSuperTypes != null && this.getDestinationTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1)).getType().equals(this.getDestinationType())) {
                Set set = this.fCachedSkippedSuperTypes;
                return set;
            }
            ITypeHierarchy hierarchy = this.getDestinationTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fCachedSkippedSuperTypes = new HashSet(2);
            IType current = hierarchy.getSuperclass(this.getDeclaringType());
            while (current != null && !current.equals(this.getDestinationType())) {
                this.fCachedSkippedSuperTypes.add(current);
                current = hierarchy.getSuperclass(current);
            }
            Set set = this.fCachedSkippedSuperTypes;
            return set;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String attribute;
        IJavaElement element2;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element2 = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element2 == null || !element2.exists() || element2.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element2, this.getProcessorName(), "org.eclipse.jdt.ui.pull.up");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fDestinationType = (IType)element2;
        String stubs = extended.getAttribute(ATTRIBUTE_STUBS);
        if (stubs == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_STUBS));
        }
        this.fCreateMethodStubs = Boolean.valueOf(stubs);
        String instance = extended.getAttribute("instanceof");
        if (instance == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "instanceof"));
        }
        this.fInstanceOf = Boolean.valueOf(instance);
        String replace = extended.getAttribute("replace");
        if (replace == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "replace"));
        }
        this.fReplace = Boolean.valueOf(replace);
        int pullCount = 0;
        int abstractCount = 0;
        int deleteCount = 0;
        String value = extended.getAttribute(ATTRIBUTE_ABSTRACT);
        if (value != null && !"".equals(value)) {
            try {
                abstractCount = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ABSTRACT));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ABSTRACT));
        }
        value = extended.getAttribute(ATTRIBUTE_DELETE);
        if (value != null && !"".equals(value)) {
            try {
                deleteCount = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELETE));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELETE));
        }
        value = extended.getAttribute(ATTRIBUTE_PULL);
        if (value != null && !"".equals(value)) {
            try {
                pullCount = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PULL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PULL));
        }
        RefactoringStatus status = new RefactoringStatus();
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        int index = 0;
        while (index < pullCount) {
            attribute = "element" + (index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.pull.up"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fMembersToMove = elements.toArray(new IMember[elements.size()]);
        elements = new ArrayList();
        index = 0;
        while (index < deleteCount) {
            attribute = "element" + (pullCount + index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.pull.up"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fDeletedMethods = elements.toArray(new IMethod[elements.size()]);
        elements = new ArrayList();
        index = 0;
        while (index < abstractCount) {
            attribute = "element" + (pullCount + abstractCount + index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.pull.up"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fAbstractMethods = elements.toArray(new IMethod[elements.size()]);
        IJavaProject project = null;
        if (this.fMembersToMove.length > 0) {
            project = this.fMembersToMove[0].getJavaProject();
        }
        this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(project);
        if (!status.isOK()) {
            return status;
        }
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isPullUpAvailable(this.fMembersToMove);
    }

    private boolean isAvailableInDestination(IMethod method, IProgressMonitor monitor) throws JavaModelException {
        try {
            IType destination = this.getDestinationType();
            IMethod first = JavaModelUtil.findMethod(method.getElementName(), method.getParameterTypes(), false, destination);
            if (first != null && MethodChecks.isVirtual(first)) {
                return true;
            }
            ITypeHierarchy hierarchy = this.getDestinationTypeHierarchy(monitor);
            IMethod found = JavaModelUtil.findMethodInHierarchy(hierarchy, destination, method.getElementName(), method.getParameterTypes(), false);
            boolean bl = found != null && MethodChecks.isVirtual(found);
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isRequiredPullableMember(List queue, IMember member) throws JavaModelException {
        IType declaring = member.getDeclaringType();
        if (declaring == null) {
            return false;
        }
        return declaring.equals(this.getDeclaringType()) && !queue.contains(member) && RefactoringAvailabilityTester.isPullUpAvailable(member);
    }

    protected void registerChanges(TextEditBasedChangeManager manager) throws CoreException {
        ICompilationUnit unit = null;
        CompilationUnitRewrite rewrite = null;
        Iterator iterator = this.fCompilationUnitRewrites.keySet().iterator();
        while (iterator.hasNext()) {
            CompilationUnitChange change;
            unit = (ICompilationUnit)iterator.next();
            rewrite = (CompilationUnitRewrite)this.fCompilationUnitRewrites.get(unit);
            if (rewrite == null || (change = rewrite.createChange()) == null) continue;
            manager.manage(unit, (TextEditBasedChange)change);
        }
    }

    public void resetEnvironment() {
        ICompilationUnit unit = this.getDeclaringType().getCompilationUnit();
        if (this.fLayer) {
            unit = unit.findWorkingCopy(this.fOwner);
        }
        this.resetWorkingCopies(unit);
    }

    protected void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, ICompilationUnit unit, CompilationUnit node, Set replacements, IProgressMonitor monitor) throws CoreException {
        try {
            CompilationUnitChange change;
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            CompilationUnitRewrite currentRewrite = null;
            CompilationUnitRewrite existingRewrite = (CompilationUnitRewrite)this.fCompilationUnitRewrites.get(unit.getPrimary());
            boolean isTouched = existingRewrite != null;
            currentRewrite = isTouched ? existingRewrite : new CompilationUnitRewrite(unit, node);
            Collection collection = (Collection)this.fTypeOccurrences.get(unit);
            if (collection != null && !collection.isEmpty()) {
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100);
                try {
                    subMonitor.beginTask("", collection.size() * 10);
                    subMonitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                    TType estimate = null;
                    ISourceConstraintVariable variable = null;
                    ITypeConstraintVariable constraint = null;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        variable = (ISourceConstraintVariable)iterator.next();
                        if (!(variable instanceof ITypeConstraintVariable) || (estimate = (TType)(constraint = (ITypeConstraintVariable)variable).getData("te")) == null) continue;
                        CompilationUnitRange range = constraint.getRange();
                        if (isTouched) {
                            this.rewriteTypeOccurrence(range, estimate, requestor, currentRewrite, node, replacements, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
                        } else {
                            ASTNode result = NodeFinder.perform((ASTNode)node, range.getSourceRange());
                            if (result != null) {
                                this.rewriteTypeOccurrence(estimate, currentRewrite, result, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
                            }
                        }
                        subMonitor.worked(10);
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
            if (!isTouched && (change = currentRewrite.createChange()) != null) {
                manager.manage(unit, (TextEditBasedChange)change);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void rewriteTypeOccurrences(final TextEditBasedChangeManager manager, final CompilationUnitRewrite sourceRewrite, ICompilationUnit copy, final Set replacements, final RefactoringStatus status, final IProgressMonitor monitor) {
        try {
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.PullUpRefactoring_checking);
            final IType declaring = this.getDeclaringType();
            IJavaProject project = declaring.getJavaProject();
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setWorkingCopyOwner(this.fOwner);
            parser.setResolveBindings(true);
            parser.setProject(project);
            parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
            parser.createASTs(new ICompilationUnit[]{copy}, new String[0], new ASTRequestor(){

                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                    try {
                        ITypeBinding subBinding;
                        IType subType = (IType)JavaModelUtil.findInCompilationUnit(unit, (IJavaElement)declaring);
                        AbstractTypeDeclaration subDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(subType, node);
                        if (subDeclaration != null && (subBinding = subDeclaration.resolveBinding()) != null) {
                            String name = null;
                            ITypeBinding superBinding = null;
                            ITypeBinding[] superBindings = Bindings.getAllSuperTypes(subBinding);
                            int index = 0;
                            while (index < superBindings.length) {
                                name = superBindings[index].getName();
                                if (name.startsWith(PullUpRefactoringProcessor.this.fDestinationType.getElementName())) {
                                    superBinding = superBindings[index];
                                }
                                ++index;
                            }
                            if (superBinding != null) {
                                PullUpRefactoringProcessor.this.solveSuperTypeConstraints(unit, node, subType, subBinding, superBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 80), status);
                                if (!status.hasFatalError()) {
                                    PullUpRefactoringProcessor.this.rewriteTypeOccurrences(manager, this, sourceRewrite, unit, node, replacements, status, (IProgressMonitor)new SubProgressMonitor(monitor, 120));
                                }
                            }
                        }
                    }
                    catch (JavaModelException exception) {
                        JavaPlugin.log(exception);
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                    }
                }

                public final void acceptBinding(String key, IBinding binding) {
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            monitor.done();
        }
    }

    public void setAbstractMethods(IMethod[] methods) {
        Assert.isNotNull((Object)methods);
        this.fAbstractMethods = methods;
    }

    public void setCreateMethodStubs(boolean create) {
        this.fCreateMethodStubs = create;
    }

    public void setDeletedMethods(IMethod[] methods) {
        Assert.isNotNull((Object)methods);
        this.fDeletedMethods = methods;
    }

    public void setDestinationType(IType type) {
        Assert.isNotNull((Object)type);
        if (!type.equals(this.fDestinationType)) {
            this.fCachedDestinationTypeHierarchy = null;
        }
        this.fDestinationType = type;
    }

    public void setMembersToMove(IMember[] members) {
        Assert.isNotNull((Object)members);
        this.fMembersToMove = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])members);
    }

    private static class PullUpAstNodeMapper
    extends HierarchyProcessor.TypeVariableMapper {
        private boolean fAnonymousClassDeclaration = false;
        private final CompilationUnitRewrite fSourceRewriter;
        private final IType fSuperReferenceType;
        private final CompilationUnitRewrite fTargetRewriter;
        private boolean fTypeDeclarationStatement = false;
        private final IMethodBinding fEnclosingMethod;

        public PullUpAstNodeMapper(CompilationUnitRewrite sourceRewriter, CompilationUnitRewrite targetRewriter, ASTRewrite rewrite, IType type, TypeVariableMaplet[] mapping, IMethodBinding enclosing) {
            super(rewrite, mapping);
            Assert.isNotNull((Object)rewrite);
            Assert.isNotNull((Object)type);
            this.fSourceRewriter = sourceRewriter;
            this.fTargetRewriter = targetRewriter;
            this.fSuperReferenceType = type;
            this.fEnclosingMethod = enclosing;
        }

        public final void endVisit(AnonymousClassDeclaration node) {
            this.fAnonymousClassDeclaration = false;
            super.endVisit(node);
        }

        public final void endVisit(TypeDeclarationStatement node) {
            this.fTypeDeclarationStatement = false;
            super.endVisit(node);
        }

        public final boolean visit(AnonymousClassDeclaration node) {
            this.fAnonymousClassDeclaration = true;
            return super.visit(node);
        }

        public final boolean visit(SuperFieldAccess node) {
            if (!this.fAnonymousClassDeclaration && !this.fTypeDeclarationStatement) {
                AST ast = node.getAST();
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(node.getName().getIdentifier()));
                this.fRewrite.replace((ASTNode)node, (ASTNode)access, null);
                if (!this.fSourceRewriter.getCu().equals(this.fTargetRewriter.getCu())) {
                    this.fSourceRewriter.getImportRemover().registerRemovedNode((ASTNode)node);
                }
                return true;
            }
            return false;
        }

        public final boolean visit(SuperMethodInvocation node) {
            if (!this.fAnonymousClassDeclaration && !this.fTypeDeclarationStatement) {
                IBinding superBinding = node.getName().resolveBinding();
                if (superBinding instanceof IMethodBinding) {
                    IType type;
                    IMethodBinding extended = (IMethodBinding)superBinding;
                    if (this.fEnclosingMethod != null && this.fEnclosingMethod.overrides(extended)) {
                        return true;
                    }
                    ITypeBinding declaringBinding = extended.getDeclaringClass();
                    if (declaringBinding != null && !this.fSuperReferenceType.equals(type = (IType)declaringBinding.getJavaElement())) {
                        return true;
                    }
                }
                AST ast = node.getAST();
                ThisExpression expression = ast.newThisExpression();
                MethodInvocation invocation = ast.newMethodInvocation();
                SimpleName simple = ast.newSimpleName(node.getName().getIdentifier());
                invocation.setName(simple);
                invocation.setExpression((Expression)expression);
                List arguments = (List)node.getStructuralProperty((StructuralPropertyDescriptor)SuperMethodInvocation.ARGUMENTS_PROPERTY);
                if (arguments != null && arguments.size() > 0) {
                    ListRewrite rewriter = this.fRewrite.getListRewrite((ASTNode)invocation, MethodInvocation.ARGUMENTS_PROPERTY);
                    ListRewrite superRewriter = this.fRewrite.getListRewrite((ASTNode)node, SuperMethodInvocation.ARGUMENTS_PROPERTY);
                    ASTNode copyTarget = superRewriter.createCopyTarget((ASTNode)arguments.get(0), (ASTNode)arguments.get(arguments.size() - 1));
                    rewriter.insertLast(copyTarget, null);
                }
                this.fRewrite.replace((ASTNode)node, (ASTNode)invocation, null);
                if (!this.fSourceRewriter.getCu().equals(this.fTargetRewriter.getCu())) {
                    this.fSourceRewriter.getImportRemover().registerRemovedNode((ASTNode)node);
                }
                return true;
            }
            return false;
        }

        public final boolean visit(TypeDeclarationStatement node) {
            this.fTypeDeclarationStatement = true;
            return super.visit(node);
        }
    }
}

