/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.LoggedCreateTargetChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.LoggedCreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MonitoringCreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.NullReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class JavaMoveProcessor
extends MoveProcessor
implements IQualifiedNameUpdating,
IReorgDestinationValidator {
    private ICreateTargetQueries fCreateTargetQueries;
    private IReorgPolicy.IMovePolicy fMovePolicy;
    private IReorgQueries fReorgQueries;
    private boolean fWasCanceled;

    public JavaMoveProcessor(IReorgPolicy.IMovePolicy policy) {
        this.fMovePolicy = policy;
    }

    public JavaMoveProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public boolean canChildrenBeDestinations(IReorgDestination destination) {
        return this.fMovePolicy.canChildrenBeDestinations(destination);
    }

    public boolean canElementBeDestination(IReorgDestination destination) {
        return this.fMovePolicy.canElementBeDestination(destination);
    }

    public boolean canEnableQualifiedNameUpdating() {
        return this.fMovePolicy.canEnableQualifiedNameUpdating();
    }

    public boolean canUpdateQualifiedNames() {
        return this.fMovePolicy.canUpdateQualifiedNames();
    }

    public boolean canUpdateJavaReferences() {
        return this.fMovePolicy.canUpdateJavaReferences();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            Assert.isNotNull((Object)this.fReorgQueries);
            this.fWasCanceled = false;
            return this.fMovePolicy.checkFinalConditions(pm, context, this.fReorgQueries);
        }
        catch (OperationCanceledException e) {
            this.fWasCanceled = true;
            throw e;
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(this.fMovePolicy.getResources()))));
            IResource[] javaResources = ReorgUtils.getResources(this.fMovePolicy.getJavaElements());
            result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        Assert.isTrue((this.fMovePolicy.getJavaElementDestination() == null || this.fMovePolicy.getResourceDestination() == null ? 1 : 0) != 0);
        Assert.isTrue((this.fMovePolicy.getJavaElementDestination() != null || this.fMovePolicy.getResourceDestination() != null ? 1 : 0) != 0);
        try {
            Change change;
            MonitoringCreateTargetQueries queries;
            ICreateTargetQueries delegate;
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.JavaMoveProcessor_change_name){

                public ChangeDescriptor getDescriptor() {
                    return JavaMoveProcessor.this.fMovePolicy.getDescriptor();
                }

                public Change perform(IProgressMonitor pm2) throws CoreException {
                    Change change = super.perform(pm2);
                    Change[] changes = this.getChildren();
                    int index = 0;
                    while (index < changes.length) {
                        if (!(changes[index] instanceof TextEditBasedChange)) {
                            return null;
                        }
                        ++index;
                    }
                    return change;
                }
            };
            CreateTargetExecutionLog log = null;
            if (this.fCreateTargetQueries instanceof MonitoringCreateTargetQueries && (delegate = (queries = (MonitoringCreateTargetQueries)this.fCreateTargetQueries).getDelegate()) instanceof LoggedCreateTargetQueries) {
                log = queries.getCreateTargetExecutionLog();
            }
            if (log != null) {
                Object[] selected = log.getSelectedElements();
                int index = 0;
                while (index < selected.length) {
                    result.add((Change)new LoggedCreateTargetChange(selected[index], this.fCreateTargetQueries));
                    ++index;
                }
            }
            if ((change = this.fMovePolicy.createChange(pm)) instanceof CompositeChange) {
                CompositeChange subComposite = (CompositeChange)change;
                result.merge(subComposite);
            } else {
                result.add(change);
            }
            DynamicValidationStateChange dynamicValidationStateChange = result;
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = JavaProcessors.computeAffectedNaturs(this.fMovePolicy.getJavaElements());
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fMovePolicy.getResources());
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fMovePolicy.getResources(), this.fMovePolicy.getJavaElements()).getCommonParent();
    }

    public ICreateTargetQuery getCreateTargetQuery() {
        return this.fMovePolicy.getCreateTargetQuery(this.fCreateTargetQueries);
    }

    protected Object getDestination() {
        IJavaElement je = this.fMovePolicy.getJavaElementDestination();
        if (je != null) {
            return je;
        }
        return this.fMovePolicy.getResourceDestination();
    }

    public Object[] getElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(this.fMovePolicy.getJavaElements()));
        result.addAll(Arrays.asList(this.fMovePolicy.getResources()));
        return result.toArray();
    }

    public String getFilePatterns() {
        return this.fMovePolicy.getFilePatterns();
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.MoveProcessor";
    }

    public IJavaElement[] getJavaElements() {
        return this.fMovePolicy.getJavaElements();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.MoveRefactoring_0;
    }

    public IResource[] getResources() {
        return this.fMovePolicy.getResources();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fMovePolicy.getUpdateQualifiedNames();
    }

    public boolean getUpdateReferences() {
        return this.fMovePolicy.getUpdateReferences();
    }

    public boolean hasAllInputSet() {
        return this.fMovePolicy.hasAllInputSet();
    }

    public boolean hasDestinationSet() {
        return this.fMovePolicy.getJavaElementDestination() != null || this.fMovePolicy.getResourceDestination() != null;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        this.setReorgQueries(new NullReorgQueries());
        RefactoringStatus status = new RefactoringStatus();
        this.fMovePolicy = ReorgPolicyFactory.createMovePolicy(status, arguments);
        if (this.fMovePolicy != null && !status.hasFatalError()) {
            CreateTargetExecutionLog log = ReorgPolicyFactory.loadCreateTargetExecutionLog(arguments);
            if (log != null && !status.hasFatalError()) {
                this.fMovePolicy.setDestinationCheck(false);
                this.fCreateTargetQueries = new MonitoringCreateTargetQueries(new LoggedCreateTargetQueries(log), log);
            }
            status.merge(this.fMovePolicy.initialize(arguments));
        }
        return status;
    }

    public boolean isApplicable() throws CoreException {
        return this.fMovePolicy.canEnable();
    }

    public boolean isTextualMove() {
        return this.fMovePolicy.isTextualMove();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fMovePolicy.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        return this.fMovePolicy.postCreateChange(participantChanges, pm);
    }

    public void setCreateTargetQueries(ICreateTargetQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fCreateTargetQueries = new MonitoringCreateTargetQueries(queries, this.fMovePolicy.getCreateTargetExecutionLog());
    }

    public RefactoringStatus setDestination(IReorgDestination destination) throws JavaModelException {
        this.fMovePolicy.setDestination(destination);
        return this.fMovePolicy.verifyDestination(destination);
    }

    public void setFilePatterns(String patterns) {
        this.fMovePolicy.setFilePatterns(patterns);
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fReorgQueries = queries;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fMovePolicy.setUpdateQualifiedNames(update);
    }

    public void setUpdateReferences(boolean update) {
        this.fMovePolicy.setUpdateReferences(update);
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public int getSaveMode() {
        return this.fMovePolicy.getSaveMode();
    }
}

