/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

class MarkerEntry
extends MarkerSupportItem
implements IAdaptable {
    private static final Object LOCATION_STRING = "LOCATION_STRING";
    private MarkerCategory category;
    IMarker marker;
    Map cache = null;
    static /* synthetic */ Class class$0;

    public MarkerEntry(IMarker marker) {
        this.marker = marker;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.marker;
        }
        return null;
    }

    public boolean getAttributeValue(String attribute, boolean defaultValue) {
        Object value = this.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    public int getAttributeValue(String attribute, int defaultValue) {
        Object value = this.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return (Integer)value;
    }

    private Object getAttributeValue(String attribute) {
        Object value = this.getCache().get(attribute);
        if (value == null) {
            try {
                value = this.marker.getAttribute(attribute);
            }
            catch (CoreException coreException) {
                value = null;
            }
            if (value != null) {
                this.getCache().put(attribute, value);
            }
        }
        if (value instanceof CollationKey) {
            return ((CollationKey)value).getSourceString();
        }
        return value;
    }

    public String getAttributeValue(String attribute, String defaultValue) {
        Object value = this.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    MarkerCategory getCategory() {
        return this.category;
    }

    MarkerSupportItem[] getChildren() {
        return MarkerSupportInternalUtilities.EMPTY_MARKER_ITEM_ARRAY;
    }

    CollationKey getCollationKey(String attribute, String defaultValue) {
        String attributeValue;
        Object value = this.getCache().get(attribute);
        if (value != null) {
            if (value instanceof CollationKey) {
                return (CollationKey)value;
            }
            attributeValue = value.toString();
        } else {
            attributeValue = this.getAttributeValue(attribute, defaultValue);
        }
        if (attributeValue.length() == 0) {
            return MarkerSupportInternalUtilities.EMPTY_COLLATION_KEY;
        }
        CollationKey key = Collator.getInstance().getCollationKey(attributeValue);
        this.getCache().put(attribute, key);
        return key;
    }

    long getCreationTime() {
        try {
            return this.marker.getCreationTime();
        }
        catch (CoreException e) {
            Policy.handle(e);
            return -1L;
        }
    }

    String getDescription() {
        return this.getAttributeValue("message", "");
    }

    long getID() {
        return this.marker.getId();
    }

    public String getLocation() {
        if (this.getCache().containsKey(LOCATION_STRING)) {
            Object value = this.getCache().get(LOCATION_STRING);
            if (value instanceof CollationKey) {
                return ((CollationKey)value).getSourceString();
            }
            return (String)value;
        }
        String locationString = this.getAttributeValue("location", "");
        if (locationString.length() > 0) {
            this.getCache().put(LOCATION_STRING, locationString);
            return locationString;
        }
        int lineNumber = this.getAttributeValue("lineNumber", -1);
        String lineNumberString = lineNumber < 0 ? MarkerMessages.Unknown : NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(lineNumber));
        this.getCache().put(LOCATION_STRING, lineNumberString);
        return lineNumberString;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    String getMarkerTypeName() {
        try {
            return MarkerTypesModel.getInstance().getType(this.marker.getType()).getLabel();
        }
        catch (CoreException e) {
            Policy.handle(e);
            return NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)this.marker.toString());
        }
    }

    MarkerSupportItem getParent() {
        return this.category;
    }

    public String getPath() {
        String folder = this.getAttributeValue("org.eclipse.ui.views.markers.path", null);
        if (folder != null) {
            return folder;
        }
        if (!this.marker.exists()) {
            return super.getPath();
        }
        IPath path = this.marker.getResource().getFullPath();
        int n = path.segmentCount() - 1;
        if (n <= 0) {
            return super.getPath();
        }
        folder = path.removeLastSegments(1).removeTrailingSeparator().toString();
        this.getCache().put("org.eclipse.ui.views.markers.path", folder);
        return folder;
    }

    boolean isConcrete() {
        return true;
    }

    void setCategory(MarkerCategory markerCategory) {
        this.category = markerCategory;
    }

    void setMarker(IMarker marker) {
        this.marker = marker;
        this.clearCache();
    }

    private Map getCache() {
        if (this.cache == null) {
            this.cache = new HashMap(2);
        }
        return this.cache;
    }

    void clearCache() {
        this.cache = null;
    }
}

