/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryIO;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactComparatorFactory;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactComparator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.repository.ICompositeRepository;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.AbstractArtifactRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class CompositeArtifactRepository
extends AbstractArtifactRepository
implements IArtifactRepository,
ICompositeRepository {
    public static final String REPOSITORY_TYPE;
    private static final Integer REPOSITORY_VERSION;
    public static final String XML_EXTENSION = ".xml";
    public static final String JAR_EXTENSION = ".jar";
    public static final String CONTENT_FILENAME = "compositeArtifacts";
    public static final String PI_REPOSITORY_TYPE = "compositeArtifactRepository";
    private List childrenURIs = new ArrayList();
    private List loadedRepos = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REPOSITORY_TYPE = clazz.getName();
        REPOSITORY_VERSION = new Integer(1);
    }

    public static CompositeArtifactRepository createMemoryComposite() {
        IArtifactRepositoryManager manager = CompositeArtifactRepository.getManager();
        if (manager == null) {
            return null;
        }
        try {
            long time = System.currentTimeMillis();
            URI repositoryURI = new URI("memory:" + String.valueOf(time));
            while (manager.contains(repositoryURI)) {
                repositoryURI = new URI("memory:" + String.valueOf(++time));
            }
            CompositeArtifactRepository result = (CompositeArtifactRepository)manager.createRepository(repositoryURI, repositoryURI.toString(), "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null);
            manager.removeRepository(repositoryURI);
            return result;
        }
        catch (ProvisionException e) {
            LogHelper.log((ProvisionException)e);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return null;
    }

    private static IArtifactRepositoryManager getManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    public CompositeArtifactRepository(CompositeRepositoryState state) {
        super(state.getName(), state.getType(), state.getVersion(), state.getLocation(), state.getDescription(), state.getProvider(), state.getProperties());
        int i = 0;
        while (i < state.getChildren().length) {
            this.addChild(state.getChildren()[i], false);
            ++i;
        }
    }

    public CompositeArtifactRepository(URI location, String repositoryName, Map properties) {
        super(repositoryName, REPOSITORY_TYPE, REPOSITORY_VERSION.toString(), location, null, null, properties);
        this.save();
    }

    public CompositeRepositoryState toState() {
        CompositeRepositoryState result = new CompositeRepositoryState();
        result.setName(this.getName());
        result.setType(this.getType());
        result.setVersion(this.getVersion());
        result.setLocation(this.getLocation());
        result.setDescription(this.getDescription());
        result.setProvider(this.getProvider());
        result.setProperties(this.getProperties());
        result.setChildren(this.childrenURIs.toArray(new URI[this.childrenURIs.size()]));
        return result;
    }

    private static boolean add(List list, Object obj) {
        return list.contains(obj) ? false : list.add(obj);
    }

    public static URI getActualLocation(URI base, boolean compress) {
        return CompositeArtifactRepository.getActualLocation(base, compress ? JAR_EXTENSION : XML_EXTENSION);
    }

    private static URI getActualLocation(URI base, String extension) {
        String name = CONTENT_FILENAME + extension;
        String spec = base.toString();
        if (spec.endsWith(name)) {
            return base;
        }
        spec = spec.endsWith("/") ? String.valueOf(spec) + name : String.valueOf(spec) + "/" + name;
        try {
            return new URI(spec);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private boolean isLocal() {
        return "file".equalsIgnoreCase(this.location.getScheme());
    }

    public boolean isModifiable() {
        return this.isLocal();
    }

    public void addChild(URI childURI) {
        this.addChild(childURI, true);
    }

    private void addChild(URI childURI, boolean save) {
        URI absolute = URIUtil.makeAbsolute((URI)childURI, (URI)this.location);
        if (this.childrenURIs.contains(childURI) || this.childrenURIs.contains(absolute)) {
            return;
        }
        this.childrenURIs.add(childURI);
        if (save) {
            this.save();
        }
        try {
            IArtifactRepository repo = this.load(childURI);
            this.loadedRepos.add(new ChildInfo(repo));
        }
        catch (ProvisionException e) {
            LogHelper.log((ProvisionException)e);
        }
    }

    public boolean addChild(URI childURI, String comparatorID) {
        try {
            IArtifactRepository repo = this.load(childURI);
            if (this.isSane(repo, comparatorID)) {
                this.addChild(childURI);
                return true;
            }
        }
        catch (ProvisionException e) {
            LogHelper.log((ProvisionException)e);
        }
        return false;
    }

    public void removeChild(URI childURI) {
        URI other;
        boolean removed = this.childrenURIs.remove(childURI);
        URI uRI = other = childURI.isAbsolute() ? URIUtil.makeRelative((URI)childURI, (URI)this.location) : URIUtil.makeAbsolute((URI)childURI, (URI)this.location);
        if (!removed) {
            this.childrenURIs.remove(other);
        }
        if (removed) {
            ChildInfo found = null;
            Iterator iter = this.loadedRepos.iterator();
            while (found == null && iter.hasNext()) {
                ChildInfo current = (ChildInfo)iter.next();
                URI repoLocation = current.repo.getLocation();
                if (URIUtil.sameURI((URI)childURI, (URI)repoLocation)) {
                    found = current;
                    continue;
                }
                if (!URIUtil.sameURI((URI)other, (URI)repoLocation)) continue;
                found = current;
            }
            if (found != null) {
                this.loadedRepos.remove(found);
            }
            this.save();
        }
    }

    public void removeAllChildren() {
        this.childrenURIs.clear();
        this.loadedRepos.clear();
        this.save();
    }

    public List getChildren() {
        ArrayList<URI> result = new ArrayList<URI>();
        Iterator iter = this.childrenURIs.iterator();
        while (iter.hasNext()) {
            result.add(URIUtil.makeAbsolute((URI)((URI)iter.next()), (URI)this.location));
        }
        return result;
    }

    public synchronized void addDescriptor(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException(Messages.exception_unsupportedAddToComposite);
    }

    public void addDescriptors(IArtifactDescriptor[] descriptors) {
        throw new UnsupportedOperationException(Messages.exception_unsupportedAddToComposite);
    }

    public void removeDescriptor(IArtifactKey key) {
        throw new UnsupportedOperationException(Messages.exception_unsupportedRemoveFromComposite);
    }

    public void removeDescriptor(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException(Messages.exception_unsupportedRemoveFromComposite);
    }

    public synchronized void removeAll() {
        throw new UnsupportedOperationException(Messages.exception_unsupportedRemoveFromComposite);
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException(Messages.exception_unsupportedGetOutputStream);
    }

    public boolean contains(IArtifactKey key) {
        Iterator repositoryIterator = this.loadedRepos.iterator();
        while (repositoryIterator.hasNext()) {
            ChildInfo current = (ChildInfo)repositoryIterator.next();
            if (!current.isGood() || !current.repo.contains(key)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        Iterator repositoryIterator = this.loadedRepos.iterator();
        while (repositoryIterator.hasNext()) {
            ChildInfo current = (ChildInfo)repositoryIterator.next();
            if (!current.isGood() || !current.repo.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        ArrayList result = new ArrayList();
        Iterator repositoryIterator = this.loadedRepos.iterator();
        while (repositoryIterator.hasNext()) {
            ChildInfo current = (ChildInfo)repositoryIterator.next();
            if (!current.isGood()) continue;
            IArtifactDescriptor[] tempResult = current.repo.getArtifactDescriptors(key);
            int i = 0;
            while (i < tempResult.length) {
                CompositeArtifactRepository.add(result, tempResult[i]);
                ++i;
            }
        }
        return result.toArray(new IArtifactDescriptor[result.size()]);
    }

    public IArtifactKey[] getArtifactKeys() {
        ArrayList result = new ArrayList();
        Iterator repositoryIterator = this.loadedRepos.iterator();
        while (repositoryIterator.hasNext()) {
            ChildInfo current = (ChildInfo)repositoryIterator.next();
            if (!current.isGood()) continue;
            IArtifactKey[] tempResult = current.repo.getArtifactKeys();
            int i = 0;
            while (i < tempResult.length) {
                CompositeArtifactRepository.add(result, tempResult[i]);
                ++i;
            }
        }
        return result.toArray(new IArtifactKey[result.size()]);
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)requests.length);
        MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.p2.artifact.repository", 0, Messages.message_childrenRepos, null);
        Iterator repositoryIterator = this.loadedRepos.iterator();
        while (repositoryIterator.hasNext() && requests.length > 0) {
            IArtifactRepository current = ((ChildInfo)repositoryIterator.next()).repo;
            IArtifactRequest[] applicable = this.getRequestsForRepository(current, requests);
            IStatus dlStatus = current.getArtifacts(applicable, (IProgressMonitor)subMonitor.newChild(requests.length));
            multiStatus.add(dlStatus);
            if (dlStatus.getSeverity() == 8) {
                return multiStatus;
            }
            requests = this.filterUnfetched(requests);
            subMonitor.setWorkRemaining(requests.length);
            if (!monitor.isCanceled()) continue;
            return Status.CANCEL_STATUS;
        }
        return multiStatus;
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.getRawOrNormalArtifact(descriptor, destination, monitor, false);
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.getRawOrNormalArtifact(descriptor, destination, monitor, true);
    }

    private IStatus getRawOrNormalArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor, boolean raw) {
        Iterator childIterator = this.loadedRepos.iterator();
        while (childIterator.hasNext()) {
            ChildInfo current = (ChildInfo)childIterator.next();
            if (current.isGood() && current.repo.contains(descriptor)) {
                IStatus status;
                IStatus iStatus = status = raw ? current.repo.getRawArtifact(descriptor, destination, monitor) : current.repo.getArtifact(descriptor, destination, monitor);
                if (!status.isOK()) {
                    if (status.getCode() == 13 || status.getCode() == 8) {
                        return status;
                    }
                    current.setBad();
                    if (childIterator.hasNext()) {
                        return new MultiStatus("org.eclipse.equinox.p2.artifact.repository", 13, new IStatus[]{status}, NLS.bind((String)Messages.retryRequest, (Object)current.repo.getLocation(), (Object)descriptor.getArtifactKey()), null);
                    }
                    return status;
                }
                return Status.OK_STATUS;
            }
            if (!monitor.isCanceled()) continue;
            return Status.CANCEL_STATUS;
        }
        return new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.artifact_not_found, (Object)descriptor));
    }

    private IArtifactRequest[] filterUnfetched(IArtifactRequest[] requests) {
        ArrayList<IArtifactRequest> filteredRequests = new ArrayList<IArtifactRequest>();
        int i = 0;
        while (i < requests.length) {
            if (requests[i].getResult() == null || !requests[i].getResult().isOK()) {
                filteredRequests.add(requests[i]);
            }
            ++i;
        }
        IArtifactRequest[] filteredArtifactRequests = new IArtifactRequest[filteredRequests.size()];
        filteredRequests.toArray(filteredArtifactRequests);
        return filteredArtifactRequests;
    }

    private IArtifactRequest[] getRequestsForRepository(IArtifactRepository repository, IArtifactRequest[] requests) {
        ArrayList<IArtifactRequest> applicable = new ArrayList<IArtifactRequest>();
        int i = 0;
        while (i < requests.length) {
            if (repository.contains(requests[i].getArtifactKey())) {
                applicable.add(requests[i]);
            }
            ++i;
        }
        return applicable.toArray(new IArtifactRequest[applicable.size()]);
    }

    private void save() {
        if (!this.isModifiable()) {
            return;
        }
        boolean compress = "true".equalsIgnoreCase((String)this.properties.get("p2.compressed"));
        OutputStream os = null;
        try {
            URI actualLocation = CompositeArtifactRepository.getActualLocation(this.location, false);
            File artifactsFile = URIUtil.toFile((URI)actualLocation);
            File jarFile = URIUtil.toFile((URI)CompositeArtifactRepository.getActualLocation(this.location, true));
            if (!compress) {
                if (jarFile.exists()) {
                    jarFile.delete();
                }
                if (!artifactsFile.exists()) {
                    artifactsFile.getParentFile().mkdirs();
                }
                os = new FileOutputStream(artifactsFile);
            } else {
                if (artifactsFile.exists()) {
                    artifactsFile.delete();
                }
                if (!jarFile.exists()) {
                    if (!jarFile.getParentFile().exists()) {
                        jarFile.getParentFile().mkdirs();
                    }
                    jarFile.createNewFile();
                }
                JarOutputStream jOs = new JarOutputStream(new FileOutputStream(jarFile));
                jOs.putNextEntry(new JarEntry(new Path(artifactsFile.getAbsolutePath()).lastSegment()));
                os = jOs;
            }
            super.setProperty("p2.timestamp", Long.toString(System.currentTimeMillis()));
            new CompositeRepositoryIO().write(this.toState(), os, PI_REPOSITORY_TYPE);
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1003, NLS.bind((String)Messages.io_failedWrite, (Object)this.location), (Throwable)e));
        }
    }

    private IArtifactRepository load(URI repoURI) throws ProvisionException {
        repoURI = URIUtil.makeAbsolute((URI)repoURI, (URI)this.location);
        boolean loaded = CompositeArtifactRepository.getManager().contains(repoURI);
        IArtifactRepository repo = CompositeArtifactRepository.getManager().loadRepository(repoURI, null);
        if (!loaded) {
            CompositeArtifactRepository.getManager().setEnabled(repoURI, false);
            CompositeArtifactRepository.getManager().setRepositoryProperty(repoURI, "p2.system", String.valueOf(true));
        }
        return repo;
    }

    private boolean isSane(IArtifactRepository toCheckRepo, String comparatorID) {
        IArtifactComparator comparator = ArtifactComparatorFactory.getArtifactComparator(comparatorID);
        Iterator repositoryIterator = this.loadedRepos.iterator();
        while (repositoryIterator.hasNext()) {
            IArtifactRepository current = ((ChildInfo)repositoryIterator.next()).repo;
            if (current.equals(toCheckRepo) || this.isSane(toCheckRepo, current, comparator)) continue;
            return false;
        }
        return true;
    }

    private boolean isSane(IArtifactRepository one, IArtifactRepository two, IArtifactComparator comparator) {
        IArtifactKey[] toCheckKeys = one.getArtifactKeys();
        int i = 0;
        while (i < toCheckKeys.length) {
            IArtifactKey key = toCheckKeys[i];
            if (two.contains(key)) {
                IArtifactDescriptor[] toCheckDescriptors = one.getArtifactDescriptors(key);
                IArtifactDescriptor[] currentDescriptors = two.getArtifactDescriptors(key);
                int j = 0;
                while (j < toCheckDescriptors.length) {
                    if (two.contains(toCheckDescriptors[j])) {
                        int k = 0;
                        while (k < currentDescriptors.length) {
                            if (currentDescriptors[k].equals(toCheckDescriptors[j])) {
                                IStatus compareResult = comparator.compare(two, currentDescriptors[k], two, toCheckDescriptors[j]);
                                if (compareResult.isOK()) break;
                                LogHelper.log((IStatus)compareResult);
                                return false;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean validate(String comparatorID) {
        IArtifactComparator comparator = ArtifactComparatorFactory.getArtifactComparator(comparatorID);
        ChildInfo[] repos = this.loadedRepos.toArray(new ChildInfo[this.loadedRepos.size()]);
        int outer = 0;
        while (outer < repos.length) {
            int inner = outer + 1;
            while (inner < repos.length) {
                if (!this.isSane(repos[outer].repo, repos[inner].repo, comparator)) {
                    return false;
                }
                ++inner;
            }
            ++outer;
        }
        return true;
    }

    private static class ChildInfo {
        IArtifactRepository repo;
        boolean good = true;

        ChildInfo(IArtifactRepository IArtifactRepository2) {
            this.repo = IArtifactRepository2;
        }

        void setBad() {
            this.good = false;
        }

        boolean isGood() {
            return this.good;
        }
    }
}

