/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EGenericTypeItemProvider;
import org.eclipse.emf.ecore.provider.EStructuralFeatureItemProvider;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.InitializeCopyCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EReferenceItemProvider
extends EStructuralFeatureItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public EReferenceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addContainmentPropertyDescriptor(object);
            this.addContainerPropertyDescriptor(object);
            this.addResolveProxiesPropertyDescriptor(object);
            this.addEOppositePropertyDescriptor(object);
            this.addEReferenceTypePropertyDescriptor(object);
            this.addEKeysPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addContainmentPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EReference_containment_feature"), this.getString("_UI_EReference_containment_description"), (EStructuralFeature)EcorePackage.Literals.EREFERENCE__CONTAINMENT, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addContainerPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EReference_container_feature"), this.getString("_UI_EReference_container_description"), (EStructuralFeature)EcorePackage.Literals.EREFERENCE__CONTAINER, false, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addResolveProxiesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EReference_resolveProxies_feature"), this.getString("_UI_EReference_resolveProxies_description"), (EStructuralFeature)EcorePackage.Literals.EREFERENCE__RESOLVE_PROXIES, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addEOppositePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EReference_eOpposite_feature"), this.getString("_UI_EReference_eOpposite_description"), (EStructuralFeature)EcorePackage.Literals.EREFERENCE__EOPPOSITE, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                EReference eReference = (EReference)object;
                EClass eContainingClass = eReference.getEContainingClass();
                EClass eReferenceType = eReference.getEReferenceType();
                if (eContainingClass == null || eReferenceType == null) {
                    return Collections.EMPTY_LIST;
                }
                ArrayList result = new ArrayList(super.getChoiceOfValues(object));
                Iterator i = result.iterator();
                while (i.hasNext()) {
                    EReference eOpposite = (EReference)i.next();
                    if (eOpposite == null) continue;
                    if (eOpposite == eReference) {
                        i.remove();
                        continue;
                    }
                    EClass eOppositeContainingClass = eOpposite.getEContainingClass();
                    EClass eOppositeReferenceType = eOpposite.getEReferenceType();
                    if (eOppositeContainingClass != null && eOppositeContainingClass.isSuperTypeOf(eReferenceType) && eContainingClass.isSuperTypeOf(eOppositeReferenceType)) continue;
                    i.remove();
                }
                return result;
            }

            public void resetPropertyValue(Object object) {
                this.setPropertyValue(object, null);
            }

            public void setPropertyValue(Object object, Object value) {
                EReference eReference = (EReference)object;
                EReference eOpposite = (EReference)value;
                EditingDomain editingDomain = this.getEditingDomain(eReference);
                if (editingDomain == null) {
                    EReference oldReferenceOpposite = eReference.getEOpposite();
                    if (oldReferenceOpposite != null) {
                        oldReferenceOpposite.setEOpposite(null);
                    }
                    if (eOpposite != null) {
                        EReference oldOppositeOpposite = eOpposite.getEOpposite();
                        if (oldOppositeOpposite != null) {
                            oldOppositeOpposite.setEOpposite(null);
                        }
                        eOpposite.setEOpposite(eReference);
                    }
                    eReference.setEOpposite(eOpposite);
                } else {
                    CompoundCommand compoundCommand = new CompoundCommand(Integer.MIN_VALUE);
                    EReference oldReferenceOpposite = eReference.getEOpposite();
                    if (oldReferenceOpposite != null) {
                        compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.getCommandOwner(oldReferenceOpposite), (Object)this.feature, null));
                    }
                    if (eOpposite != null) {
                        EReference oldOppositeOpposite = eOpposite.getEOpposite();
                        if (oldOppositeOpposite != null) {
                            compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.getCommandOwner(oldOppositeOpposite), (Object)this.feature, null));
                        }
                        compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.getCommandOwner(eOpposite), (Object)this.feature, (Object)eReference));
                    }
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.getCommandOwner(eReference), (Object)this.feature, (Object)eOpposite));
                    editingDomain.getCommandStack().execute((Command)compoundCommand);
                }
            }
        });
    }

    protected void addEReferenceTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EReference_eReferenceType_feature"), this.getString("_UI_EReference_eReferenceType_description"), (EStructuralFeature)EcorePackage.Literals.EREFERENCE__EREFERENCE_TYPE, false, false, false, null, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addEKeysPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EReference_eKeys_feature"), this.getString("_UI_EReference_eKeys_description"), (EStructuralFeature)EcorePackage.Literals.EREFERENCE__EKEYS, true, false, false, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                EReference eReference = (EReference)object;
                ArrayList result = new ArrayList();
                if (eReference.getEType() instanceof EClass) {
                    result.addAll(eReference.getEReferenceType().getEAllAttributes());
                }
                return result;
            }
        });
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getComposedImage(object, this.getResourceLocator().getImage("full/obj16/EReference")));
    }

    @Override
    public String getText(Object object) {
        EReference eReference = (EReference)object;
        StringBuffer result = new StringBuffer();
        result.append(eReference.getName());
        if (eReference.getEGenericType() != null) {
            result.append(" : ");
            result.append(EGenericTypeItemProvider.getText(eReference.getEGenericType()));
        }
        return result.toString();
    }

    protected Command createInitializeCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        return new InitializeCopyCommand(domain, owner, helper){

            protected Collection<? extends EReference> getReferencesToCopy() {
                ArrayList result = new ArrayList(super.getReferencesToCopy());
                result.remove(EcorePackage.Literals.EREFERENCE__EOPPOSITE);
                return result;
            }

            protected void copyReferences() {
                EObject target;
                super.copyReferences();
                EReference reference = EcorePackage.Literals.EREFERENCE__EOPPOSITE;
                EObject value = (EObject)this.owner.eGet((EStructuralFeature)reference);
                if (value != null && (target = this.copyHelper.getCopyTarget(value, true)) != null) {
                    this.copy.eSet((EStructuralFeature)reference, (Object)target);
                }
            }
        };
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(EReference.class)) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

