/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.enablement;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifierEvent;
import org.eclipse.wst.common.frameworks.internal.enablement.FunctionGroup;
import org.eclipse.wst.common.frameworks.internal.enablement.FunctionGroupRegistry;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifierListener;
import org.eclipse.wst.common.frameworks.internal.enablement.Util;

public class EnablementIdentifier
implements IEnablementIdentifier {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL;
    private static final Set strongReferences;
    private Set functionGroupIds;
    private transient String[] functionGroupIdsAsArray;
    private boolean enabled;
    private transient int hashCode;
    private transient boolean hashCodeComputed;
    private String id;
    private List identifierListeners;
    private transient String string;
    private IProject project;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
        strongReferences = new HashSet();
    }

    protected EnablementIdentifier(String id) {
        this(id, null);
    }

    protected EnablementIdentifier(String id, IProject project) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.id = id;
        this.project = project;
    }

    public void addIdentifierListener(IEnablementIdentifierListener identifierListener) {
        if (identifierListener == null) {
            throw new NullPointerException();
        }
        if (this.identifierListeners == null) {
            this.identifierListeners = new ArrayList();
        }
        if (!this.identifierListeners.contains(identifierListener)) {
            this.identifierListeners.add(identifierListener);
        }
        strongReferences.add(this);
    }

    public int compareTo(Object object) {
        EnablementIdentifier castedObject = (EnablementIdentifier)object;
        return Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id));
    }

    public boolean equals(Object object) {
        if (!(object instanceof EnablementIdentifier)) {
            return false;
        }
        EnablementIdentifier castedObject = (EnablementIdentifier)object;
        boolean equals = Util.equals(this.id, castedObject.id);
        return equals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireIdentifierChanged(EnablementIdentifierEvent functionIdentifierEvent) {
        if (functionIdentifierEvent == null) {
            throw new NullPointerException();
        }
        if (this.identifierListeners != null) {
            List list = this.identifierListeners;
            synchronized (list) {
                int i = 0;
                while (i < this.identifierListeners.size()) {
                    ((IEnablementIdentifierListener)this.identifierListeners.get(i)).identifierChanged(functionIdentifierEvent);
                    ++i;
                }
            }
        }
    }

    public Set getFunctionGroupIds() {
        return this.functionGroupIds;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void removeIdentifierListener(IEnablementIdentifierListener identifierListener) {
        if (identifierListener == null) {
            throw new NullPointerException();
        }
        if (this.identifierListeners != null) {
            this.identifierListeners.remove(identifierListener);
        }
        if (this.identifierListeners.isEmpty()) {
            strongReferences.remove(this);
        }
    }

    protected boolean setFunctionGroupIds(Set functionGroupIds) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(functionGroupIds = Util.safeCopy(functionGroupIds, (Class)clazz), this.functionGroupIds)) {
            this.functionGroupIds = functionGroupIds;
            this.functionGroupIdsAsArray = this.functionGroupIds.toArray(new String[this.functionGroupIds.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    protected boolean setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    protected boolean resetEnabled() {
        return this.setEnabled(this.getNewEnabled());
    }

    protected boolean getNewEnabled() {
        if (this.project == null) {
            return true;
        }
        if (this.functionGroupIdsAsArray.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.functionGroupIdsAsArray.length) {
            FunctionGroup group = FunctionGroupRegistry.getInstance().getGroupByID(this.functionGroupIdsAsArray[i]);
            if (group != null && group.isEnabled(this.project)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.functionGroupIds);
            stringBuffer.append(',');
            stringBuffer.append(this.enabled);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getPrimaryFunctionGroupId() {
        int selectedPriority = Integer.MAX_VALUE;
        int priority = 0;
        String selectedFunctionGroupId = null;
        String functionGroupId = null;
        Iterator iterator = this.getFunctionGroupIds().iterator();
        while (iterator.hasNext()) {
            functionGroupId = iterator.next().toString();
            priority = FunctionGroupRegistry.getInstance().getGroupPriority(functionGroupId);
            if (priority < selectedPriority) {
                selectedFunctionGroupId = functionGroupId;
            }
            if (priority != 0) continue;
            return selectedFunctionGroupId;
        }
        return selectedFunctionGroupId;
    }
}

