/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.mirror;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.mirror.Mirroring;
import org.eclipse.equinox.internal.p2.metadata.repository.Activator;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;
import org.osgi.framework.BundleContext;

public class MirrorApplication
implements IApplication {
    private String[] rootSpecs;
    private URI sourceLocation;
    private URI destinationLocation;
    private IMetadataRepository source;
    private IMetadataRepository destination;
    private boolean transitive = false;
    private boolean append = true;
    private IMetadataRepositoryManager cachedManager;
    private boolean sourceLoaded = false;
    private boolean destinationLoaded = false;
    private String destinationName;
    static /* synthetic */ Class class$0;

    public static String[] getArrayArgsFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            if ((token.indexOf(91) >= 0 || token.indexOf(40) >= 0) && tokens.hasMoreTokens()) {
                result.add(String.valueOf(token) + separator + tokens.nextToken());
                continue;
            }
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public Object start(IApplicationContext context) throws Exception {
        try {
            this.initializeFromArguments((String[])context.getArguments().get("application.args"));
            this.setupRepositories();
            new Mirroring().mirror(this.source, this.destination, this.rootSpecs, this.transitive);
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw e;
        }
        finally {
            if (!this.sourceLoaded && this.sourceLocation != null) {
                this.getManager().removeRepository(this.sourceLocation);
            }
            if (!this.destinationLoaded && this.destinationLocation != null) {
                this.getManager().removeRepository(this.destinationLocation);
            }
        }
    }

    private void setupRepositories() throws ProvisionException {
        if (this.destinationLocation == null || this.sourceLocation == null) {
            throw new IllegalStateException("Must specify a source and destination");
        }
        this.sourceLoaded = this.getManager().contains(this.sourceLocation);
        this.destinationLoaded = this.getManager().contains(this.destinationLocation);
        this.source = this.getManager().loadRepository(this.sourceLocation, 0, null);
        this.destination = this.initializeDestination();
    }

    private IMetadataRepositoryManager getManager() {
        IMetadataRepositoryManager result;
        if (this.cachedManager != null) {
            return this.cachedManager;
        }
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            result = this.cachedManager = new MetadataRepositoryManager();
        }
        return result;
    }

    private IMetadataRepository initializeDestination() throws ProvisionException {
        try {
            IMetadataRepository repository = this.getManager().loadRepository(this.destinationLocation, 1, null);
            if (repository != null && repository.isModifiable()) {
                if (this.destinationName != null) {
                    repository.setName(this.destinationName);
                }
                if (!this.append) {
                    repository.removeAll();
                }
                return repository;
            }
        }
        catch (ProvisionException provisionException) {}
        return (IMetadataRepository)RepositoryHelper.validDestinationRepository((IRepository)this.getManager().createRepository(this.destinationLocation, this.destinationName == null ? this.source.getName() : this.destinationName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", this.source.getProperties()));
    }

    public void stop() {
    }

    public void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase("-destinationName")) {
                    this.destinationName = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-writeMode") && args[i].equalsIgnoreCase("clean")) {
                    this.append = false;
                }
                try {
                    if (args[i - 1].equalsIgnoreCase("-source")) {
                        this.sourceLocation = RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg));
                    }
                    if (args[i - 1].equalsIgnoreCase("-destination")) {
                        this.destinationLocation = RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException("Repository location (" + arg + ") must be a URL.");
                }
                if (args[i - 1].equalsIgnoreCase("-roots")) {
                    this.rootSpecs = MirrorApplication.getArrayArgsFromString(arg, ",");
                }
                if (args[i - 1].equalsIgnoreCase("-transitive")) {
                    this.transitive = true;
                }
            }
            ++i;
        }
    }
}

