/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.restarts;

import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;

public class LubyRestarts
implements RestartStrategy {
    private static final long serialVersionUID = 1L;
    private static int[] cachedValues;
    private int factor;
    private int count;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        cachedValues = nArray;
        LubyRestarts.luby(32);
    }

    public static final int luby(int n) {
        if (n >= 0x3FFFFFFF) {
            throw new IllegalArgumentException("i is too big");
        }
        if (n >= cachedValues.length) {
            int n2 = cachedValues.length;
            int n3 = n << 1;
            int[] nArray = new int[n3 + 1];
            System.arraycopy(cachedValues, 0, nArray, 0, n2);
            int n4 = 1;
            while (n4 <= n2) {
                n4 <<= 1;
            }
            int n5 = n4 >> 1;
            int n6 = n2;
            while (n6 <= n3) {
                if (n6 + 1 == n4) {
                    nArray[n6] = n5;
                    n5 = n4;
                    n4 <<= 1;
                } else {
                    nArray[n6] = nArray[n6 - n5 + 1];
                }
                ++n6;
            }
            cachedValues = nArray;
        }
        return cachedValues[n];
    }

    public LubyRestarts() {
        this(32);
    }

    public LubyRestarts(int n) {
        this.setFactor(n);
    }

    public void setFactor(int n) {
        this.factor = n;
    }

    public int getFactor() {
        return this.factor;
    }

    public void init(SearchParams searchParams) {
        this.count = 1;
    }

    public long nextRestartNumberOfConflict() {
        return LubyRestarts.luby(this.count) * this.factor;
    }

    public void onRestart() {
        ++this.count;
    }

    public String toString() {
        return "luby style (SATZ_rand, TiniSAT) restarts strategy with factor " + this.factor;
    }
}

