/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.EditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.provisional.style.IHighlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProviderForNoOp;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class Highlighter
implements IHighlighter {
    private final boolean DEBUG = false;
    private final StyleRange[] EMPTY_STYLE_RANGE = new StyleRange[0];
    static final String LINE_STYLE_PROVIDER_EXTENDED_ID = "linestyleprovider";
    private static final int MAX_NUMBER_STYLES = 500;
    private static final int LEFT_STYLES_SIZE = 200;
    private static final int RIGHT_STYLES_SIZE = 200;
    private static final int MIDDLE_STYLES_SIZE = 1;
    private IPropertyChangeListener fForegroundScaleListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (EditorPreferenceNames.READ_ONLY_FOREGROUND_SCALE.equals(event.getProperty())) {
                IPreferenceStore editorStore = SSEUIPlugin.getDefault().getPreferenceStore();
                Highlighter.this.readOnlyForegroundScaleFactor = editorStore.getInt(EditorPreferenceNames.READ_ONLY_FOREGROUND_SCALE);
                Highlighter.this.disposeColorTable();
                Highlighter.this.refreshDisplay();
            }
        }
    };
    private List fHoldStyleResults;
    private String fPartitioning = "__dftl_partitioning";
    private int fSavedLength = -1;
    private int fSavedOffset = -1;
    private StyleRange[] fSavedRanges = null;
    private IStructuredDocument fStructuredDocument;
    private Map fTableOfProviders;
    private Map fExtendedProviders;
    protected final LineStyleProvider NOOP_PROVIDER = new LineStyleProviderForNoOp();
    private double readOnlyBackgroundScaleFactor = 10.0;
    private Hashtable readOnlyColorTable;
    double readOnlyForegroundScaleFactor = 30.0;
    private YUV_RGBConverter rgbConverter;
    private ITextViewer textViewer;
    private StyledText textWidget;

    protected void addEmptyRange(int start, int length, Collection holdResults) {
        StyleRange result = new StyleRange();
        result.start = start;
        result.length = length;
        holdResults.add(result);
    }

    public void addProvider(String partitionType, LineStyleProvider provider) {
        this.getTableOfProviders().put(partitionType, provider);
    }

    protected void adjust(StyleRange[] ranges, int adjustment) {
        block4: {
            ITextViewer viewer;
            block3: {
                viewer = this.getTextViewer();
                if (adjustment == 0) break block3;
                int i = 0;
                while (i < ranges.length) {
                    ranges[i].start += adjustment;
                    ++i;
                }
                break block4;
            }
            if (!(viewer instanceof ITextViewerExtension5)) break block4;
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            int i = 0;
            while (i < ranges.length) {
                IRegion region = extension.modelRange2WidgetRange((IRegion)new Region(ranges[i].start, ranges[i].length));
                if (region != null) {
                    ranges[i].start = region.getOffset();
                    ranges[i].length = region.getLength();
                }
                ++i;
            }
        }
    }

    void adjustBackground(StyleRange styleRange) {
        Color newColor;
        RGB oldRGB = null;
        Color oldColor = styleRange.background;
        if (oldColor == null) {
            oldColor = this.getTextWidget().getBackground();
        }
        if ((newColor = this.getCachedColorFor(oldRGB = oldColor.getRGB())) == null) {
            double target = this.getRGBConverter().calculateYComponent(oldColor);
            target = target < 0.5 ? 1.0 : 0.0;
            RGB newRGB = this.getRGBConverter().transformRGB(oldRGB, this.readOnlyBackgroundScaleFactor / 100.0, target);
            this.cacheColor(oldRGB, newRGB);
            newColor = this.getCachedColorFor(oldRGB);
        }
        styleRange.background = newColor;
    }

    private void adjustForeground(StyleRange styleRange) {
        RGB oldRGB = null;
        Color oldColor = styleRange.background;
        if (oldColor == null) {
            oldColor = this.getTextWidget().getBackground();
            oldRGB = oldColor.getRGB();
        } else {
            oldRGB = oldColor.getRGB();
        }
        Color newColor = this.getCachedColorFor(oldRGB);
        if (newColor == null) {
            double target = this.getRGBConverter().calculateYComponent(oldColor);
            RGB newRGB = this.getRGBConverter().transformRGBToGrey(oldRGB, this.readOnlyForegroundScaleFactor / 100.0, target);
            this.cacheColor(oldRGB, newRGB);
            newColor = this.getCachedColorFor(oldRGB);
        }
        styleRange.foreground = newColor;
    }

    private void cacheColor(RGB oldRGB, RGB newColor) {
        if (this.readOnlyColorTable == null) {
            this.readOnlyColorTable = new Hashtable();
        }
        this.readOnlyColorTable.put(oldRGB, newColor);
    }

    private StyleRange[] convertReadOnlyRegions(StyleRange[] result, int start, int length) {
        IStructuredDocument structuredDocument = this.getDocument();
        if (structuredDocument.containsReadOnly(start, length)) {
            int i = 0;
            while (i < result.length) {
                StyleRange styleRange = result[i];
                if (structuredDocument.containsReadOnly(styleRange.start, styleRange.length)) {
                    this.adjustForeground(styleRange);
                }
                ++i;
            }
        }
        return result;
    }

    void disposeColorTable() {
        if (this.readOnlyColorTable != null) {
            this.readOnlyColorTable.clear();
        }
        this.readOnlyColorTable = null;
    }

    private Color getCachedColorFor(RGB oldRGB) {
        Color result = null;
        if (this.readOnlyColorTable != null) {
            RGB readOnlyRGB = (RGB)this.readOnlyColorTable.get(oldRGB);
            result = EditorUtility.getColor(readOnlyRGB);
        }
        return result;
    }

    protected IStructuredDocument getDocument() {
        return this.fStructuredDocument;
    }

    private IRegion getDocumentRangeFromWidgetRange(int offset, int length) {
        IRegion styleRegion = null;
        ITextViewer viewer = this.getTextViewer();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            styleRegion = extension.widgetRange2ModelRange((IRegion)new Region(offset, length));
        } else {
            Object vr = null;
            vr = viewer != null ? viewer.getVisibleRegion() : new Region(0, this.getDocument().getLength());
            if (offset <= vr.getLength()) {
                styleRegion = new Region(offset + vr.getOffset(), length);
            }
        }
        return styleRegion;
    }

    private Map getExtendedProviders() {
        if (this.fExtendedProviders == null) {
            this.fExtendedProviders = new HashMap(3);
        }
        return this.fExtendedProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineStyleProvider getProviderFor(ITypedRegion typedRegion) {
        String type = typedRegion.getType();
        LineStyleProvider result = (LineStyleProvider)this.fTableOfProviders.get(type);
        if (result == null) {
            Map map = this.getExtendedProviders();
            synchronized (map) {
                if (!this.getExtendedProviders().containsKey(type)) {
                    LineStyleProvider provider = (LineStyleProvider)ExtendedConfigurationBuilder.getInstance().getConfiguration(LINE_STYLE_PROVIDER_EXTENDED_ID, type);
                    this.getExtendedProviders().put(type, provider);
                    if (provider != null) {
                        provider.init(this.getDocument(), this);
                    }
                    result = provider;
                } else {
                    result = (LineStyleProvider)this.getExtendedProviders().get(type);
                }
            }
        }
        if (result == null) {
            result = this.NOOP_PROVIDER;
        }
        return result;
    }

    private YUV_RGBConverter getRGBConverter() {
        if (this.rgbConverter == null) {
            this.rgbConverter = new YUV_RGBConverter();
        }
        return this.rgbConverter;
    }

    private Map getTableOfProviders() {
        if (this.fTableOfProviders == null) {
            this.fTableOfProviders = new HashMap();
        }
        return this.fTableOfProviders;
    }

    public ITextViewer getTextViewer() {
        return this.textViewer;
    }

    protected StyledText getTextWidget() {
        return this.textWidget;
    }

    public void install(ITextViewer newTextViewer) {
        this.textViewer = newTextViewer;
        IPreferenceStore editorStore = SSEUIPlugin.getDefault().getPreferenceStore();
        editorStore.addPropertyChangeListener(this.fForegroundScaleListener);
        this.readOnlyForegroundScaleFactor = editorStore.getInt(EditorPreferenceNames.READ_ONLY_FOREGROUND_SCALE);
        if (this.textWidget != null) {
            this.textWidget.removeLineStyleListener((LineStyleListener)this);
        }
        this.textWidget = newTextViewer.getTextWidget();
        if (this.textWidget != null) {
            this.textWidget.addLineStyleListener((LineStyleListener)this);
        }
        this.refreshDisplay();
    }

    public StyleRange[] lineGetStyle(int eventLineOffset, int eventLineLength) {
        StyleRange[] eventStyles = this.EMPTY_STYLE_RANGE;
        try {
            if (this.getDocument() == null || eventLineLength == 0) {
                eventStyles = this.EMPTY_STYLE_RANGE;
            } else {
                IRegion styleRegion = this.getDocumentRangeFromWidgetRange(eventLineOffset, eventLineLength);
                if (styleRegion != null) {
                    int start = styleRegion.getOffset();
                    int length = styleRegion.getLength();
                    ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)this.getDocument(), (String)this.fPartitioning, (int)start, (int)length, (boolean)false);
                    eventStyles = this.prepareStyleRangesArray(partitions, start, length);
                    if (start != eventLineOffset) {
                        IRegion vr;
                        int offset = 0;
                        if (!(this.getTextViewer() instanceof ITextViewerExtension5) && (vr = this.getTextViewer().getVisibleRegion()) != null) {
                            offset = vr.getOffset();
                        }
                        this.adjust(eventStyles, -offset);
                    }
                    eventStyles = this.limitSize(eventStyles);
                }
            }
        }
        catch (Exception exception) {
            eventStyles = this.EMPTY_STYLE_RANGE;
        }
        return eventStyles;
    }

    private StyleRange[] limitSize(StyleRange[] eventStyles) {
        if (eventStyles.length < 500) {
            return eventStyles;
        }
        StyleRange[] newRanges = new StyleRange[401];
        System.arraycopy(eventStyles, 0, newRanges, 0, 200);
        System.arraycopy(eventStyles, eventStyles.length - 200, newRanges, 201, 200);
        StyleRange allBlank = new StyleRange();
        StyleRange lastKnown = newRanges[199];
        allBlank.start = lastKnown.start + lastKnown.length;
        StyleRange nextKnown = newRanges[202];
        allBlank.length = nextKnown.start - allBlank.start;
        newRanges[200] = allBlank;
        return newRanges;
    }

    public void lineGetStyle(LineStyleEvent event) {
        int offset = event.lineOffset;
        int length = event.lineText.length();
        if (offset == this.fSavedOffset && length == this.fSavedLength && this.fSavedRanges != null) {
            event.styles = this.fSavedRanges;
        } else {
            event.styles = this.lineGetStyle(offset, length);
            this.fSavedOffset = offset;
            this.fSavedLength = length;
            this.fSavedRanges = event.styles;
        }
    }

    protected StyleRange[] prepareStyleRangesArray(ITypedRegion[] partitions, int start, int length) {
        StyleRange[] result = this.EMPTY_STYLE_RANGE;
        if (this.fHoldStyleResults == null) {
            this.fHoldStyleResults = new ArrayList(partitions.length);
        } else {
            this.fHoldStyleResults.clear();
        }
        LineStyleProvider currentLineStyleProvider = null;
        int i = 0;
        while (i < partitions.length) {
            ITypedRegion currentPartition = partitions[i];
            currentLineStyleProvider = this.getProviderFor(currentPartition);
            currentLineStyleProvider.init(this.getDocument(), this);
            currentLineStyleProvider.prepareRegions(currentPartition, currentPartition.getOffset(), currentPartition.getLength(), this.fHoldStyleResults);
            ++i;
        }
        int resultSize = this.fHoldStyleResults.size();
        result = resultSize > 0 ? this.fHoldStyleResults.toArray(new StyleRange[this.fHoldStyleResults.size()]) : this.EMPTY_STYLE_RANGE;
        result = this.convertReadOnlyRegions(result, start, length);
        return result;
    }

    public void refreshDisplay() {
        if (this.textWidget != null && !this.textWidget.isDisposed()) {
            this.textWidget.redraw();
        }
    }

    public void refreshDisplay(int start, int length) {
        if (this.textWidget != null && !this.textWidget.isDisposed()) {
            this.textWidget.redrawRange(start, length, true);
        }
    }

    public void removeProvider(String partitionType) {
        this.getTableOfProviders().remove(partitionType);
    }

    public void setDocument(IStructuredDocument structuredDocument) {
        this.fStructuredDocument = structuredDocument;
    }

    public void setDocumentPartitioning(String partitioning) {
        this.fPartitioning = partitioning != null ? partitioning : "__dftl_partitioning";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        Object lineStyleProvider;
        if (this.textWidget != null && !this.textWidget.isDisposed()) {
            this.textWidget.removeLineStyleListener((LineStyleListener)this);
        }
        this.textWidget = null;
        Collection providers = this.getTableOfProviders().values();
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            lineStyleProvider = (LineStyleProvider)iterator.next();
            lineStyleProvider.release();
            iterator.remove();
        }
        lineStyleProvider = this.getExtendedProviders();
        synchronized (lineStyleProvider) {
            providers = new ArrayList(this.getExtendedProviders().values());
            this.getExtendedProviders().clear();
        }
        iterator = providers.iterator();
        while (iterator.hasNext()) {
            lineStyleProvider = (LineStyleProvider)iterator.next();
            if (lineStyleProvider == null) continue;
            lineStyleProvider.release();
            iterator.remove();
        }
        IPreferenceStore editorStore = SSEUIPlugin.getDefault().getPreferenceStore();
        editorStore.removePropertyChangeListener(this.fForegroundScaleListener);
        this.disposeColorTable();
        this.fSavedOffset = -1;
        this.fSavedLength = -1;
        this.fSavedRanges = null;
    }

    private boolean valid(StyleRange[] eventStyles, int startOffset, int lineLength) {
        boolean result = false;
        if (eventStyles != null) {
            if (eventStyles.length > 0) {
                int lineEndOffset;
                int lastOffset;
                StyleRange first = eventStyles[0];
                StyleRange last = eventStyles[eventStyles.length - 1];
                result = startOffset > first.start ? false : (lastOffset = last.start + last.length) <= (lineEndOffset = startOffset + lineLength);
            } else {
                result = true;
            }
        }
        return result;
    }

    private class YUV_RGBConverter {
        public double calculateYComponent(Color targetColor) {
            return new YUV(targetColor.getRGB()).getY();
        }

        public RGB transformRGB(RGB originalRGB, double scaleFactor, double target) {
            RGB transformedRGB = null;
            YUV yuv = new YUV(originalRGB);
            double y = yuv.getY();
            y = y < target ? (y += (target - y) * scaleFactor) : (y -= (y - target) * scaleFactor);
            YUV newYUV = new YUV(y, yuv.getU(), yuv.getV());
            transformedRGB = newYUV.getRGB();
            return transformedRGB;
        }

        public RGB transformRGBToGrey(RGB originalRGB, double scaleFactor, double target) {
            RGB transformedRGB = null;
            double y = 0.0;
            double mid = 0.5;
            y = target < mid ? target + scaleFactor : target - scaleFactor;
            int c = (int)Math.round(y * 255.0);
            if (c > 255) {
                c = 255;
            }
            if (c < 0) {
                c = 0;
            }
            transformedRGB = new RGB(c, c, c);
            return transformedRGB;
        }

        private class YUV {
            private NormalizedRGB normalizedRGB;
            private double u = -1.0;
            private double v = -1.0;
            private double y = -1.0;

            private YUV() {
            }

            public YUV(double y, double u, double v) {
                this();
                this.y = y;
                this.u = u;
                this.v = v;
            }

            public YUV(RGB rgb) {
                this();
                this.normalizedRGB = new NormalizedRGB(rgb);
                this.getY();
                this.getV();
                this.getU();
            }

            double gammaNormalized(double colorComponent) {
                if (colorComponent < 0.018) {
                    return colorComponent * 0.45;
                }
                return 1.099 * Math.pow(colorComponent, 0.45) - 0.099;
            }

            public RGB getRGB() {
                RGB result = null;
                double r = this.getY() + 1.14 * this.getV();
                double g = this.getY() - 0.395 * this.getU() - 0.58 * this.getV();
                double b = this.getY() + 2.032 * this.getU();
                int red = (int)(this.inverseGammaNormalized(r) * 256.0);
                int green = (int)(this.inverseGammaNormalized(g) * 256.0);
                int blue = (int)(this.inverseGammaNormalized(b) * 256.0);
                if (red < 0) {
                    red = 0;
                } else if (red > 255) {
                    red = 255;
                }
                if (green < 0) {
                    green = 0;
                } else if (green > 255) {
                    green = 255;
                }
                if (blue < 0) {
                    blue = 0;
                } else if (blue > 255) {
                    blue = 255;
                }
                result = new RGB(red, green, blue);
                return result;
            }

            public double getU() {
                if (this.u == -1.0) {
                    this.u = 0.4949 * (this.normalizedRGB.blue - this.getY());
                }
                return this.u;
            }

            public double getV() {
                if (this.v == -1.0) {
                    this.v = 0.877 * (this.normalizedRGB.red - this.getY());
                }
                return this.v;
            }

            public double getY() {
                if (this.y == -1.0) {
                    this.y = 0.299 * this.normalizedRGB.red + 0.587 * this.normalizedRGB.green + 0.114 * this.normalizedRGB.blue;
                }
                return this.y;
            }

            double inverseGammaNormalized(double colorComponent) {
                if (colorComponent < 0.018) {
                    return colorComponent * 0.222;
                }
                return Math.pow(0.9099 * colorComponent + 0.09, 2.22);
            }

            class NormalizedRGB {
                double blue;
                double green;
                private final double maxRGB = 256.0;
                double red;

                public NormalizedRGB(RGB rgb) {
                    this.red = (double)rgb.red / 256.0;
                    this.green = (double)rgb.green / 256.0;
                    this.blue = (double)rgb.blue / 256.0;
                    this.red = YUV.this.gammaNormalized(this.red);
                    this.green = YUV.this.gammaNormalized(this.green);
                    this.blue = YUV.this.gammaNormalized(this.blue);
                }
            }
        }
    }
}

