/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFlag;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFlagMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConfiguration
implements Serializable {
    private static final long serialVersionUID = -1162588743524741054L;
    private String repositoryUrl = "<unknown>";
    private final Map<String, ProductEntry> products = new HashMap<String, ProductEntry>();
    private final List<String> platforms = new ArrayList<String>();
    private final List<String> operatingSystems = new ArrayList<String>();
    private final List<String> priorities = new ArrayList<String>();
    private final List<String> severities = new ArrayList<String>();
    private final List<String> bugStatus = new ArrayList<String>();
    private final List<String> openStatusValues = new ArrayList<String>();
    private final List<String> resolutionValues = new ArrayList<String>();
    private final List<String> keywords = new ArrayList<String>();
    private final List<String> versions = new ArrayList<String>();
    private final List<String> components = new ArrayList<String>();
    private final List<String> milestones = new ArrayList<String>();
    private final List<BugzillaCustomField> customFields = new ArrayList<BugzillaCustomField>();
    private final List<BugzillaFlag> flags = new ArrayList<BugzillaFlag>();
    private BugzillaVersion version = BugzillaVersion.MIN_VERSION;
    private String encoding = null;

    public void addStatus(String status) {
        this.bugStatus.add(status);
    }

    public List<String> getStatusValues() {
        return this.bugStatus;
    }

    public void addResolution(String res) {
        this.resolutionValues.add(res);
    }

    public List<String> getResolutions() {
        return this.resolutionValues;
    }

    public void addProduct(String name) {
        if (!this.products.containsKey(name)) {
            ProductEntry product = new ProductEntry(name);
            this.products.put(name, product);
        }
    }

    public List<String> getProducts() {
        ArrayList<String> productList = new ArrayList<String>(this.products.keySet());
        Collections.sort(productList);
        return productList;
    }

    public List<String> getComponents(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getComponents();
        }
        return Collections.emptyList();
    }

    public List<String> getVersions(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getVersions();
        }
        return Collections.emptyList();
    }

    public List<String> getSeverities() {
        return this.severities;
    }

    public List<String> getOSs() {
        return this.operatingSystems;
    }

    public void addOS(String os) {
        this.operatingSystems.add(os);
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public List<String> getPriorities() {
        return this.priorities;
    }

    public void addComponent(String product, String component) {
        ProductEntry entry;
        if (!this.components.contains(component)) {
            this.components.add(component);
        }
        if ((entry = this.products.get(product)) == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.addComponent(component);
    }

    public void addVersion(String product, String version) {
        ProductEntry entry;
        if (!this.versions.contains(version)) {
            this.versions.add(version);
        }
        if ((entry = this.products.get(product)) == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.addVersion(version);
    }

    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void addPlatform(String platform) {
        this.platforms.add(platform);
    }

    public void addPriority(String priority) {
        this.priorities.add(priority);
    }

    public void addSeverity(String severity) {
        this.severities.add(severity);
    }

    public void setInstallVersion(String version) {
        this.version = new BugzillaVersion(version);
    }

    public BugzillaVersion getInstallVersion() {
        return this.version;
    }

    public void addTargetMilestone(String product, String target) {
        ProductEntry entry;
        if (!this.milestones.contains(target)) {
            this.milestones.add(target);
        }
        if ((entry = this.products.get(product)) == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.addTargetMilestone(target);
    }

    public List<String> getTargetMilestones(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getTargetMilestones();
        }
        return Collections.emptyList();
    }

    public List<String> getOpenStatusValues() {
        return this.openStatusValues;
    }

    public void addOpenStatusValue(String value) {
        this.openStatusValues.add(value);
    }

    public List<String> getComponents() {
        return this.components;
    }

    public List<String> getTargetMilestones() {
        return this.milestones;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public List<String> getOptionValues(BugzillaAttribute element, String product) {
        switch (element) {
            case PRODUCT: {
                return this.getProducts();
            }
            case TARGET_MILESTONE: {
                return this.getTargetMilestones(product);
            }
            case BUG_STATUS: {
                return this.getStatusValues();
            }
            case VERSION: {
                return this.getVersions(product);
            }
            case COMPONENT: {
                return this.getComponents(product);
            }
            case REP_PLATFORM: {
                return this.getPlatforms();
            }
            case OP_SYS: {
                return this.getOSs();
            }
            case PRIORITY: {
                return this.getPriorities();
            }
            case BUG_SEVERITY: {
                return this.getSeverities();
            }
            case KEYWORDS: {
                return this.getKeywords();
            }
            case RESOLUTION: {
                return this.getResolutions();
            }
        }
        return Collections.emptyList();
    }

    public void addCustomField(BugzillaCustomField newField) {
        this.customFields.add(newField);
    }

    public List<BugzillaCustomField> getCustomFields() {
        return this.customFields;
    }

    public void configureTaskData(TaskData taskData) {
        if (taskData != null) {
            this.addMissingFlags(taskData);
            this.updateAttributeOptions(taskData);
            this.addValidOperations(taskData);
        }
    }

    private void addMissingFlags(TaskData taskData) {
        ArrayList<String> existingFlags = new ArrayList<String>();
        List<BugzillaFlag> flags = this.getFlags();
        for (TaskAttribute attribute : new HashSet(taskData.getRoot().getAttributes().values())) {
            String desc;
            TaskAttribute state;
            if (!attribute.getId().startsWith("task.common.kind.flag") || (state = attribute.getAttribute("state")) == null) continue;
            String nameValue = state.getMetaData().getLabel();
            if (!existingFlags.contains(nameValue)) {
                existingFlags.add(nameValue);
            }
            if ((desc = attribute.getMetaData().getLabel()) != null && !desc.equals("")) continue;
            for (BugzillaFlag bugzillaFlag : flags) {
                if (bugzillaFlag.getType().equals("attachment") || !bugzillaFlag.getName().equals(nameValue)) continue;
                attribute.getMetaData().setLabel(bugzillaFlag.getDescription());
            }
        }
        TaskAttribute productAttribute = taskData.getRoot().getMappedAttribute(BugzillaAttribute.PRODUCT.getKey());
        TaskAttribute componentAttribute = taskData.getRoot().getMappedAttribute(BugzillaAttribute.COMPONENT.getKey());
        for (BugzillaFlag bugzillaFlag : flags) {
            if (bugzillaFlag.getType().equals("attachment") || !bugzillaFlag.isUsedIn(productAttribute.getValue(), componentAttribute.getValue()) || existingFlags.contains(bugzillaFlag.getName()) && !bugzillaFlag.isMultiplicable()) continue;
            BugzillaFlagMapper mapper = new BugzillaFlagMapper();
            mapper.setRequestee("");
            mapper.setSetter("");
            mapper.setState(" ");
            mapper.setFlagId(bugzillaFlag.getName());
            mapper.setNumber(0);
            mapper.setDescription(bugzillaFlag.getDescription());
            TaskAttribute attribute = taskData.getRoot().createAttribute("task.common.kind.flag_type" + bugzillaFlag.getFlagId());
            mapper.applyTo(attribute);
        }
        this.setFlagsRequestee(taskData);
    }

    private void setFlagsRequestee(TaskData taskData) {
        for (TaskAttribute attribute : new HashSet(taskData.getRoot().getAttributes().values())) {
            TaskAttribute state;
            if (!attribute.getId().startsWith("task.common.kind.flag") || (state = attribute.getAttribute("state")) == null) continue;
            String nameValue = state.getMetaData().getLabel();
            for (BugzillaFlag bugzillaFlag : this.flags) {
                if (!nameValue.equals(bugzillaFlag.getName())) continue;
                TaskAttribute requestee = attribute.getAttribute("requestee");
                if (requestee == null) {
                    requestee = attribute.createMappedAttribute("requestee");
                    requestee.getMetaData().defaults().setType("shortText");
                    requestee.setValue("");
                }
                requestee.getMetaData().setReadOnly(!bugzillaFlag.isSpecifically_requestable());
            }
        }
    }

    public void updateAttributeOptions(TaskData existingReport) {
        TaskAttribute attributeProduct = existingReport.getRoot().getMappedAttribute(BugzillaAttribute.PRODUCT.getKey());
        if (attributeProduct == null) {
            return;
        }
        String product = attributeProduct.getValue();
        for (TaskAttribute attribute : new HashSet(existingReport.getRoot().getAttributes().values())) {
            List<String> optionValues = this.getAttributeOptions(product, attribute);
            if (attribute.getId().equals(BugzillaAttribute.TARGET_MILESTONE.getKey()) && optionValues.isEmpty()) {
                existingReport.getRoot().removeAttribute(BugzillaAttribute.TARGET_MILESTONE.getKey());
                continue;
            }
            if (attribute.getId().startsWith("task.common.kind.flag")) {
                attribute = attribute.getAttribute("state");
            }
            attribute.clearOptions();
            for (String option : optionValues) {
                attribute.putOption(option, option);
            }
        }
    }

    public List<String> getAttributeOptions(String product, TaskAttribute attribute) {
        List<String> options = new ArrayList<String>();
        if (attribute.getId().startsWith("cf_")) {
            for (BugzillaCustomField bugzillaCustomField : this.customFields) {
                if (!bugzillaCustomField.getName().equals(attribute.getId())) continue;
                options = bugzillaCustomField.getOptions();
                break;
            }
        } else if (attribute.getId().startsWith("task.common.kind.flag")) {
            TaskAttribute state = attribute.getAttribute("state");
            if (state != null) {
                String nameValue = state.getMetaData().getLabel();
                options.add("");
                for (BugzillaFlag bugzillaFlag : this.flags) {
                    if (!nameValue.equals(bugzillaFlag.getName()) || !nameValue.equals(bugzillaFlag.getName())) continue;
                    if (!bugzillaFlag.isRequestable()) break;
                    options.add("?");
                    break;
                }
                options.add("+");
                options.add("-");
            }
        } else {
            String type = attribute.getMetaData().getType();
            if (type != null && type.equals("bugzilla.editor.flag")) {
                options.add("");
                options.add("?");
                options.add("+");
                options.add("-");
            } else {
                BugzillaAttribute element;
                try {
                    element = BugzillaAttribute.valueOf(attribute.getId().trim().toUpperCase(Locale.ENGLISH));
                }
                catch (RuntimeException e) {
                    if (e instanceof IllegalArgumentException) {
                        return options;
                    }
                    throw e;
                }
                options = this.getOptionValues(element, product);
                if (element != BugzillaAttribute.RESOLUTION && element != BugzillaAttribute.OP_SYS && element != BugzillaAttribute.BUG_SEVERITY && element != BugzillaAttribute.PRIORITY && element != BugzillaAttribute.BUG_STATUS) {
                    Collections.sort(options);
                }
            }
        }
        return options;
    }

    public void addValidOperations(TaskData bugReport) {
        BugzillaVersion bugzillaVersion;
        TaskAttribute attributeStatus = bugReport.getRoot().getMappedAttribute("task.common.status");
        IBugzillaConstants.BUGZILLA_REPORT_STATUS status = IBugzillaConstants.BUGZILLA_REPORT_STATUS.NEW;
        if (attributeStatus != null) {
            try {
                status = IBugzillaConstants.BUGZILLA_REPORT_STATUS.valueOf(attributeStatus.getValue());
            }
            catch (RuntimeException runtimeException) {
                status = IBugzillaConstants.BUGZILLA_REPORT_STATUS.NEW;
            }
        }
        if ((bugzillaVersion = this.getInstallVersion()) == null) {
            bugzillaVersion = BugzillaVersion.MIN_VERSION;
        }
        switch (status) {
            case UNCONFIRMED: 
            case NEW: 
            case REOPENED: {
                this.addOperation(bugReport, BugzillaOperation.none);
                this.addOperation(bugReport, BugzillaOperation.accept);
                this.addOperation(bugReport, BugzillaOperation.resolve);
                this.addOperation(bugReport, BugzillaOperation.duplicate);
                break;
            }
            case ASSIGNED: {
                this.addOperation(bugReport, BugzillaOperation.none);
                this.addOperation(bugReport, BugzillaOperation.resolve);
                this.addOperation(bugReport, BugzillaOperation.duplicate);
                break;
            }
            case RESOLVED: {
                this.addOperation(bugReport, BugzillaOperation.none);
                this.addOperation(bugReport, BugzillaOperation.reopen);
                this.addOperation(bugReport, BugzillaOperation.verify);
                this.addOperation(bugReport, BugzillaOperation.close);
                if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_0) < 0) break;
                this.addOperation(bugReport, BugzillaOperation.duplicate);
                this.addOperation(bugReport, BugzillaOperation.resolve);
                break;
            }
            case CLOSED: {
                this.addOperation(bugReport, BugzillaOperation.none);
                this.addOperation(bugReport, BugzillaOperation.reopen);
                if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_0) < 0) break;
                this.addOperation(bugReport, BugzillaOperation.duplicate);
                this.addOperation(bugReport, BugzillaOperation.resolve);
                break;
            }
            case VERIFIED: {
                this.addOperation(bugReport, BugzillaOperation.none);
                this.addOperation(bugReport, BugzillaOperation.reopen);
                this.addOperation(bugReport, BugzillaOperation.close);
                if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_0) < 0) break;
                this.addOperation(bugReport, BugzillaOperation.duplicate);
                this.addOperation(bugReport, BugzillaOperation.resolve);
            }
        }
        if (bugzillaVersion.compareTo(BugzillaVersion.BUGZILLA_3_0) < 0) {
            TaskAttribute productAttribute = bugReport.getRoot().getMappedAttribute(BugzillaAttribute.PRODUCT.getKey());
            productAttribute.getMetaData().setReadOnly(true);
        }
        if (status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.NEW || status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.ASSIGNED || status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.REOPENED || status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.UNCONFIRMED) {
            if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_0) <= 0) {
                this.addOperation(bugReport, BugzillaOperation.reassign);
                this.addOperation(bugReport, BugzillaOperation.reassignbycomponent);
            } else {
                BugzillaAttribute key = BugzillaAttribute.SET_DEFAULT_ASSIGNEE;
                TaskAttribute operationAttribute = bugReport.getRoot().getAttribute(key.getKey());
                if (operationAttribute == null) {
                    operationAttribute = bugReport.getRoot().createAttribute(key.getKey());
                    operationAttribute.getMetaData().defaults().setReadOnly(key.isReadOnly()).setKind(key.getKind()).setLabel(key.toString()).setType(key.getType());
                    operationAttribute.setValue("0");
                }
                if ((operationAttribute = bugReport.getRoot().getMappedAttribute("task.common.user.assigned")) != null) {
                    operationAttribute.getMetaData().setReadOnly(false);
                }
            }
        }
    }

    public void addOperation(TaskData bugReport, BugzillaOperation opcode) {
        TaskAttribute operationAttribute = bugReport.getRoot().getAttribute("task.common.operation");
        if (operationAttribute == null) {
            operationAttribute = bugReport.getRoot().createAttribute("task.common.operation");
        }
        switch (opcode) {
            case none: {
                TaskAttribute attribute = bugReport.getRoot().createAttribute("task.common.operation-" + opcode.toString());
                String label = "Leave";
                TaskAttribute attributeStatus = bugReport.getRoot().getMappedAttribute("task.common.status");
                TaskAttribute attributeResolution = bugReport.getRoot().getMappedAttribute("task.common.resolution");
                if (attributeStatus != null && attributeResolution != null) {
                    label = String.format(opcode.getLabel(), attributeStatus.getValue(), attributeResolution.getValue());
                }
                TaskOperation.applyTo((TaskAttribute)attribute, (String)opcode.toString(), (String)label);
                TaskOperation.applyTo((TaskAttribute)operationAttribute, (String)opcode.toString(), (String)label);
                break;
            }
            case resolve: {
                TaskAttribute attribute = bugReport.getRoot().createAttribute("task.common.operation-" + opcode.toString());
                TaskOperation.applyTo((TaskAttribute)attribute, (String)opcode.toString(), (String)opcode.getLabel());
                TaskAttribute attrResolvedInput = attribute.getTaskData().getRoot().createAttribute(opcode.getInputId());
                attrResolvedInput.getMetaData().setType(opcode.getInputType());
                attribute.getMetaData().putValue("task.meta.associated.attribute", opcode.getInputId());
                for (String resolution : this.getResolutions()) {
                    if (resolution.compareTo("DUPLICATE") == 0 || resolution.compareTo("MOVED") == 0) continue;
                    attrResolvedInput.putOption(resolution, resolution);
                }
                if (this.getResolutions().size() <= 0) break;
                attrResolvedInput.setValue(this.getResolutions().get(0));
                break;
            }
            default: {
                TaskAttribute attribute = bugReport.getRoot().createAttribute("task.common.operation-" + opcode.toString());
                TaskOperation.applyTo((TaskAttribute)attribute, (String)opcode.toString(), (String)opcode.getLabel());
                if (opcode.getInputId() == null) break;
                TaskAttribute attrInput = bugReport.getRoot().createAttribute(opcode.getInputId());
                attrInput.getMetaData().defaults().setReadOnly(false).setType(opcode.getInputType());
                attribute.getMetaData().putValue("task.meta.associated.attribute", opcode.getInputId());
            }
        }
    }

    public void addFlag(BugzillaFlag newFlag) {
        this.flags.add(newFlag);
    }

    public List<BugzillaFlag> getFlags() {
        return this.flags;
    }

    public BugzillaFlag getFlagWithId(Integer id) {
        for (BugzillaFlag bugzillaFlag : this.flags) {
            if (bugzillaFlag.getFlagId() != id.intValue()) continue;
            return bugzillaFlag;
        }
        return null;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProductEntry
    implements Serializable {
        private static final long serialVersionUID = 4120139521246741120L;
        String productName;
        List<String> components = new ArrayList<String>();
        List<String> versions = new ArrayList<String>();
        List<String> milestones = new ArrayList<String>();

        ProductEntry(String name) {
            this.productName = name;
        }

        List<String> getComponents() {
            return this.components;
        }

        void addComponent(String componentName) {
            if (!this.components.contains(componentName)) {
                this.components.add(componentName);
            }
        }

        List<String> getVersions() {
            return this.versions;
        }

        void addVersion(String name) {
            if (!this.versions.contains(name)) {
                this.versions.add(name);
            }
        }

        List<String> getTargetMilestones() {
            return this.milestones;
        }

        void addTargetMilestone(String target) {
            this.milestones.add(target);
        }
    }
}

