/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.provisional.p2.core.FormatException;
import org.eclipse.equinox.internal.provisional.p2.core.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionFormat;
import org.eclipse.equinox.internal.provisional.p2.core.VersionParser;
import org.eclipse.osgi.util.NLS;

class VersionFormatParser {
    static final VersionFormat.Qualifier EXACT_ONE_QUALIFIER = new VersionFormat.Qualifier(1, 1);
    static final VersionFormat.Qualifier ONE_OR_MANY_QUALIFIER = new VersionFormat.Qualifier(1, Integer.MAX_VALUE);
    static final VersionFormat.Qualifier ZERO_OR_MANY_QUALIFIER = new VersionFormat.Qualifier(0, Integer.MAX_VALUE);
    static final VersionFormat.Qualifier ZERO_OR_ONE_QUALIFIER = new VersionFormat.Qualifier(0, 1);
    private int current;
    private List currentList;
    private int eos;
    private String format;
    private int start;

    VersionFormatParser() {
    }

    VersionFormat.Fragment compile(String fmt, int pos, int maxPos) throws FormatException {
        VersionFormat.Fragment topFrag;
        this.format = fmt;
        if (this.start >= maxPos) {
            throw new FormatException(Messages.format_is_empty);
        }
        this.start = pos;
        this.current = pos;
        this.eos = maxPos;
        this.currentList = new ArrayList();
        while (this.current < this.eos) {
            this.parseFragment();
        }
        switch (this.currentList.size()) {
            case 0: {
                throw new FormatException(Messages.format_is_empty);
            }
            case 1: {
                VersionFormat.Fragment frag = (VersionFormat.Fragment)this.currentList.get(0);
                if (frag.isGroup()) {
                    topFrag = frag;
                    break;
                }
            }
            default: {
                topFrag = VersionFormat.createGroupFragment(null, EXACT_ONE_QUALIFIER, this.currentList.toArray(new VersionFormat.Fragment[this.currentList.size()]), false);
            }
        }
        this.currentList = null;
        return topFrag;
    }

    private void assertChar(char expected) throws FormatException {
        if (this.current >= this.eos) {
            throw this.formatException(NLS.bind((String)Messages.premature_end_of_format_expected_0, (Object)new String(new char[]{expected})));
        }
        char c = this.format.charAt(this.current);
        if (c != expected) {
            throw this.formatException(c, new String(new char[]{expected}));
        }
        ++this.current;
    }

    private FormatException formatException(char found, String expected) {
        return this.formatException(new String(new char[]{found}), expected);
    }

    private FormatException formatException(String message) {
        return new FormatException(NLS.bind((String)Messages.syntax_error_in_version_format_0_1_2, (Object[])new Object[]{this.format.substring(this.start, this.eos), new Integer(this.current), message}));
    }

    private FormatException formatException(String found, String expected) {
        return new FormatException(NLS.bind((String)Messages.syntax_error_in_version_format_0_1_found_2_expected_3, (Object[])new Object[]{this.format.substring(this.start, this.eos), new Integer(this.current), found, expected}));
    }

    private FormatException illegalControlCharacter(char c) {
        return this.formatException(NLS.bind((String)Messages.illegal_character_encountered_ascii_0, (Object)Version.valueOf(c)));
    }

    private String parseAndConsiderEscapeUntil(char endChar) throws FormatException {
        StringBuffer sb = new StringBuffer();
        while (this.current < this.eos) {
            char c;
            if ((c = this.format.charAt(this.current++)) == endChar) break;
            if (c < ' ') {
                throw this.illegalControlCharacter(c);
            }
            if (c == '\\') {
                if (this.current == this.eos) {
                    throw this.formatException(Messages.EOS_after_escape);
                }
                if ((c = this.format.charAt(this.current++)) < ' ') {
                    throw this.illegalControlCharacter(c);
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void parseAuto() throws FormatException {
        Instructions ep = this.parseProcessing();
        if (ep != null && ep.padValue != null) {
            throw this.formatException(Messages.auto_can_not_have_pad_value);
        }
        this.currentList.add(VersionFormat.createAutoFragment(ep, this.parseQualifier()));
    }

    private void parseBracketGroup() throws FormatException {
        List saveList = this.currentList;
        this.currentList = new ArrayList();
        while (this.current < this.eos && this.format.charAt(this.current) != ']') {
            this.parseFragment();
        }
        if (this.current == this.eos) {
            throw this.formatException(NLS.bind((String)Messages.premature_end_of_format_expected_0, (Object)"]"));
        }
        ++this.current;
        Instructions ep = this.parseProcessing();
        saveList.add(VersionFormat.createGroupFragment(ep, ZERO_OR_ONE_QUALIFIER, this.currentList.toArray(new VersionFormat.Fragment[this.currentList.size()]), false));
        this.currentList = saveList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseCharacterGroup(Instructions ep) throws FormatException {
        this.assertChar('[');
        StringBuffer sb = new StringBuffer();
        block6: while (this.current < this.eos) {
            char c = this.format.charAt(this.current);
            switch (c) {
                case '\\': {
                    if (this.current + 1 >= this.eos) {
                        throw this.formatException(Messages.premature_end_of_format);
                    }
                    sb.append(this.format.charAt(++this.current));
                    break;
                }
                case '^': {
                    if (sb.length() == 0) {
                        ep.inverted = true;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case ']': {
                    break block6;
                }
                case '-': {
                    if (sb.length() > 0 && this.current + 1 < this.eos) {
                        char rangeEnd;
                        if ((rangeEnd = this.format.charAt(++this.current)) == ']') {
                            sb.append(c);
                            break block6;
                        }
                        char rangeStart = sb.charAt(sb.length() - 1);
                        if (rangeEnd < rangeStart) {
                            throw this.formatException(Messages.negative_character_range);
                        }
                        while ((rangeStart = (char)(rangeStart + '\u0001')) <= rangeEnd) {
                            sb.append(rangeStart);
                        }
                        break;
                    }
                }
                default: {
                    if (c < ' ') {
                        throw this.illegalControlCharacter(c);
                    }
                    sb.append(c);
                }
            }
            ++this.current;
        }
        this.assertChar(']');
        int top = sb.length();
        char[] chars = new char[top];
        sb.getChars(0, top, chars, 0);
        ep.characters = chars;
    }

    private void parseDelimiter() throws FormatException {
        Instructions ep = this.parseProcessing();
        if (ep != null) {
            if (ep.rangeMin != 0 || ep.rangeMax != Integer.MAX_VALUE) {
                throw this.formatException(Messages.delimiter_can_not_have_range);
            }
            if (ep.ignore) {
                throw this.formatException(Messages.delimiter_can_not_be_ignored);
            }
            if (ep.defaultValue != null) {
                throw this.formatException(Messages.delimiter_can_not_have_default_value);
            }
            if (ep.padValue != null) {
                throw this.formatException(Messages.delimiter_can_not_have_pad_value);
            }
        }
        this.currentList.add(VersionFormat.createDelimiterFragment(ep, this.parseQualifier()));
    }

    private void parseFragment() throws FormatException {
        if (this.current == this.eos) {
            throw this.formatException(Messages.premature_end_of_format);
        }
        char c = this.format.charAt(this.current++);
        switch (c) {
            case '(': {
                this.parseGroup(false);
                break;
            }
            case '<': {
                this.parseGroup(true);
                break;
            }
            case '[': {
                this.parseBracketGroup();
                break;
            }
            case 'a': {
                this.parseAuto();
                break;
            }
            case 'r': {
                this.parseRaw();
                break;
            }
            case 'n': {
                this.parseNumber(false);
                break;
            }
            case 'N': {
                this.parseNumber(true);
                break;
            }
            case 's': {
                this.parseString(false);
                break;
            }
            case 'S': {
                this.parseString(true);
                break;
            }
            case 'd': {
                this.parseDelimiter();
                break;
            }
            case 'q': {
                this.parseQuotedString();
                break;
            }
            case 'p': {
                this.parsePad();
                break;
            }
            default: {
                this.parseLiteral(c);
            }
        }
    }

    private void parseGroup(boolean array) throws FormatException {
        List saveList = this.currentList;
        this.currentList = new ArrayList();
        char expectedEnd = array ? (char)'>' : ')';
        while (this.current < this.eos && this.format.charAt(this.current) != expectedEnd) {
            this.parseFragment();
        }
        this.assertChar(expectedEnd);
        Instructions ep = this.parseProcessing();
        if (ep != null) {
            if (ep.characters != null) {
                throw this.formatException(Messages.array_can_not_have_character_group);
            }
            if (ep.rangeMax != Integer.MAX_VALUE && ep.padValue != null) {
                throw this.formatException(Messages.cannot_combine_range_upper_bound_with_pad_value);
            }
        }
        if (this.currentList.isEmpty()) {
            throw this.formatException(array ? Messages.array_can_not_be_empty : Messages.group_can_not_be_empty);
        }
        saveList.add(VersionFormat.createGroupFragment(ep, this.parseQualifier(), this.currentList.toArray(new VersionFormat.Fragment[this.currentList.size()]), array));
        this.currentList = saveList;
    }

    private int parseIntegerLiteral() throws FormatException {
        if (this.current == this.eos) {
            throw this.formatException(NLS.bind((String)Messages.premature_end_of_format_expected_0, (Object)"<integer>"));
        }
        char c = this.format.charAt(this.current);
        if (!VersionParser.isDigit(c)) {
            throw this.formatException(c, "<integer>");
        }
        int value = c - 48;
        while (++this.current < this.eos) {
            c = this.format.charAt(this.current);
            if (!VersionParser.isDigit(c)) break;
            value *= 10;
            value += c - 48;
        }
        return value;
    }

    private void parseLiteral(char c) throws FormatException {
        String value;
        switch (c) {
            case '\'': {
                value = this.parseAndConsiderEscapeUntil(c);
                break;
            }
            case ')': 
            case '*': 
            case '?': 
            case ']': 
            case '{': 
            case '}': {
                throw this.formatException(c, "<literal>");
            }
            default: {
                if (VersionParser.isLetterOrDigit(c)) {
                    throw this.formatException(c, "<literal>");
                }
                if (c < ' ') {
                    throw this.illegalControlCharacter(c);
                }
                if (c == '\\') {
                    if (this.current == this.eos) {
                        throw this.formatException(Messages.EOS_after_escape);
                    }
                    if ((c = this.format.charAt(this.current++)) < ' ') {
                        throw this.illegalControlCharacter(c);
                    }
                }
                value = new String(new char[]{c});
            }
        }
        this.currentList.add(VersionFormat.createLiteralFragment(this.parseQualifier(), value));
    }

    private int[] parseMinMax() throws FormatException {
        int max = Integer.MAX_VALUE;
        ++this.current;
        int min = this.parseIntegerLiteral();
        char c = this.format.charAt(this.current);
        if (c == '}') {
            max = min;
            if (max == 0) {
                throw this.formatException(Messages.range_max_cannot_be_zero);
            }
            ++this.current;
        } else if (c == ',' && this.current + 1 < this.eos) {
            if (this.format.charAt(++this.current) != '}') {
                max = this.parseIntegerLiteral();
                if (max == 0) {
                    throw this.formatException(Messages.range_max_cannot_be_zero);
                }
                if (max < min) {
                    throw this.formatException(Messages.range_max_cannot_be_less_then_range_min);
                }
            }
            this.assertChar('}');
        } else {
            throw this.formatException(c, "},");
        }
        return new int[]{min, max};
    }

    private void parseNumber(boolean signed) throws FormatException {
        Instructions ep = this.parseProcessing();
        if (ep != null && ep.padValue != null) {
            throw this.formatException(Messages.number_can_not_have_pad_value);
        }
        this.currentList.add(VersionFormat.createNumberFragment(ep, this.parseQualifier(), signed));
    }

    private void parsePad() throws FormatException {
        this.currentList.add(VersionFormat.createPadFragment(this.parseQualifier()));
    }

    private Instructions parseProcessing() throws FormatException {
        if (this.current >= this.eos) {
            return null;
        }
        char c = this.format.charAt(this.current);
        if (c != '=') {
            return null;
        }
        Instructions ep = new Instructions();
        do {
            ++this.current;
            this.parseProcessingInstruction(ep);
        } while (this.current < this.eos && this.format.charAt(this.current) == '=');
        return ep;
    }

    private void parseProcessingInstruction(Instructions processing) throws FormatException {
        if (this.current == this.eos) {
            throw this.formatException(Messages.premature_end_of_format);
        }
        char c = this.format.charAt(this.current);
        if (c == 'p') {
            if (processing.padValue != null) {
                throw this.formatException(Messages.pad_defined_more_then_once);
            }
            if (processing.ignore) {
                throw this.formatException(Messages.cannot_combine_ignore_with_other_instruction);
            }
            ++this.current;
            processing.padValue = this.parseRawElement();
        } else if (c == '!') {
            if (processing.ignore) {
                throw this.formatException(Messages.ignore_defined_more_then_once);
            }
            if (processing.padValue != null || processing.characters != null || processing.rangeMin != 0 || processing.rangeMax != Integer.MAX_VALUE || processing.defaultValue != null) {
                throw this.formatException(Messages.cannot_combine_ignore_with_other_instruction);
            }
            ++this.current;
            processing.ignore = true;
        } else if (c == '[') {
            if (processing.characters != null) {
                throw this.formatException(Messages.character_group_defined_more_then_once);
            }
            if (processing.ignore) {
                throw this.formatException(Messages.cannot_combine_ignore_with_other_instruction);
            }
            this.parseCharacterGroup(processing);
        } else if (c == '{') {
            if (processing.rangeMin != 0 || processing.rangeMax != Integer.MAX_VALUE) {
                throw this.formatException(Messages.range_defined_more_then_once);
            }
            if (processing.ignore) {
                throw this.formatException(Messages.cannot_combine_ignore_with_other_instruction);
            }
            int[] minMax = this.parseMinMax();
            processing.rangeMin = minMax[0];
            processing.rangeMax = minMax[1];
        } else {
            if (processing.defaultValue != null) {
                throw this.formatException(Messages.default_defined_more_then_once);
            }
            if (processing.ignore) {
                throw this.formatException(Messages.cannot_combine_ignore_with_other_instruction);
            }
            processing.defaultValue = this.parseRawElement();
        }
        this.assertChar(';');
    }

    private VersionFormat.Qualifier parseQualifier() throws FormatException {
        if (this.current >= this.eos) {
            return EXACT_ONE_QUALIFIER;
        }
        char c = this.format.charAt(this.current);
        if (c == '?') {
            ++this.current;
            return ZERO_OR_ONE_QUALIFIER;
        }
        if (c == '*') {
            ++this.current;
            return ZERO_OR_MANY_QUALIFIER;
        }
        if (c == '+') {
            ++this.current;
            return ONE_OR_MANY_QUALIFIER;
        }
        if (c != '{') {
            return EXACT_ONE_QUALIFIER;
        }
        int[] minMax = this.parseMinMax();
        int min = minMax[0];
        int max = minMax[1];
        if (min == 0) {
            if (max == 1) {
                return ZERO_OR_ONE_QUALIFIER;
            }
            if (max == Integer.MAX_VALUE) {
                return ZERO_OR_MANY_QUALIFIER;
            }
        } else if (min == 1) {
            if (max == 1) {
                return EXACT_ONE_QUALIFIER;
            }
            if (max == Integer.MAX_VALUE) {
                return ONE_OR_MANY_QUALIFIER;
            }
        }
        return new VersionFormat.Qualifier(min, max);
    }

    private void parseQuotedString() throws FormatException {
        Instructions ep = this.parseProcessing();
        if (ep != null && ep.padValue != null) {
            throw this.formatException(Messages.string_can_not_have_pad_value);
        }
        this.currentList.add(VersionFormat.createQuotedFragment(ep, this.parseQualifier()));
    }

    private void parseRaw() throws FormatException {
        Instructions ep = this.parseProcessing();
        if (ep != null && ep.padValue != null) {
            throw this.formatException(Messages.raw_element_can_not_have_pad_value);
        }
        this.currentList.add(VersionFormat.createRawFragment(ep, this.parseQualifier()));
    }

    private Comparable parseRawElement() throws FormatException {
        int[] position = new int[]{this.current};
        Comparable v = VersionParser.parseRawElement(this.format, position, this.eos);
        if (v == null) {
            throw new FormatException(NLS.bind((String)Messages.raw_element_expected_0, (Object)this.format));
        }
        this.current = position[0];
        return v;
    }

    private void parseString(boolean unlimited) throws FormatException {
        Instructions ep = this.parseProcessing();
        if (ep != null && ep.padValue != null) {
            throw this.formatException(Messages.string_can_not_have_pad_value);
        }
        this.currentList.add(VersionFormat.createStringFragment(ep, this.parseQualifier(), unlimited));
    }

    static class Instructions {
        char[] characters = null;
        Comparable defaultValue = null;
        boolean ignore = false;
        boolean inverted = false;
        Comparable padValue = null;
        int rangeMax = Integer.MAX_VALUE;
        int rangeMin = 0;

        Instructions() {
        }
    }
}

