/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.core.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class OrderedProperties
extends Dictionary
implements Map {
    LinkedHashMap propertyMap = null;

    public static OrderedProperties unmodifiableProperties(Map properties) {
        return new UnmodifiableProperties(properties);
    }

    public OrderedProperties() {
    }

    public OrderedProperties(int size) {
        this.propertyMap = new LinkedHashMap(size);
    }

    public OrderedProperties(OrderedProperties properties) {
        this.propertyMap = new LinkedHashMap(properties.size());
        this.putAll(properties);
    }

    public Object setProperty(String key, String value) {
        this.init();
        return this.propertyMap.put(key, value);
    }

    public String getProperty(String key) {
        return this.propertyMap == null ? null : this.propertyMap.get(key);
    }

    public void putAll(OrderedProperties properties) {
        this.putAll((Map)properties);
    }

    private void init() {
        if (this.propertyMap == null) {
            this.propertyMap = new LinkedHashMap();
        }
    }

    public int size() {
        return this.propertyMap == null ? 0 : this.propertyMap.size();
    }

    public boolean isEmpty() {
        return this.propertyMap == null ? true : this.propertyMap.isEmpty();
    }

    public synchronized void clear() {
        this.propertyMap = null;
    }

    public Object put(Object arg0, Object arg1) {
        this.init();
        return this.propertyMap.put(arg0, arg1);
    }

    public boolean containsKey(Object key) {
        return this.propertyMap != null ? this.propertyMap.containsKey(key) : false;
    }

    public boolean containsValue(Object value) {
        return this.propertyMap != null ? this.propertyMap.containsValue(value) : false;
    }

    public Set entrySet() {
        return this.propertyMap != null ? this.propertyMap.entrySet() : Collections.EMPTY_SET;
    }

    public Object get(Object key) {
        return this.propertyMap != null ? this.propertyMap.get(key) : null;
    }

    public Set keySet() {
        return this.propertyMap != null ? this.propertyMap.keySet() : Collections.EMPTY_SET;
    }

    public void putAll(Map arg0) {
        this.init();
        this.propertyMap.putAll(arg0);
    }

    public Object remove(Object key) {
        return this.propertyMap != null ? this.propertyMap.remove(key) : null;
    }

    public Collection values() {
        return this.propertyMap != null ? this.propertyMap.values() : Collections.EMPTY_LIST;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OrderedProperties) {
            OrderedProperties rhs = (OrderedProperties)o;
            if (rhs.propertyMap == this.propertyMap) {
                return true;
            }
            if (rhs.propertyMap == null) {
                return this.propertyMap.isEmpty();
            }
            if (this.propertyMap == null) {
                return rhs.isEmpty();
            }
            return rhs.propertyMap.equals(this.propertyMap);
        }
        if (this.propertyMap == null) {
            if (o instanceof Map) {
                return ((Map)o).isEmpty();
            }
            return false;
        }
        return this.propertyMap.equals(o);
    }

    public int hashCode() {
        return this.propertyMap == null || this.propertyMap.isEmpty() ? 0 : this.propertyMap.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.propertyMap);
        return sb.toString();
    }

    public Enumeration elements() {
        return new ElementsEnum(this);
    }

    public Enumeration keys() {
        return new KeysEnum(this);
    }

    private class ElementsEnum
    implements Enumeration {
        Iterator iterator = null;

        public ElementsEnum(OrderedProperties properties) {
            this.iterator = properties.propertyMap.values().iterator();
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }

    private class KeysEnum
    implements Enumeration {
        Iterator iterator = null;

        public KeysEnum(OrderedProperties properties) {
            this.iterator = properties.propertyMap.keySet().iterator();
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }

    private static class UnmodifiableProperties
    extends OrderedProperties {
        UnmodifiableProperties(Map properties) {
            Iterator iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                super.put(entry.getKey(), entry.getValue());
            }
        }

        public synchronized Object setProperty(String key, String value) {
            throw new UnsupportedOperationException();
        }

        public synchronized Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public synchronized Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public synchronized void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public synchronized void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

