/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.AbstractXmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.Messages;
import org.eclipse.mylyn.wikitext.core.util.FormattingXMLStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

public class DocBookDocumentBuilder
extends AbstractXmlDocumentBuilder {
    private static final Pattern PERCENTAGE = Pattern.compile("(\\d+)%");
    private static final Pattern CSS_CLASS_INLINE = Pattern.compile("(^|\\s+)inline(\\s+|$)");
    private static Set<Integer> entityReferenceToUnicode = new HashSet<Integer>();
    private String bookTitle;
    private String doctype = "<!DOCTYPE book PUBLIC \"-//OASIS//DTD DocBook XML V4.5//EN\" \"http://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd\">";
    private final Map<String, String> acronyms = new HashMap<String, String>();
    private int headingLevel = 0;
    private final Stack<BlockDescription> blockDescriptions = new Stack();
    private boolean automaticGlossary = true;

    static {
        entityReferenceToUnicode.add(215);
        entityReferenceToUnicode.add(8211);
        entityReferenceToUnicode.add(8212);
        entityReferenceToUnicode.add(8220);
        entityReferenceToUnicode.add(8221);
        entityReferenceToUnicode.add(8216);
        entityReferenceToUnicode.add(8217);
    }

    public DocBookDocumentBuilder(Writer out) {
        super(out);
    }

    public DocBookDocumentBuilder(XmlStreamWriter writer) {
        super(writer);
    }

    protected XmlStreamWriter createFormattingXmlStreamWriter(Writer out) {
        XmlStreamWriter writer = super.createXmlStreamWriter(out);
        return new FormattingXMLStreamWriter(writer){

            protected boolean preserveWhitespace(String elementName) {
                return elementName.equals("code") || elementName.startsWith("literal");
            }
        };
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
    }

    public void acronym(String text, String definition) {
        String previousDef = this.acronyms.put(text, definition);
        if (previousDef != null && previousDef.length() > definition.length()) {
            this.acronyms.put(text, previousDef);
        }
        this.writer.writeStartElement("glossterm");
        this.characters(text);
        this.writer.writeEndElement();
    }

    public void link(Attributes attributes, String href, final String text) {
        this.link(attributes, href, new ContentEmitter(){

            public void emit() {
                DocBookDocumentBuilder.this.writer.writeCharacters(text);
            }
        });
    }

    private void link(Attributes attributes, String href, ContentEmitter emitter) {
        this.ensureBlockElementsOpen();
        if (href.startsWith("#")) {
            if (href.length() > 1) {
                this.writer.writeStartElement("link");
                this.writer.writeAttribute("linkend", href.substring(1));
                emitter.emit();
                this.writer.writeEndElement();
            } else {
                emitter.emit();
            }
        } else {
            this.writer.writeStartElement("ulink");
            this.writer.writeAttribute("url", href);
            emitter.emit();
            this.writer.writeEndElement();
        }
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        int blockSize;
        String elementName;
        if (this.headingLevel == 0) {
            this.beginHeading(1, new Attributes());
            this.endHeading();
        }
        String[] elementNames = null;
        boolean allowTitle = false;
        boolean closeElementsOnBlockStart = false;
        BlockDescription previousBlock = null;
        if (!this.blockDescriptions.isEmpty()) {
            previousBlock = this.blockDescriptions.peek();
        }
        switch (type) {
            case BULLETED_LIST: {
                elementName = "itemizedlist";
                break;
            }
            case NUMERIC_LIST: {
                elementName = "orderedlist";
                break;
            }
            case DEFINITION_LIST: {
                elementName = "variablelist";
                break;
            }
            case DEFINITION_TERM: {
                BlockDescription blockDescription = this.findBlockDescription(DocumentBuilder.BlockType.DEFINITION_LIST);
                if (blockDescription.entrySize > 0) {
                    this.endBlockEntry(blockDescription);
                }
                this.openBlockEntry(blockDescription, new String[]{"varlistentry"});
                elementName = "term";
                break;
            }
            case DEFINITION_ITEM: {
                elementName = "listitem";
                elementNames = new String[]{"para"};
                closeElementsOnBlockStart = true;
                break;
            }
            case PARAGRAPH: 
            case FOOTNOTE: {
                elementName = "para";
                break;
            }
            case CODE: {
                elementName = "code";
                break;
            }
            case PREFORMATTED: {
                elementName = "literallayout";
                break;
            }
            case QUOTE: {
                elementName = "blockquote";
                break;
            }
            case LIST_ITEM: {
                elementName = "listitem";
                elementNames = new String[]{"para"};
                closeElementsOnBlockStart = true;
                break;
            }
            case TABLE: {
                elementName = "informaltable";
                break;
            }
            case TABLE_CELL_HEADER: {
                elementName = "th";
                break;
            }
            case TABLE_CELL_NORMAL: {
                elementName = "td";
                break;
            }
            case TABLE_ROW: {
                elementName = "tr";
                break;
            }
            case INFORMATION: {
                elementName = "important";
                allowTitle = true;
                break;
            }
            case NOTE: {
                elementName = "note";
                allowTitle = true;
                break;
            }
            case WARNING: {
                elementName = "warning";
                allowTitle = true;
                break;
            }
            case TIP: {
                elementName = "tip";
                allowTitle = true;
                break;
            }
            case PANEL: {
                elementName = "note";
                allowTitle = true;
                break;
            }
            case DIV: {
                elementName = null;
                break;
            }
            default: {
                throw new IllegalStateException(type.name());
            }
        }
        if (elementName != null) {
            blockSize = 1;
            if (previousBlock != null && previousBlock.closeElementsOnBlockStart) {
                this.endBlockEntry(previousBlock);
            }
            this.writer.writeStartElement(elementName);
            this.applyAttributes(attributes);
            if (elementNames != null) {
                String[] stringArray = elementNames;
                int n = elementNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    this.writer.writeStartElement(name);
                    ++n2;
                }
            }
            if (allowTitle && attributes.getTitle() != null) {
                this.writer.writeStartElement("title");
                this.writer.writeCharacters(attributes.getTitle());
                this.writer.writeEndElement();
            }
        } else {
            blockSize = 0;
        }
        this.blockDescriptions.push(new BlockDescription(type, blockSize, elementNames, closeElementsOnBlockStart));
    }

    public void endBlock() {
        BlockDescription blockDescription = this.blockDescriptions.pop();
        int size = blockDescription.size + blockDescription.entrySize;
        int x = 0;
        while (x < size) {
            this.writer.writeEndElement();
            ++x;
        }
    }

    private void endBlockEntry(BlockDescription blockDescription) {
        int x = 0;
        while (x < blockDescription.entrySize) {
            this.writer.writeEndElement();
            ++x;
        }
        blockDescription.entrySize = 0;
    }

    private void openBlockEntry(BlockDescription blockDescription, String[] entry) {
        String[] stringArray = entry;
        int n = entry.length;
        int n2 = 0;
        while (n2 < n) {
            String ent = stringArray[n2];
            this.writer.writeStartElement(ent);
            ++n2;
        }
        blockDescription.entrySize += entry.length;
    }

    public void beginHeading(int level, Attributes attributes) {
        this.closeSections(Math.max(level - 1, 0));
        while (this.headingLevel < level) {
            ++this.headingLevel;
            this.writer.writeStartElement(this.headingLevel == 1 ? "chapter" : "section");
            if (attributes == null) continue;
            this.applyAttributes(attributes);
            attributes = null;
        }
        this.writer.writeStartElement("title");
    }

    public void endHeading() {
        this.writer.writeEndElement();
    }

    public void beginDocument() {
        this.baseInHead = false;
        this.writer.writeStartDocument();
        this.writer.writeDTD(this.doctype);
        this.writer.writeStartElement("book");
        this.writer.writeStartElement("title");
        if (this.bookTitle != null) {
            this.writer.writeCharacters(this.bookTitle);
        }
        this.writer.writeEndElement();
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.ensureBlockElementsOpen();
        switch (type) {
            case STRONG: 
            case BOLD: {
                this.writer.writeStartElement("emphasis");
                this.writer.writeAttribute("role", "bold");
                break;
            }
            case CITATION: {
                this.writer.writeStartElement("citation");
                break;
            }
            case CODE: {
                this.writer.writeStartElement("code");
                break;
            }
            case DELETED: {
                this.writer.writeStartElement("emphasis");
                this.writer.writeAttribute("role", "del");
                break;
            }
            case EMPHASIS: {
                this.writer.writeStartElement("emphasis");
                break;
            }
            case INSERTED: {
                this.writer.writeStartElement("emphasis");
                this.writer.writeAttribute("role", "ins");
                break;
            }
            case UNDERLINED: {
                this.writer.writeStartElement("emphasis");
                this.writer.writeAttribute("role", "underline");
                break;
            }
            case ITALIC: {
                this.writer.writeStartElement("emphasis");
                this.writer.writeAttribute("role", "italic");
                break;
            }
            case QUOTE: {
                this.writer.writeStartElement("quote");
                break;
            }
            case SPAN: {
                this.writer.writeStartElement("phrase");
                break;
            }
            case SUBSCRIPT: {
                this.writer.writeStartElement("subscript");
                break;
            }
            case SUPERSCRIPT: {
                this.writer.writeStartElement("superscript");
                break;
            }
            case MONOSPACE: {
                this.writer.writeStartElement("literal");
                break;
            }
            default: {
                Logger.getLogger(DocBookDocumentBuilder.class.getName()).warning("No docbook mapping for " + (Object)((Object)type));
                this.writer.writeStartElement("phrase");
            }
        }
        this.applyAttributes(attributes);
    }

    private void applyAttributes(Attributes attributes) {
        if (attributes.getId() != null) {
            this.writer.writeAttribute("id", attributes.getId());
        }
    }

    public void endDocument() {
        this.closeSections(0);
        this.writeGlossaryAppendix();
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.acronyms.clear();
    }

    private void closeSections(int toLevel) {
        if (toLevel < 0) {
            toLevel = 0;
        }
        while (this.headingLevel > toLevel) {
            this.writer.writeEndElement();
            --this.headingLevel;
        }
    }

    private void writeGlossaryAppendix() {
        if (!this.acronyms.isEmpty() && this.automaticGlossary) {
            this.writer.writeStartElement("appendix");
            this.writer.writeAttribute("id", "glossary");
            this.writer.writeStartElement("title");
            this.writer.writeAttribute("id", "glossary-end");
            this.writer.writeCharacters(Messages.getString("DocBookDocumentBuilder.0"));
            this.writer.writeEndElement();
            this.writer.writeStartElement("glosslist");
            for (Map.Entry<String, String> glossEntry : new TreeMap<String, String>(this.acronyms).entrySet()) {
                this.writer.writeStartElement("glossentry");
                this.writer.writeStartElement("glossterm");
                this.writer.writeCharacters(glossEntry.getKey());
                this.writer.writeEndElement();
                this.writer.writeStartElement("glossdef");
                this.writer.writeStartElement("para");
                this.writer.writeCharacters(glossEntry.getValue());
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        }
    }

    public void endSpan() {
        this.writer.writeEndElement();
    }

    public void characters(String text) {
        this.ensureBlockElementsOpen();
        super.characters(text);
    }

    public void charactersUnescaped(String literal) {
        this.ensureBlockElementsOpen();
        this.writer.writeLiteral(literal);
    }

    private void ensureBlockElementsOpen() {
        if (!this.blockDescriptions.isEmpty()) {
            BlockDescription blockDescription = this.blockDescriptions.peek();
            if (blockDescription.entrySize == 0 && blockDescription.nestedElementNames != null) {
                this.openBlockEntry(blockDescription, blockDescription.nestedElementNames);
            }
        }
    }

    public void entityReference(String entity) {
        this.ensureBlockElementsOpen();
        if (entity.startsWith("#")) {
            int unicodeValue;
            String numeric = entity.substring(1);
            int base = 10;
            if (numeric.startsWith("x")) {
                numeric = entity.substring(1);
                base = 16;
            }
            if (entityReferenceToUnicode.contains(unicodeValue = Integer.parseInt(numeric, base))) {
                this.writer.writeCharacters("" + (char)unicodeValue);
                return;
            }
        }
        this.writer.writeEntityRef(entity);
    }

    public void image(Attributes attributes, String url) {
        this.ensureBlockElementsOpen();
        String cssClass = attributes.getCssClass();
        boolean inlined = false;
        if (cssClass != null && CSS_CLASS_INLINE.matcher(cssClass).find()) {
            inlined = true;
        }
        this.emitImage(attributes, url, inlined);
    }

    private void emitImage(Attributes attributes, String url, boolean inline) {
        this.ensureBlockElementsOpen();
        this.writer.writeStartElement(inline ? "inlinemediaobject" : "mediaobject");
        this.applyAttributes(attributes);
        this.writer.writeStartElement("imageobject");
        this.writer.writeEmptyElement("imagedata");
        this.writer.writeAttribute("fileref", this.makeUrlAbsolute(url));
        String cssStyle = attributes.getCssStyle();
        if (cssStyle != null) {
            String width = null;
            String depth = null;
            Iterator<CssRule> ruleIterator = new CssParser().createRuleIterator(cssStyle);
            while (ruleIterator.hasNext()) {
                CssRule rule = ruleIterator.next();
                if ("width".equals(rule.name)) {
                    width = rule.value;
                    continue;
                }
                if (!"height".equals(rule.name)) continue;
                depth = rule.value;
            }
            if (width != null) {
                Matcher matcher = PERCENTAGE.matcher(width);
                if (matcher.matches()) {
                    this.writer.writeAttribute("scale", matcher.group(1));
                } else {
                    this.writer.writeAttribute("width", width);
                    if (depth != null) {
                        this.writer.writeAttribute("depth", depth);
                    }
                }
            }
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    public void imageLink(Attributes linkAttributes, final Attributes imageAttributes, String href, final String imageUrl) {
        this.link(linkAttributes, href, new ContentEmitter(){

            public void emit() {
                DocBookDocumentBuilder.this.emitImage(imageAttributes, imageUrl, true);
            }
        });
    }

    public void lineBreak() {
        this.ensureBlockElementsOpen();
        this.characters("\n");
    }

    private BlockDescription findBlockDescription(DocumentBuilder.BlockType type) {
        int x = this.blockDescriptions.size() - 1;
        while (x >= 0) {
            BlockDescription blockDescription = (BlockDescription)this.blockDescriptions.get(x);
            if (blockDescription.type == type) {
                return blockDescription;
            }
            --x;
        }
        return null;
    }

    public boolean isAutomaticGlossary() {
        return this.automaticGlossary;
    }

    public void setAutomaticGlossary(boolean automaticGlossary) {
        this.automaticGlossary = automaticGlossary;
    }

    private static class BlockDescription {
        DocumentBuilder.BlockType type;
        int size;
        int entrySize;
        final String[] nestedElementNames;
        final boolean closeElementsOnBlockStart;

        public BlockDescription(DocumentBuilder.BlockType type, int size, String[] nestedElementNames, boolean closeElementsOnBlockStart) {
            this.size = size;
            this.entrySize = nestedElementNames == null ? 0 : nestedElementNames.length;
            this.type = type;
            this.nestedElementNames = nestedElementNames;
            this.closeElementsOnBlockStart = closeElementsOnBlockStart;
        }
    }

    private static interface ContentEmitter {
        public void emit();
    }
}

