/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
implements BundleActivator {
    public static final String ID = "org.eclipse.equinox.p2.transformer";
    private static BundleContext bundleContext;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        Bundle bundle = Activator.getBundle("org.eclipse.equinox.p2.exemplarysetup");
        if (bundle == null) {
            throw new ProvisionException(Messages.unable_to_start_exemplarysetup);
        }
        bundle.start(1);
    }

    public void stop(BundleContext context) throws Exception {
        bundleContext = null;
    }

    public static URI getURI(String spec) {
        if (spec == null) {
            return null;
        }
        try {
            return URIUtil.fromString((String)spec);
        }
        catch (URISyntaxException e) {
            LogHelper.log((IStatus)new Status(2, ID, NLS.bind((String)Messages.unable_to_process_uri, (Object)spec), (Throwable)e));
            return null;
        }
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager() throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = Activator.getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(Messages.no_artifactRepo_manager);
        }
        return manager;
    }

    static IProfileRegistry getProfileRegistry() throws ProvisionException {
        IProfileRegistry registry;
        BundleContext bundleContext = Activator.getBundleContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((registry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(Messages.no_profile_registry);
        }
        return registry;
    }

    public static synchronized Bundle getBundle(String symbolicName) throws ProvisionException {
        PackageAdmin packageAdmin;
        BundleContext bundleContext = Activator.getBundleContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((packageAdmin = (PackageAdmin)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(Messages.no_package_admin);
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public static IMetadataRepositoryManager getMetadataRepositoryManager() throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = Activator.getBundleContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(Messages.no_metadataRepo_manager);
        }
        return manager;
    }
}

