/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.block;

import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class PreformattedBlock
extends Block {
    private int blockLineCount = 0;

    public boolean canStart(String line, int lineOffset) {
        return lineOffset == 0 && line.length() > 0 && line.charAt(0) == ' ';
    }

    public int processLineContent(String line, int offset) {
        if (this.markupLanguage.isEmptyLine(line) || offset == 0 && line.charAt(0) != ' ') {
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount++ == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
        }
        this.builder.characters(line.substring(1));
        this.builder.characters("\n");
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

