/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.BrowserDescriptor;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.IBrowserDescriptorWorkingCopy;
import org.eclipse.ui.internal.browser.IBrowserExt;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;

public class WebBrowserUtil {
    private static final String BROWSER_PACKAGE_NAME = "org.eclipse.swt.browser.Browser";
    public static Boolean isInternalBrowserOperational;
    private static final char STYLE_SEP = '-';
    private static final int DEFAULT_STYLE = 6;

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("win") >= 0;
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("lin") >= 0;
    }

    public static void openError(String message) {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Shell shell = d.getActiveShell();
        MessageDialog.openError((Shell)shell, (String)Messages.errorDialogTitle, (String)message);
    }

    public static void openMessage(String message) {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Shell shell = d.getActiveShell();
        MessageDialog.openInformation((Shell)shell, (String)Messages.searchingTaskName, (String)message);
    }

    public static boolean canUseInternalWebBrowser() {
        if (isInternalBrowserOperational != null) {
            return isInternalBrowserOperational;
        }
        try {
            Class.forName(BROWSER_PACKAGE_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            isInternalBrowserOperational = new Boolean(false);
            return false;
        }
        Shell shell = null;
        try {
            shell = new Shell(PlatformUI.getWorkbench().getDisplay());
            new Browser((Composite)shell, 0);
            isInternalBrowserOperational = new Boolean(true);
            return true;
        }
        catch (Throwable t) {
            StringBuffer message = new StringBuffer("Internal browser is not available");
            message.append(t.getMessage() == null ? "." : ": " + t.getMessage());
            WebBrowserUIPlugin.getInstance().getLog().log((IStatus)new Status(2, "org.eclipse.ui.browser", 0, message.toString(), null));
            isInternalBrowserOperational = new Boolean(false);
            return false;
        }
        finally {
            if (shell != null) {
                shell.dispose();
            }
        }
    }

    public static boolean canUseSystemBrowser() {
        if ("solaris".equals(Platform.getOS())) {
            return false;
        }
        return Program.findProgram((String)"html") != null;
    }

    public static List getExternalBrowserPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iterator = BrowserManager.getInstance().getWebBrowsers().iterator();
        while (iterator.hasNext()) {
            IBrowserDescriptor wb = (IBrowserDescriptor)iterator.next();
            if (wb == null || wb.getLocation() == null) continue;
            paths.add(wb.getLocation().toLowerCase());
        }
        return paths;
    }

    public static void addFoundBrowsers(List list) {
        List paths = WebBrowserUtil.getExternalBrowserPaths();
        String os = Platform.getOS();
        File[] roots = WebBrowserUtil.getUsableDrives(File.listRoots());
        int rootSize = roots.length;
        IBrowserExt[] browsers = WebBrowserUIPlugin.getBrowsers();
        int size = browsers.length;
        int i = 0;
        while (i < size) {
            if (browsers[i].getDefaultLocations() != null && browsers[i].getOS().toLowerCase().indexOf(os) >= 0) {
                int k = 0;
                while (k < rootSize) {
                    int size2 = browsers[i].getDefaultLocations().length;
                    int j = 0;
                    while (j < size2) {
                        String location = browsers[i].getDefaultLocations()[j];
                        try {
                            File f = new File(roots[k], location);
                            if (!paths.contains(f.getAbsolutePath().toLowerCase()) && f.exists()) {
                                BrowserDescriptor browser = new BrowserDescriptor();
                                browser.name = browsers[i].getName();
                                browser.location = f.getAbsolutePath();
                                browser.parameters = browsers[i].getParameters();
                                list.add(browser);
                                j += size2;
                            }
                        }
                        catch (Exception exception) {}
                        ++j;
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    private static File[] getUsableDrives(File[] roots) {
        if (!Platform.getOS().equals("win32")) {
            return roots;
        }
        ArrayList<File> list = new ArrayList<File>();
        int i = 0;
        while (i < roots.length) {
            String path = roots[i].getAbsolutePath();
            if (path == null || !path.toLowerCase().startsWith("a:") && !path.toLowerCase().startsWith("b:")) {
                list.add(roots[i]);
            }
            ++i;
        }
        return list.toArray(new File[list.size()]);
    }

    public static IBrowserDescriptorWorkingCopy createExternalBrowser(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        String executable = file.getName();
        IBrowserExt[] browsers = WebBrowserUIPlugin.getBrowsers();
        int size = browsers.length;
        int i = 0;
        while (i < size) {
            if (executable.equals(browsers[i].getExecutable())) {
                IBrowserDescriptorWorkingCopy browser = BrowserManager.getInstance().createExternalWebBrowser();
                browser.setName(browsers[i].getName());
                browser.setLocation(file.getAbsolutePath());
                browser.setParameters(browsers[i].getParameters());
                return browser;
            }
            ++i;
        }
        return null;
    }

    public static String encodeStyle(String browserId, int style) {
        return String.valueOf(browserId) + '-' + style;
    }

    public static int decodeStyle(String secondaryId) {
        int sep;
        if (secondaryId != null && (sep = secondaryId.lastIndexOf(45)) != -1) {
            String stoken = secondaryId.substring(sep + 1);
            try {
                return Integer.parseInt(stoken);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 6;
    }

    public static String decodeId(String encodedId) {
        int sep = encodedId.lastIndexOf(45);
        if (sep != -1) {
            return encodedId.substring(0, sep);
        }
        return encodedId;
    }

    public static String createParameterString(String parameters, String urlText) {
        int urlIndex;
        String params = parameters;
        String url = urlText;
        if (url == null) {
            url = "";
        }
        if (params == null) {
            params = "";
        }
        if ((urlIndex = params.indexOf("%URL%")) >= 0) {
            params = String.valueOf(params.substring(0, urlIndex)) + url + params.substring(urlIndex + "%URL%".length());
        } else {
            if (params.length() != 0 && !params.endsWith(" ")) {
                params = String.valueOf(params) + " ";
            }
            params = String.valueOf(params) + url;
        }
        return params;
    }
}

