/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.KeywordsDialog;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BugzillaKeywordAttributeEditor
extends AbstractAttributeEditor {
    private Text keywordsText;

    public BugzillaKeywordAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite keywordComposite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 1;
        keywordComposite.setLayout((Layout)layout);
        this.keywordsText = toolkit.createText(keywordComposite, this.getTaskAttribute().getValue());
        GridData keywordsData = new GridData(768);
        this.keywordsText.setLayoutData((Object)keywordsData);
        this.keywordsText.setEditable(false);
        Button changeKeywordsButton = toolkit.createButton(keywordComposite, Messages.BugzillaKeywordAttributeEditor_Edit_, 0x800000);
        GridData keyWordsButtonData = new GridData();
        changeKeywordsButton.setLayoutData((Object)keyWordsButtonData);
        changeKeywordsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String keywords = BugzillaKeywordAttributeEditor.this.getTaskAttribute().getValue();
                Shell shell = null;
                shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(PlatformUI.getWorkbench().getDisplay());
                List<String> validKeywords = new ArrayList<String>();
                try {
                    validKeywords = BugzillaCorePlugin.getRepositoryConfiguration((TaskRepository)BugzillaKeywordAttributeEditor.this.getModel().getTaskRepository(), (boolean)false, (IProgressMonitor)new NullProgressMonitor()).getKeywords();
                }
                catch (Exception exception) {}
                KeywordsDialog keywordsDialog = new KeywordsDialog(shell, keywords, validKeywords);
                int responseCode = keywordsDialog.open();
                String newKeywords = keywordsDialog.getSelectedKeywordsString();
                if (responseCode != 0 || keywords == null) {
                    return;
                }
                BugzillaKeywordAttributeEditor.this.keywordsText.setText(newKeywords);
                BugzillaKeywordAttributeEditor.this.getAttributeMapper().setValue(BugzillaKeywordAttributeEditor.this.getTaskAttribute(), newKeywords);
                BugzillaKeywordAttributeEditor.this.attributeChanged();
            }
        });
        this.setControl((Control)keywordComposite);
    }

    protected void decorateIncoming(Color color) {
        if (this.keywordsText != null && !this.keywordsText.isDisposed()) {
            this.keywordsText.setBackground(color);
        }
    }
}

