/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.codemanipulation.AddDelegateMethodsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class AddDelegateMethodsAction
extends SelectionDispatchAction {
    private static final String DIALOG_TITLE = ActionMessages.AddDelegateMethodsAction_error_title;
    private CompilationUnitEditor fEditor;
    static /* synthetic */ Class class$0;

    private static boolean hasPrimitiveType(IField field) throws JavaModelException {
        String signature = field.getTypeSignature();
        char first = Signature.getElementType((String)signature).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private static boolean isArray(IField field) throws JavaModelException {
        return Signature.getArrayCount((String)field.getTypeSignature()) > 0;
    }

    public AddDelegateMethodsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(editor) != null);
    }

    public AddDelegateMethodsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.AddDelegateMethodsAction_label);
        this.setDescription(ActionMessages.AddDelegateMethodsAction_description);
        this.setToolTipText(ActionMessages.AddDelegateMethodsAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.add_delegate_methods_action");
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (this.getSelectedFields(selection) != null) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && !type.isInterface() && !type.isAnonymous();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    private boolean canRunOn(IField[] fields) throws JavaModelException {
        if (fields == null || fields.length == 0) {
            return false;
        }
        int count = 0;
        int index = 0;
        while (index < fields.length) {
            if (!JdtFlags.isEnum((IMember)fields[index]) && !AddDelegateMethodsAction.hasPrimitiveType(fields[index]) || AddDelegateMethodsAction.isArray(fields[index])) {
                ++count;
            }
            ++index;
        }
        if (count == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddDelegateMethodsAction_not_applicable);
        }
        return count > 0;
    }

    private boolean canRunOn(IType type) throws JavaModelException {
        if (type == null || type.getCompilationUnit() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddDelegateMethodsAction_not_in_source_file);
            return false;
        }
        if (type.isAnnotation()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddDelegateMethodsAction_annotation_not_applicable);
            return false;
        }
        if (type.isInterface()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddDelegateMethodsAction_interface_not_applicable);
            return false;
        }
        return this.canRunOn(type.getFields());
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        if (elements.size() > 0) {
            IField[] result = new IField[elements.size()];
            ICompilationUnit unit = null;
            int index = 0;
            while (index < elements.size()) {
                IField field;
                block7: {
                    if (elements.get(index) instanceof IField) {
                        field = (IField)elements.get(index);
                        if (index == 0 ? (unit = field.getCompilationUnit()) == null : !unit.equals(field.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            IType type = field.getDeclaringType();
                            if (type.isInterface() || type.isAnonymous()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException exception) {
                            JavaPlugin.log(exception);
                            return null;
                        }
                    }
                    return null;
                }
                result[index] = field;
                ++index;
            }
            return result;
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        try {
            IField[] selectedFields = this.getSelectedFields(selection);
            if (this.canRunOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                this.run(JavaElementUtil.getMainType((ICompilationUnit)firstElement), new IField[0], false);
            } else if (!(firstElement instanceof IField)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddDelegateMethodsAction_not_applicable);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.AddDelegateMethodsAction_error_actionfailed);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IType type;
            if (!ActionUtil.isProcessable(this.fEditor)) {
                return;
            }
            IJavaElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, true);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, true);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null && type.getFields().length > 0) {
                this.run(type, new IField[0], true);
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddDelegateMethodsAction_not_applicable);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.AddDelegateMethodsAction_error_actionfailed);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.AddDelegateMethodsAction_error_actionfailed);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void run(IType type, IField[] preselected, boolean editor) throws CoreException {
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), DIALOG_TITLE, editor)) {
            return;
        }
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)type)) {
            return;
        }
        if (!this.canRunOn(type)) {
            return;
        }
        this.showUI(type, preselected);
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }

    private void showUI(IType type, IField[] fields) {
        try {
            CompilationUnit astRoot = SharedASTProvider.getAST((ITypeRoot)type.getCompilationUnit(), SharedASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
            AddDelegateMethodsContentProvider provider = new AddDelegateMethodsContentProvider(astRoot, type, fields);
            AddDelegateMethodsDialog dialog = new AddDelegateMethodsDialog(this.getShell(), (ILabelProvider)new AddDelegateMethodsLabelProvider(), provider, this.fEditor, type, false);
            dialog.setValidator(new AddDelegateMethodsActionStatusValidator(provider.getCount()));
            AddDelegateMethodsViewerComparator comparator = new AddDelegateMethodsViewerComparator();
            dialog.setComparator(comparator);
            dialog.setInput(new Object());
            dialog.setContainerMode(true);
            dialog.setMessage(ActionMessages.AddDelegateMethodsAction_message);
            dialog.setTitle(ActionMessages.AddDelegateMethodsAction_title);
            Object[] expanded = provider.getExpandedElements();
            if (expanded.length > 0) {
                dialog.setExpandedElements(expanded);
            } else {
                Object[] elements = provider.getElements(null);
                if (elements.length > 0) {
                    comparator.sort(null, elements);
                    Object[] expand = new Object[]{elements[0]};
                    dialog.setExpandedElements(expand);
                }
            }
            dialog.setInitialSelections(provider.getInitiallySelectedElements());
            dialog.setSize(60, 18);
            int result = dialog.open();
            if (result == 0) {
                Object[] object = dialog.getResult();
                if (object == null) {
                    this.notifyResult(false);
                    return;
                }
                ArrayList<Object> tuples = new ArrayList<Object>(object.length);
                int index = 0;
                while (index < object.length) {
                    if (object[index] instanceof AddDelegateMethodsOperation.DelegateEntry) {
                        tuples.add(object[index]);
                    }
                    ++index;
                }
                IEditorPart part = JavaUI.openInEditor((IJavaElement)type);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IRewriteTarget target = (IRewriteTarget)part.getAdapter((Class)clazz);
                try {
                    if (target != null) {
                        target.beginCompoundChange();
                    }
                    CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject());
                    settings.createComments = dialog.getGenerateComment();
                    AddDelegateMethodsOperation.DelegateEntry[] methodToDelegate = tuples.toArray(new AddDelegateMethodsOperation.DelegateEntry[tuples.size()]);
                    AddDelegateMethodsOperation operation = new AddDelegateMethodsOperation(astRoot, methodToDelegate, dialog.getElementPosition(), settings, true, false);
                    Object context = JavaPlugin.getActiveWorkbenchWindow();
                    if (context == null) {
                        context = new BusyIndicatorRunnableContext();
                    }
                    try {
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation, operation.getSchedulingRule()), operation.getSchedulingRule());
                    }
                    catch (InterruptedException interruptedException) {}
                }
                finally {
                    if (target != null) {
                        target.endCompoundChange();
                    }
                }
            }
            this.notifyResult(result == 0);
        }
        catch (CoreException exception) {
            ExceptionHandler.handle(exception, DIALOG_TITLE, ActionMessages.AddDelegateMethodsAction_error_actionfailed);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, DIALOG_TITLE, ActionMessages.AddDelegateMethodsAction_error_actionfailed);
        }
    }

    private static class AddDelegateMethodsActionStatusValidator
    implements ISelectionStatusValidator {
        private static int fEntries;

        AddDelegateMethodsActionStatusValidator(int entries) {
            fEntries = entries;
        }

        public IStatus validate(Object[] selection) {
            StatusInfo info = new StatusInfo();
            int count = 0;
            if (selection != null && selection.length > 0) {
                HashSet<String> signatures = new HashSet<String>(selection.length);
                int index = 0;
                while (index < selection.length) {
                    if (selection[index] instanceof AddDelegateMethodsOperation.DelegateEntry) {
                        AddDelegateMethodsOperation.DelegateEntry delegateEntry = (AddDelegateMethodsOperation.DelegateEntry)selection[index];
                        if (!signatures.add(this.getSignature(delegateEntry.delegateMethod))) {
                            return new StatusInfo(4, ActionMessages.AddDelegateMethodsAction_duplicate_methods);
                        }
                        ++count;
                    }
                    ++index;
                }
            }
            info = new StatusInfo(1, Messages.format(ActionMessages.AddDelegateMethodsAction_selectioninfo_more, new Object[]{String.valueOf(count), String.valueOf(fEntries)}));
            return info;
        }

        private String getSignature(IMethodBinding binding) {
            StringBuffer buf = new StringBuffer(binding.getName()).append('(');
            ITypeBinding[] parameterTypes = binding.getParameterTypes();
            int i = 0;
            while (i < parameterTypes.length) {
                buf.append(parameterTypes[i].getTypeDeclaration().getName());
                ++i;
            }
            buf.append(')');
            return buf.toString();
        }
    }

    private static class AddDelegateMethodsContentProvider
    implements ITreeContentProvider {
        private AddDelegateMethodsOperation.DelegateEntry[] fDelegateEntries;
        private IVariableBinding[] fExpanded = new IVariableBinding[0];

        AddDelegateMethodsContentProvider(CompilationUnit astRoot, IType type, IField[] fields) throws JavaModelException {
            ITypeBinding binding = ASTNodes.getTypeBinding(astRoot, type);
            if (binding != null) {
                this.fDelegateEntries = StubUtility2.getDelegatableMethods(binding);
                ArrayList<IVariableBinding> expanded = new ArrayList<IVariableBinding>();
                int index = 0;
                while (index < fields.length) {
                    IVariableBinding variableBinding;
                    VariableDeclarationFragment fragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(fields[index], astRoot);
                    if (fragment != null && (variableBinding = fragment.resolveBinding()) != null) {
                        expanded.add(variableBinding);
                    }
                    ++index;
                }
                this.fExpanded = expanded.toArray(new IVariableBinding[expanded.size()]);
            }
        }

        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IVariableBinding) {
                ArrayList<AddDelegateMethodsOperation.DelegateEntry> result = new ArrayList<AddDelegateMethodsOperation.DelegateEntry>();
                int i = 0;
                while (i < this.fDelegateEntries.length) {
                    if (element == this.fDelegateEntries[i].field) {
                        result.add(this.fDelegateEntries[i]);
                    }
                    ++i;
                }
                return result.toArray();
            }
            return null;
        }

        public int getCount() {
            return this.fDelegateEntries.length;
        }

        public Object[] getElements(Object inputElement) {
            HashSet<IVariableBinding> result = new HashSet<IVariableBinding>();
            int i = 0;
            while (i < this.fDelegateEntries.length) {
                AddDelegateMethodsOperation.DelegateEntry curr = this.fDelegateEntries[i];
                result.add(curr.field);
                ++i;
            }
            return result.toArray();
        }

        public IVariableBinding[] getExpandedElements() {
            return this.fExpanded;
        }

        public IVariableBinding[] getInitiallySelectedElements() {
            return this.fExpanded;
        }

        public Object getParent(Object element) {
            if (element instanceof AddDelegateMethodsOperation.DelegateEntry) {
                return ((AddDelegateMethodsOperation.DelegateEntry)element).field;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IVariableBinding;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class AddDelegateMethodsDialog
    extends SourceActionDialog {
        public AddDelegateMethodsDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, CompilationUnitEditor editor, IType type, boolean isConstructor) throws JavaModelException {
            super(parent, labelProvider, contentProvider, editor, type, isConstructor);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.ui.add_delegate_methods_selection_dialog_context");
        }

        protected Control createLinkControl(Composite composite) {
            Link link = new Link(composite, 64);
            link.setText(ActionMessages.AddDelegateMethodsAction_template_link_message);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ AddDelegateMethodsDialog this$1;
                {
                    this.this$1 = addDelegateMethodsDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    AddDelegateMethodsDialog.access$0(this.this$1, "org.eclipse.jdt.ui.text.codetemplates.overridecomment");
                }
            });
            link.setToolTipText(ActionMessages.AddDelegateMethodsAction_template_link_tooltip);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.widthHint = this.convertWidthInCharsToPixels(40);
            link.setLayoutData((Object)gridData);
            return link;
        }

        static /* synthetic */ void access$0(AddDelegateMethodsDialog addDelegateMethodsDialog, String string) {
            addDelegateMethodsDialog.openCodeTempatePage(string);
        }
    }

    private static class AddDelegateMethodsLabelProvider
    extends BindingLabelProvider {
        private AddDelegateMethodsLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof AddDelegateMethodsOperation.DelegateEntry) {
                AddDelegateMethodsOperation.DelegateEntry delegateEntry = (AddDelegateMethodsOperation.DelegateEntry)element;
                return super.getImage(delegateEntry.delegateMethod);
            }
            if (element instanceof IVariableBinding) {
                return super.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof AddDelegateMethodsOperation.DelegateEntry) {
                AddDelegateMethodsOperation.DelegateEntry delegateEntry = (AddDelegateMethodsOperation.DelegateEntry)element;
                return super.getText(delegateEntry.delegateMethod);
            }
            if (element instanceof IVariableBinding) {
                return super.getText(element);
            }
            return null;
        }
    }

    private static class AddDelegateMethodsViewerComparator
    extends ViewerComparator {
        private AddDelegateMethodsViewerComparator() {
        }

        public int category(Object element) {
            if (element instanceof AddDelegateMethodsOperation.DelegateEntry) {
                return 0;
            }
            return 1;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            if (o1 instanceof AddDelegateMethodsOperation.DelegateEntry && o2 instanceof AddDelegateMethodsOperation.DelegateEntry) {
                String bindingLabel1 = BindingLabelProvider.getBindingLabel((IBinding)((AddDelegateMethodsOperation.DelegateEntry)o1).delegateMethod, BindingLabelProvider.DEFAULT_TEXTFLAGS);
                String bindingLabel2 = BindingLabelProvider.getBindingLabel((IBinding)((AddDelegateMethodsOperation.DelegateEntry)o2).delegateMethod, BindingLabelProvider.DEFAULT_TEXTFLAGS);
                return this.getComparator().compare(bindingLabel1, bindingLabel2);
            }
            if (o1 instanceof IVariableBinding && o2 instanceof IVariableBinding) {
                return this.getComparator().compare(((IVariableBinding)o1).getName(), ((IVariableBinding)o2).getName());
            }
            return 0;
        }
    }
}

