/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesView;
import org.eclipse.mylyn.internal.tasks.ui.wizards.EditRepositoryWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.MultiRepositoryAwareWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewLocalTaskWizard;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.wizards.TaskRepositoryWizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TasksUiUtil {
    public static final int FLAG_NO_RICH_EDITOR = 131072;

    public static ITask createOutgoingNewTask(String connectorKind, String repositoryUrl) {
        Assert.isNotNull((Object)connectorKind);
        LocalTask task = TasksUiInternal.createNewLocalTask(null);
        task.setAttribute("outgoingNewConnectorKind", connectorKind);
        task.setAttribute("outgoingNewRepositoryUrl", repositoryUrl);
        task.setSynchronizationState(ITask.SynchronizationState.OUTGOING_NEW);
        return task;
    }

    public static boolean isOutgoingNewTask(ITask task, String connectorKind) {
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)connectorKind);
        return connectorKind.equals(task.getAttribute("outgoingNewConnectorKind"));
    }

    public static TaskRepository getOutgoingNewTaskRepository(ITask task) {
        Assert.isNotNull((Object)task);
        String connectorKind = task.getAttribute("outgoingNewConnectorKind");
        String repositoryUrl = task.getAttribute("outgoingNewRepositoryUrl");
        if (connectorKind != null && repositoryUrl != null) {
            return TasksUi.getRepositoryManager().getRepository(connectorKind, repositoryUrl);
        }
        return null;
    }

    public static TaskRepository getSelectedRepository() {
        return TasksUiUtil.getSelectedRepository(null);
    }

    public static TaskRepository getSelectedRepository(StructuredViewer viewer) {
        IWorkbenchWindow window;
        ISelection windowSelection;
        IStructuredSelection selection = null;
        if (viewer != null) {
            selection = (IStructuredSelection)viewer.getSelection();
        }
        if ((selection == null || selection.isEmpty()) && (windowSelection = (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getSelectionService().getSelection()) instanceof IStructuredSelection) {
            selection = (IStructuredSelection)windowSelection;
        }
        if (selection == null) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof TaskRepository) {
            return (TaskRepository)selection.getFirstElement();
        }
        if (element instanceof IRepositoryQuery) {
            IRepositoryQuery query = (IRepositoryQuery)element;
            return TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), query.getRepositoryUrl());
        }
        if (element instanceof ITask) {
            ITask task = (ITask)element;
            return TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return TasksUiPlugin.getDefault().getRepositoryForResource(resource);
        }
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null) {
                return TasksUiPlugin.getDefault().getRepositoryForResource(resource);
            }
            ITask task = (ITask)adaptable.getAdapter(AbstractTask.class);
            if (task != null) {
                ITask rtask = task;
                return TasksUi.getRepositoryManager().getRepository(rtask.getConnectorKind(), rtask.getRepositoryUrl());
            }
        }
        return null;
    }

    private static String getTaskEditorId(ITask task) {
        ITask repositoryTask;
        AbstractRepositoryConnectorUi repositoryUi;
        String customTaskEditorId;
        String taskEditorId = "org.eclipse.mylyn.tasks.ui.editors.task";
        if (task != null && (customTaskEditorId = (repositoryUi = TasksUiPlugin.getConnectorUi((repositoryTask = task).getConnectorKind())).getTaskEditorId(repositoryTask)) != null) {
            taskEditorId = customTaskEditorId;
        }
        return taskEditorId;
    }

    public static IEditorPart openEditor(IEditorInput input, String editorId, IWorkbenchPage page) {
        IWorkbenchWindow window;
        if (page == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            page = window.getActivePage();
        }
        if (page == null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to open editor for \"" + input + "\": no active workbench window"));
            return null;
        }
        try {
            return page.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Open for editor failed: " + input + ", taskId: " + editorId, (Throwable)e));
            return null;
        }
    }

    public static int openEditRepositoryWizard(TaskRepository repository) {
        block5: {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
            if (connector == null || !connector.isUserManaged() && !connector.getConnectorKind().equals("local")) {
                return 1;
            }
            EditRepositoryWizard wizard = new EditRepositoryWizard(repository);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (shell == null || shell.isDisposed()) break block5;
            TaskRepositoryWizardDialog dialog = new TaskRepositoryWizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.setBlockOnOpen(true);
            if (dialog.open() != 1) break block5;
            dialog.close();
            return 1;
        }
        try {
            if (TaskRepositoriesView.getFromActivePerspective() != null) {
                TaskRepositoriesView.getFromActivePerspective().getViewer().refresh();
            }
        }
        catch (Exception e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
        }
        return 0;
    }

    public static boolean openNewLocalTaskEditor(Shell shell, ITaskMapping taskSelection) {
        return TasksUiUtil.openNewTaskEditor(shell, (IWizard)new NewLocalTaskWizard(taskSelection), taskSelection);
    }

    private static boolean openNewTaskEditor(Shell shell, IWizard wizard, ITaskMapping taskSelection) {
        WizardDialog dialog = new WizardDialog(shell, wizard);
        dialog.setBlockOnOpen(true);
        dialog.create();
        if (!(wizard instanceof MultiRepositoryAwareWizard) && wizard.canFinish()) {
            wizard.performFinish();
            return true;
        }
        int result = dialog.open();
        return result == 0;
    }

    public static boolean openNewTaskEditor(Shell shell, ITaskMapping taskSelection, TaskRepository taskRepository) {
        MultiRepositoryAwareWizard wizard;
        List repositories = TasksUi.getRepositoryManager().getAllRepositories();
        if (taskRepository == null && repositories.size() == 1) {
            taskRepository = (TaskRepository)repositories.get(0);
        }
        if (taskRepository != null) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
            wizard = connectorUi.getNewTaskWizard(taskRepository, taskSelection);
        } else {
            wizard = TasksUiInternal.createNewTaskWizard(taskSelection);
        }
        return TasksUiUtil.openNewTaskEditor(shell, (IWizard)wizard, taskSelection);
    }

    @Deprecated
    public static boolean openRepositoryTask(String repositoryUrl, String taskId, String fullUrl) {
        return TasksUiUtil.openTask(repositoryUrl, taskId, fullUrl);
    }

    @Deprecated
    public static boolean openRepositoryTask(TaskRepository repository, String taskId) {
        return TasksUiUtil.openTask(repository, taskId);
    }

    public static boolean openTask(ITask task) {
        Assert.isNotNull((Object)task);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            boolean openWithBrowser;
            boolean bl = openWithBrowser = !TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor");
            if (openWithBrowser) {
                TasksUiUtil.openUrl(task.getUrl());
                return true;
            }
            TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
            TaskEditorInput editorInput = new TaskEditorInput(taskRepository, task);
            boolean wasOpen = TasksUiUtil.refreshEditorContentsIfOpen(task, editorInput);
            if (wasOpen) {
                TasksUiUtil.synchronizeTask(taskRepository, task);
                return true;
            }
            IWorkbenchPage page = window.getActivePage();
            IEditorPart editor = TasksUiUtil.openEditor(editorInput, TasksUiUtil.getTaskEditorId(task), page);
            if (editor != null) {
                TasksUiUtil.synchronizeTask(taskRepository, task);
                return true;
            }
        } else {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to open editor for \"" + task.getSummary() + "\": no active workbench window"));
        }
        return false;
    }

    private static void synchronizeTask(TaskRepository taskRepository, ITask task) {
        if (task instanceof LocalTask) {
            return;
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
        if (connector.canSynchronizeTask(taskRepository, task)) {
            TasksUiInternal.synchronizeTask(connector, task, false, null);
        }
    }

    public static void openTask(String url) {
        AbstractTask task = TasksUiInternal.getTaskByUrl(url);
        if (task != null && !(task instanceof LocalTask)) {
            TasksUiUtil.openTask((ITask)task);
        } else {
            TaskRepository repository;
            String id;
            String repositoryUrl;
            AbstractRepositoryConnector connector;
            boolean opened = false;
            if (url != null && (connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(url)) != null && (repositoryUrl = connector.getRepositoryUrlFromTaskUrl(url)) != null && (id = connector.getTaskIdFromTaskUrl(url)) != null && (repository = TasksUi.getRepositoryManager().getRepository(connector.getConnectorKind(), repositoryUrl)) != null) {
                opened = TasksUiUtil.openTask(repository, id);
            }
            if (!opened) {
                WorkbenchUtil.openUrl((String)url, (int)0);
            }
        }
    }

    public static boolean openTask(String repositoryUrl, String taskId, String fullUrl) {
        AbstractTask task = TasksUiInternal.getTask(repositoryUrl, taskId, fullUrl);
        if (task != null) {
            return TasksUiUtil.openTask((ITask)task);
        }
        boolean opened = false;
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(fullUrl);
        if (connector != null) {
            if (repositoryUrl != null && taskId != null) {
                opened = TasksUiInternal.openRepositoryTask(connector.getConnectorKind(), repositoryUrl, taskId);
            } else {
                repositoryUrl = connector.getRepositoryUrlFromTaskUrl(fullUrl);
                taskId = connector.getTaskIdFromTaskUrl(fullUrl);
                if (repositoryUrl != null && taskId != null) {
                    opened = TasksUiInternal.openRepositoryTask(connector.getConnectorKind(), repositoryUrl, taskId);
                }
            }
        }
        if (!opened) {
            TasksUiUtil.openUrl(fullUrl);
        }
        return true;
    }

    public static boolean openTask(TaskRepository repository, String taskId) {
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)taskId);
        AbstractTask task = (AbstractTask)TasksUiInternal.getTaskList().getTask(repository.getRepositoryUrl(), taskId);
        if (task == null) {
            task = TasksUiPlugin.getTaskList().getTaskByKey(repository.getRepositoryUrl(), taskId);
        }
        if (task != null) {
            return TasksUiUtil.openTask((ITask)task);
        }
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
        if (connectorUi != null) {
            try {
                return TasksUiInternal.openRepositoryTask(connectorUi.getConnectorKind(), repository.getRepositoryUrl(), taskId);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Internal error while opening repository task", (Throwable)e));
            }
        }
        return false;
    }

    public static void openUrl(String location) {
        WorkbenchUtil.openUrl((String)location, (int)131072);
    }

    private static boolean refreshEditorContentsIfOpen(ITask task, IEditorInput editorInput) {
        if (task != null && (task.getSynchronizationState() == ITask.SynchronizationState.INCOMING || task.getSynchronizationState() == ITask.SynchronizationState.CONFLICT)) {
            for (TaskEditor editor : TasksUiInternal.getActiveRepositoryTaskEditors()) {
                if (!editor.getEditorInput().equals(editorInput)) continue;
                editor.refreshPages();
                editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
                return true;
            }
        }
        return false;
    }

    public static IViewPart openTasksViewInActivePerspective() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.mylyn.tasks.ui.views.tasks");
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not show Task List view", (Throwable)e));
            return null;
        }
    }
}

