/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorOutlineNode;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class TaskEditorOutlinePage
extends ContentOutlinePage {
    private TaskEditorOutlineModel model;
    private TaskRepository taskRepository;
    private TreeViewer viewer;

    public void setInput(TaskRepository taskRepository, TaskEditorOutlineNode rootNode) {
        this.taskRepository = taskRepository;
        this.model = rootNode != null ? new TaskEditorOutlineModel(rootNode) : null;
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.model);
            this.viewer.refresh(true);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new TaskEditorOutlineContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof TaskEditorOutlineNode) {
                    TaskEditorOutlineNode node = (TaskEditorOutlineNode)element;
                    if (TaskEditorOutlineNode.LABEL_COMMENTS.equals(node.getLabel()) || TaskEditorOutlineNode.LABEL_NEW_COMMENT.equals(node.getLabel())) {
                        return CommonImages.getImage((ImageDescriptor)TasksUiImages.COMMENT);
                    }
                    if (TaskEditorOutlineNode.LABEL_DESCRIPTION.equals(node.getLabel())) {
                        return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_NOTES);
                    }
                    if (node.getTaskComment() != null) {
                        IRepositoryPerson author = node.getTaskComment().getAuthor();
                        if (TaskEditorOutlinePage.this.taskRepository != null && author != null && author.getPersonId().equals(TaskEditorOutlinePage.this.taskRepository.getUserName())) {
                            return CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME);
                        }
                        return CommonImages.getImage((ImageDescriptor)CommonImages.PERSON);
                    }
                    return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK);
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof TaskEditorOutlineNode) {
                    TaskEditorOutlineNode node = (TaskEditorOutlineNode)element;
                    return node.getLabel();
                }
                return super.getText(element);
            }
        });
        this.viewer.setInput((Object)this.model);
        this.viewer.expandAll();
    }

    private static class TaskEditorOutlineContentProvider
    implements ITreeContentProvider {
        private TaskEditorOutlineContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TaskEditorOutlineNode) {
                Object[] children = ((TaskEditorOutlineNode)parentElement).getChildren();
                return children;
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TaskEditorOutlineModel) {
                return new Object[]{((TaskEditorOutlineModel)inputElement).getRoot()};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof TaskEditorOutlineNode) {
                return ((TaskEditorOutlineNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TaskEditorOutlineNode) {
                return ((TaskEditorOutlineNode)element).getChildren().length > 0;
            }
            return false;
        }

        public void inputChanged(Viewer viewerChanged, Object oldInput, Object newInput) {
        }
    }

    private static class TaskEditorOutlineModel {
        private final TaskEditorOutlineNode root;

        public TaskEditorOutlineModel(TaskEditorOutlineNode root) {
            this.root = root;
        }

        public TaskEditorOutlineNode getRoot() {
            return this.root;
        }
    }
}

