/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskEditorOutlineNode {
    public static final String LABEL_COMMENTS = Messages.TaskEditorOutlineNode_Comments;
    public static final String LABEL_DESCRIPTION = Messages.TaskEditorOutlineNode_Description;
    public static final String LABEL_NEW_COMMENT = Messages.TaskEditorOutlineNode_New_Comment;
    private List<TaskEditorOutlineNode> children;
    private final String label;
    private TaskEditorOutlineNode parent;
    private final TaskAttribute taskAttribute;
    private ITaskComment taskComment;

    private static TaskEditorOutlineNode createNode(TaskData taskData, String attributeId, String label) {
        TaskAttribute taskAttribute = taskData.getRoot().getMappedAttribute(attributeId);
        if (taskAttribute != null) {
            if (label == null) {
                label = taskAttribute.getValue();
            }
            return new TaskEditorOutlineNode(label, taskAttribute);
        }
        return null;
    }

    private static TaskEditorOutlineNode createNode(TaskAttribute taskAttribute) {
        String type = taskAttribute.getMetaData().getType();
        if ("comment".equals(type)) {
            ITaskComment taskComment = TasksUiPlugin.getRepositoryModel().createTaskComment(taskAttribute);
            if (taskComment != null) {
                Date creationDate;
                taskAttribute.getTaskData().getAttributeMapper().updateTaskComment(taskComment, taskAttribute);
                StringBuilder sb = new StringBuilder();
                sb.append(taskComment.getNumber());
                sb.append(": ");
                IRepositoryPerson author = taskComment.getAuthor();
                if (author != null) {
                    sb.append(author.toString());
                }
                if ((creationDate = taskComment.getCreationDate()) != null) {
                    sb.append(" (");
                    sb.append(EditorUtil.formatDateTime(creationDate));
                    sb.append(")");
                }
                TaskEditorOutlineNode node = new TaskEditorOutlineNode(sb.toString(), taskAttribute);
                node.setTaskComment(taskComment);
                return node;
            }
        } else {
            String label = taskAttribute.getTaskData().getAttributeMapper().getValueLabel(taskAttribute);
            return new TaskEditorOutlineNode(label, taskAttribute);
        }
        return null;
    }

    public static TaskEditorOutlineNode parse(TaskData taskData) {
        TaskEditorOutlineNode rootNode = TaskEditorOutlineNode.createNode(taskData, "task.common.summary", null);
        if (rootNode == null) {
            rootNode = new TaskEditorOutlineNode(String.valueOf(Messages.TaskEditorOutlineNode_Task_) + taskData.getTaskId());
        }
        TaskEditorOutlineNode.addNode(rootNode, taskData, "task.common.description", LABEL_DESCRIPTION);
        List comments = taskData.getAttributeMapper().getAttributesByType(taskData, "comment");
        if (comments.size() > 0) {
            TaskEditorOutlineNode commentsNode = new TaskEditorOutlineNode(LABEL_COMMENTS);
            rootNode.addChild(commentsNode);
            for (TaskAttribute commentAttribute : comments) {
                TaskEditorOutlineNode node = TaskEditorOutlineNode.createNode(commentAttribute);
                if (node == null) continue;
                commentsNode.addChild(node);
            }
        }
        TaskEditorOutlineNode.addNode(rootNode, taskData, "task.common.comment.new", LABEL_NEW_COMMENT);
        return rootNode;
    }

    private static TaskEditorOutlineNode addNode(TaskEditorOutlineNode parentNode, TaskData taskData, String attributeId, String label) {
        TaskEditorOutlineNode node = TaskEditorOutlineNode.createNode(taskData, attributeId, label);
        if (node != null) {
            parentNode.addChild(node);
        }
        return node;
    }

    public TaskEditorOutlineNode(String label) {
        this(label, null);
    }

    public TaskEditorOutlineNode(String label, TaskAttribute taskAttribute) {
        this.label = label;
        this.taskAttribute = taskAttribute;
    }

    public void addChild(TaskEditorOutlineNode node) {
        Assert.isNotNull((Object)node);
        if (this.children == null) {
            this.children = new ArrayList<TaskEditorOutlineNode>();
        }
        node.parent = this;
        this.children.add(node);
    }

    public boolean equals(Object o) {
        if (o instanceof TaskEditorOutlineNode) {
            TaskEditorOutlineNode node = (TaskEditorOutlineNode)o;
            return this.getLabel().equals(node.getLabel());
        }
        return false;
    }

    public TaskEditorOutlineNode[] getChildren() {
        return this.children == null ? new TaskEditorOutlineNode[]{} : this.children.toArray(new TaskEditorOutlineNode[this.children.size()]);
    }

    public ITaskComment getTaskComment() {
        return this.taskComment;
    }

    public void setTaskComment(ITaskComment taskComment) {
        this.taskComment = taskComment;
    }

    public TaskAttribute getData() {
        return this.taskAttribute;
    }

    public String getLabel() {
        return this.label;
    }

    public TaskEditorOutlineNode getParent() {
        return this.parent;
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public String toString() {
        return this.getLabel();
    }
}

