/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.SortedSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractTaskRepositoryPageContribution;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class TaskEditorExtensionSettingsContribution
extends AbstractTaskRepositoryPageContribution {
    private static final String LABEL_NONE = Messages.TaskEditorExtensionSettingsContribution_Plain_Text;
    private static final String LABEL_DEFAULT_SUFFIX = Messages.TaskEditorExtensionSettingsContribution__default_;
    private static final String DATA_EDITOR_EXTENSION = "editorExtension";
    private final SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TaskEditorExtensionSettingsContribution.this.selectedExtensionId = (String)((Widget)e.getSource()).getData(TaskEditorExtensionSettingsContribution.DATA_EDITOR_EXTENSION);
            TaskEditorExtensionSettingsContribution.this.fireValidationRequired();
        }
    };
    private String selectedExtensionId;

    public TaskEditorExtensionSettingsContribution() {
        super(Messages.TaskEditorExtensionSettingsContribution_Editor, Messages.TaskEditorExtensionSettingsContribution_Select_the_capabilities_of_the_task_editor);
    }

    public void applyTo(TaskRepository repository) {
        TaskEditorExtensions.setTaskEditorExtensionId(repository, this.selectedExtensionId == null ? "none" : this.selectedExtensionId);
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public boolean isPageComplete() {
        return true;
    }

    public Control createControl(Composite parentControl) {
        boolean isDefault;
        Composite parent = new Composite(parentControl, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        String defaultExtensionId = TaskEditorExtensions.getDefaultTaskEditorExtensionId(this.getConnectorKind());
        this.selectedExtensionId = this.getRepository() == null ? defaultExtensionId : TaskEditorExtensions.getTaskEditorExtensionId(this.getRepository());
        Button noneButton = new Button(parent, 16);
        String noneTitle = LABEL_NONE;
        boolean bl = isDefault = defaultExtensionId == null || defaultExtensionId.length() == 0;
        if (isDefault) {
            noneTitle = String.valueOf(noneTitle) + LABEL_DEFAULT_SUFFIX;
        }
        noneButton.setText(noneTitle);
        noneButton.addSelectionListener(this.listener);
        boolean foundSelection = false;
        SortedSet<TaskEditorExtensions.RegisteredTaskEditorExtension> allEditorExtensions = TaskEditorExtensions.getTaskEditorExtensions();
        for (TaskEditorExtensions.RegisteredTaskEditorExtension editorExtension : allEditorExtensions) {
            if (!WorkbenchUtil.allowUseOf((Object)editorExtension)) continue;
            String name = editorExtension.getName();
            isDefault = editorExtension.getId().equals(defaultExtensionId);
            if (isDefault) {
                name = String.valueOf(name) + LABEL_DEFAULT_SUFFIX;
            }
            Button button = new Button(parent, 16);
            button.setText(name);
            if (editorExtension.getId().equals(this.selectedExtensionId)) {
                foundSelection = true;
                button.setSelection(true);
            }
            button.setText(name);
            button.setData(DATA_EDITOR_EXTENSION, (Object)editorExtension.getId());
            button.addSelectionListener(this.listener);
        }
        if (!foundSelection) {
            noneButton.setSelection(true);
        }
        return parent;
    }

    public IStatus validate() {
        return null;
    }

    public boolean isEnabled() {
        return !TaskEditorExtensions.getTaskEditorExtensions().isEmpty();
    }
}

