/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.commands;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.commands.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskAttachmentEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenTaskAttachmentInDefaultEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage page = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            List items = ((IStructuredSelection)selection).toList();
            for (Object item : items) {
                IWorkbenchWindow window;
                if (!(item instanceof ITaskAttachment)) continue;
                if (page == null && (page = (window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event)).getActivePage()) == null) {
                    throw new ExecutionException("No active workbench page");
                }
                this.openAttachment(page, (ITaskAttachment)item);
            }
        }
        return null;
    }

    private void openAttachment(IWorkbenchPage page, ITaskAttachment attachment) throws ExecutionException {
        TaskAttachmentEditorInput input = new TaskAttachmentEditorInput(attachment);
        IEditorDescriptor description = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(input.getName());
        if (description == null) {
            TasksUiInternal.displayStatus(Messages.OpenTaskAttachmentInDefaultEditorHandler_Open_Attachment_Failed, (IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", MessageFormat.format(Messages.OpenTaskAttachmentInDefaultEditorHandler_No_default_editor_for_X_found, input.getName())));
        } else {
            try {
                page.openEditor((IEditorInput)input, description.getId());
            }
            catch (PartInitException e) {
                throw new ExecutionException(Messages.OpenTaskAttachmentInDefaultEditorHandler_Failed_to_open_editor, (Throwable)e);
            }
        }
    }
}

